/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.configlib.toml;

import com.supermartijn642.configlib.BaseConfigEntry;
import com.supermartijn642.configlib.toml.TomlElement;
import com.supermartijn642.configlib.toml.TomlPrimitive;
import java.nio.ByteBuffer;

public class TomlIntegerConfigEntry
extends BaseConfigEntry<Integer, TomlElement> {
    private final int minimum;
    private final int maximum;

    public TomlIntegerConfigEntry(Integer defaultValue, int minimum, int maximum, boolean shouldBeSynced, boolean requiresGameRestart, boolean isClientOnly, boolean isServerOnly, String comment) {
        super(defaultValue, shouldBeSynced, requiresGameRestart, isClientOnly, isServerOnly, comment);
        this.minimum = minimum;
        this.maximum = maximum;
    }

    @Override
    public String getAllowedValuesHint() {
        return "Allowed range: " + this.minimum + " ~ " + this.maximum + " - Default: " + String.valueOf(this.defaultValue);
    }

    @Override
    public boolean validateValue(Integer value) {
        return value >= this.minimum && value <= this.maximum;
    }

    @Override
    public TomlElement serialize(Integer value) {
        return TomlPrimitive.of(value);
    }

    @Override
    public Integer deserialize(TomlElement serialized) {
        return serialized.isInteger() ? Integer.valueOf(serialized.getAsInteger()) : null;
    }

    @Override
    public byte[] write(Integer value) {
        return ByteBuffer.allocate(4).putInt(value).array();
    }

    @Override
    public Integer read(ByteBuffer buffer) {
        return buffer.getInt();
    }
}

