/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.world;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.litematica.render.IWorldSchematicRenderer;
import fi.dy.masa.litematica.world.ChunkManagerSchematic;
import fi.dy.masa.litematica.world.ChunkSchematic;
import fi.dy.masa.litematica.world.SchematicEntityLookup;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.malilib.util.WorldUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.class_10286;
import net.minecraft.class_11749;
import net.minecraft.class_12205;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1508;
import net.minecraft.class_1657;
import net.minecraft.class_1845;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_22;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_269;
import net.minecraft.class_2784;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3568;
import net.minecraft.class_3611;
import net.minecraft.class_5217;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_5362;
import net.minecraft.class_5455;
import net.minecraft.class_5575;
import net.minecraft.class_5577;
import net.minecraft.class_5712;
import net.minecraft.class_6012;
import net.minecraft.class_6754;
import net.minecraft.class_6756;
import net.minecraft.class_6880;
import net.minecraft.class_7134;
import net.minecraft.class_7699;
import net.minecraft.class_7924;
import net.minecraft.class_8921;
import net.minecraft.class_9209;
import net.minecraft.class_9895;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NonNull;

public class WorldSchematic
extends class_1937 {
    protected static final class_5321<class_1937> REGISTRY_KEY = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60655((String)"litematica", (String)"schematic_world"));
    protected final class_310 mc = class_310.method_1551();
    protected final ChunkManagerSchematic chunkManagerSchematic;
    @Nullable
    protected final IWorldSchematicRenderer worldRenderer;
    private final class_8921 tickManager;
    private final class_6880<class_2874> dimensionType;
    private final SchematicEntityLookup<class_1297> entityLookup;
    protected class_6880<class_1959> biome;
    private class_5217.class_12064 properties;
    protected int nextEntityId;

    public WorldSchematic(class_5269 properties, @Nonnull class_5455 registryManager, class_6880<class_2874> dimension, @Nullable IWorldSchematicRenderer worldRenderer) {
        super(properties, REGISTRY_KEY, !registryManager.equals((Object)class_5455.field_40585) ? registryManager : SchematicWorldHandler.INSTANCE.getRegistryManager(), dimension, true, false, 0L, 0);
        if (this.mc == null || this.mc.field_1687 == null) {
            throw new RuntimeException("WorldSchematic invoked when MinecraftClient.getInstance() or mc.world is null");
        }
        this.worldRenderer = worldRenderer;
        this.chunkManagerSchematic = new ChunkManagerSchematic(this);
        this.dimensionType = dimension;
        if (!registryManager.equals((Object)class_5455.field_40585)) {
            this.setDimension(registryManager);
        } else {
            this.setDimension(this.mc.field_1687.method_30349());
        }
        this.tickManager = new class_8921();
        this.entityLookup = new SchematicEntityLookup();
        this.properties = class_5217.class_12064.field_63048;
    }

    public String toString() {
        return "SchematicWorld[" + REGISTRY_KEY.method_29177().toString() + "]";
    }

    private void setDimension(class_5455 registryManager) {
        registryManager.method_46759(class_7924.field_41241).ifPresent(entryLookup -> {
            class_6880 nether = entryLookup.method_46746(class_7134.field_37667).orElse(null);
            class_6880 end = entryLookup.method_46746(class_7134.field_37668).orElse(null);
            this.biome = nether != null && this.dimensionType.equals((Object)nether) ? WorldUtils.getWastes((class_5455)registryManager) : (end != null && this.dimensionType.equals((Object)end) ? WorldUtils.getTheEnd((class_5455)registryManager) : WorldUtils.getPlains((class_5455)registryManager));
        });
    }

    @Deprecated(forRemoval=true)
    public ChunkManagerSchematic getChunkProvider() {
        return this.getChunkSource();
    }

    @Nonnull
    public ChunkManagerSchematic getChunkSource() {
        return this.chunkManagerSchematic;
    }

    @Nonnull
    public class_8921 method_54719() {
        return this.tickManager;
    }

    @Nullable
    public class_22 method_17891(@NonNull class_9209 id) {
        return null;
    }

    @Nonnull
    public class_6756<class_2248> method_8397() {
        return class_6754.method_39362();
    }

    @Nonnull
    public class_6756<class_3611> method_8405() {
        return class_6754.method_39362();
    }

    public int getRegularEntityCount() {
        return this.entityLookup.size();
    }

    public String getEntityDebug() {
        return String.format("%s", this.entityLookup.getDebugString());
    }

    @Nonnull
    public class_2818 method_8500(class_2338 pos) {
        return this.getChunk(pos.method_10263() >> 4, pos.method_10260() >> 4);
    }

    @Nonnull
    public ChunkSchematic getChunk(int chunkX, int chunkZ) {
        return this.chunkManagerSchematic.getChunkForLighting(chunkX, chunkZ);
    }

    public class_2791 method_8402(int chunkX, int chunkZ, @Nonnull class_2806 status, boolean required) {
        return this.getChunk(chunkX, chunkZ);
    }

    @Nonnull
    public class_6880<class_1959> method_22387(int biomeX, int biomeY, int biomeZ) {
        return this.biome;
    }

    public int method_8615() {
        if (this.mc != null && this.mc.field_1687 != null) {
            return this.mc.field_1687.method_8615();
        }
        return 0;
    }

    public boolean method_8652(class_2338 pos, @Nonnull class_2680 newState, int flags) {
        if (pos.method_10264() < this.method_31607() || pos.method_10264() >= this.method_31600()) {
            return false;
        }
        return this.getChunk(pos.method_10263() >> 4, pos.method_10260() >> 4).method_12010(pos, newState, 3) != null;
    }

    public boolean method_8649(class_1297 entity) {
        int chunkX = class_3532.method_15357((double)(entity.method_23317() / 16.0));
        int chunkZ = class_3532.method_15357((double)(entity.method_23321() / 16.0));
        if (this.entityLookup.contains(entity.method_5667())) {
            class_1297 e = this.entityLookup.method_31808(entity.method_5667());
            if (e != null && e.method_5864().equals(entity.method_5864())) {
                if (e.method_73189().equals((Object)entity.method_73189())) {
                    return false;
                }
                this.entityLookup.remove(entity.method_5667());
            } else {
                return false;
            }
        }
        class_1923 chunkPos = new class_1923(chunkX, chunkZ);
        if (this.entityLookup.contains(entity.method_5628()) || entity.method_5628() < 0) {
            entity.method_5838(this.nextEntityId++);
        }
        this.entityLookup.put(entity, chunkPos);
        return true;
    }

    public void unloadEntitiesByChunk(int chunkX, int chunkZ) {
        if (!this.method_8393(chunkX, chunkZ)) {
            return;
        }
        class_1923 pos = new class_1923(chunkX, chunkZ);
        int count = this.entityLookup.removeByChunk(pos);
        this.checkForStaleEntities();
    }

    private void checkForStaleEntities() {
        if (this.entityLookup.size() < 1) {
            this.entityLookup.reset();
            this.nextEntityId = 0;
        }
    }

    @Nullable
    public class_1297 method_8469(int id) {
        return (class_1297)this.method_31592().method_31804(id);
    }

    @Nullable
    public class_1297 method_66347(@Nonnull UUID uuid) {
        return (class_1297)this.method_31592().method_31808(uuid);
    }

    protected void closeEntityLookup() throws Exception {
        this.entityLookup.close();
    }

    public void clearEntities() {
        try {
            this.closeEntityLookup();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.nextEntityId = 0;
    }

    @Nonnull
    public Collection<class_1508> method_65097() {
        return List.of();
    }

    @Nonnull
    public List<? extends class_1657> method_18456() {
        return ImmutableList.of();
    }

    public long method_75260() {
        return this.mc.field_1687 != null ? this.mc.field_1687.method_75260() : 0L;
    }

    @Nonnull
    public class_269 method_8428() {
        return this.mc.field_1687 != null ? this.mc.field_1687.method_8428() : null;
    }

    @Nonnull
    public class_10286 method_8433() {
        return this.mc.field_1687 != null ? this.mc.field_1687.method_8433() : null;
    }

    @Nonnull
    protected class_5577<class_1297> method_31592() {
        return this.entityLookup;
    }

    public ImmutableList<class_1297> getEntitiesByChunk(int cx, int cz, @Nonnull Predicate<? super class_1297> predicate) {
        if (!this.method_8393(cx, cz)) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (class_1297 e : this.entityLookup.getAllByChunk(new class_1923(cx, cz))) {
            if (e == null || !predicate.test((class_1297)e)) continue;
            builder.add((Object)e);
        }
        return builder.build();
    }

    @Nonnull
    public List<class_1297> method_8333(@Nullable class_1297 except, @Nonnull class_238 box, @Nonnull Predicate<? super class_1297> predicate) {
        ArrayList<class_1297> list = new ArrayList<class_1297>();
        this.method_31592().method_31807(box, e -> {
            if (e != except && predicate.test((class_1297)e)) {
                list.add((class_1297)e);
            }
        });
        return list;
    }

    @Nonnull
    public <T extends class_1297> List<T> method_18023(@Nonnull class_5575<class_1297, T> arg, @Nonnull class_238 box, @Nonnull Predicate<? super T> predicate) {
        ArrayList<class_1297> list = new ArrayList<class_1297>();
        for (class_1297 e2 : this.method_18023(arg, box, e -> true)) {
            class_1297 t = (class_1297)arg.method_31796((Object)e2);
            if (t == null || !predicate.test(t)) continue;
            list.add(t);
        }
        return list;
    }

    public List<ChunkSchematic> getChunksWithinBox(class_238 box) {
        int minX = class_3532.method_15357((double)(box.field_1323 / 16.0));
        int minZ = class_3532.method_15357((double)(box.field_1321 / 16.0));
        int maxX = class_3532.method_15357((double)(box.field_1320 / 16.0));
        int maxZ = class_3532.method_15357((double)(box.field_1324 / 16.0));
        ArrayList<ChunkSchematic> chunks = new ArrayList<ChunkSchematic>();
        for (int cx = minX; cx <= maxX; ++cx) {
            for (int cz = minZ; cz <= maxZ; ++cz) {
                ChunkSchematic chunk = this.chunkManagerSchematic.getChunkIfExists(cx, cz);
                if (chunk == null) continue;
                chunks.add(chunk);
            }
        }
        return chunks;
    }

    public void method_16109(@Nonnull class_2338 pos, @Nonnull class_2680 stateOld, @Nonnull class_2680 stateNew) {
        if (stateNew != stateOld) {
            this.scheduleChunkRenders(pos.method_10263() >> 4, pos.method_10260() >> 4, true);
        }
    }

    public void method_8465(@Nullable class_1297 source, double x, double y, double z, @Nonnull class_6880<class_3414> sound, @Nonnull class_3419 category, float volume, float pitch, long seed) {
    }

    public void method_8449(@Nullable class_1297 source, @Nonnull class_1297 entity, @Nonnull class_6880<class_3414> sound, @Nonnull class_3419 category, float volume, float pitch, long seed) {
    }

    public void method_8454(@Nullable class_1297 entity, @Nullable class_1282 damageSource, @Nullable class_5362 behavior, double x, double y, double z, float power, boolean createFire, @Nonnull class_1937.class_7867 explosionSourceType, @Nonnull class_2394 smallParticle, @Nonnull class_2394 largeParticle, @Nonnull class_6012<class_11749> blockParticles, @Nonnull class_6880<class_3414> soundEvent) {
    }

    public void scheduleChunkRenders(int chunkX, int chunkZ) {
        this.scheduleChunkRenders(chunkX, chunkZ, false);
    }

    public void scheduleChunkRenders(int chunkX, int chunkZ, boolean immediate) {
        if (this.worldRenderer != null) {
            this.worldRenderer.scheduleChunkRenders(chunkX, chunkZ, immediate);
        }
    }

    public int method_31607() {
        return this.mc.field_1687 != null ? this.mc.field_1687.method_31607() : -64;
    }

    public int method_31605() {
        return this.mc.field_1687 != null ? this.mc.field_1687.method_31605() : 384;
    }

    public int method_31600() {
        return this.method_31607() + this.method_31605();
    }

    public int method_32891() {
        return this.method_31607() >> 4;
    }

    public int method_31597() {
        return this.method_31600() >> 4;
    }

    public int method_32890() {
        return this.method_31597() - this.method_32891();
    }

    public boolean method_31606(class_2338 pos) {
        return this.method_31601(pos.method_10264());
    }

    public boolean method_31601(int y) {
        return y < this.method_31607() || y >= this.method_31600();
    }

    public int method_31602(int y) {
        return (y >> 4) - (this.method_31607() >> 4);
    }

    public int method_31603(int coord) {
        return coord - (this.method_31607() >> 4);
    }

    public int method_31604(int index) {
        return index + (this.method_31607() >> 4);
    }

    public class_6880<class_2874> getDimensionType() {
        return this.dimensionType;
    }

    public float method_24852(@Nonnull class_2350 direction, boolean shaded) {
        class_2874.class_12325 cardinalLightType = this.method_8597().comp_5221();
        if (!shaded) {
            return cardinalLightType == class_2874.class_12325.field_64381 ? 0.9f : 1.0f;
        }
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033 -> {
                if (cardinalLightType == class_2874.class_12325.field_64381) {
                    yield 0.9f;
                }
                yield 0.5f;
            }
            case class_2350.field_11036 -> {
                if (cardinalLightType == class_2874.class_12325.field_64381) {
                    yield 0.9f;
                }
                yield 1.0f;
            }
            case class_2350.field_11043, class_2350.field_11035 -> 0.8f;
            case class_2350.field_11039, class_2350.field_11034 -> 0.6f;
        };
    }

    @Nonnull
    public class_3568 method_22336() {
        return this.getChunkSource().method_12130();
    }

    public void method_8413(@Nonnull class_2338 blockPos_1, @Nonnull class_2680 blockState_1, @Nonnull class_2680 blockState_2, int flags) {
    }

    public void method_8517(int entityId, @Nonnull class_2338 pos, int progress) {
    }

    public void method_8474(int eventId, @Nonnull class_2338 pos, int data) {
    }

    public void method_32888(@Nonnull class_6880<class_5712> event, @Nonnull class_243 emitterPos, @Nonnull class_5712.class_7397 emitter) {
    }

    public void method_8444(@Nullable class_1297 entity, int eventId, @Nonnull class_2338 pos, int data) {
    }

    @Nonnull
    public class_5455 method_30349() {
        if (this.mc != null && this.mc.field_1687 != null) {
            return this.mc.field_1687.method_30349();
        }
        if (!SchematicWorldHandler.INSTANCE.getRegistryManager().equals((Object)class_5455.field_40585)) {
            return SchematicWorldHandler.INSTANCE.getRegistryManager();
        }
        return class_5455.field_40585;
    }

    public @NonNull class_12205 method_75728() {
        if (this.mc != null && this.mc.field_1687 != null) {
            return this.mc.field_1687.method_75728();
        }
        return null;
    }

    @Nonnull
    public class_1845 method_59547() {
        if (this.mc != null && this.mc.field_1687 != null) {
            return this.mc.field_1687.method_59547();
        }
        return class_1845.field_51402;
    }

    @Nonnull
    public class_9895 method_61269() {
        if (this.mc != null && this.mc.field_1687 != null) {
            return this.mc.field_1687.method_61269();
        }
        return null;
    }

    @Nonnull
    public class_7699 method_45162() {
        if (this.mc != null && this.mc.field_1687 != null) {
            return this.mc.field_1687.method_45162();
        }
        return class_7699.method_45397();
    }

    @Nonnull
    public String method_31419() {
        return "Chunks[SCH] W: " + this.getChunkSource().method_12122() + " E: " + this.getRegularEntityCount() + " (eL: " + this.entityLookup.size() + ")";
    }

    public void method_27873(class_5217.class_12064 arg) {
        this.properties = new class_5217.class_12064(arg.comp_4915(), arg.comp_4917(), arg.comp_4916());
    }

    @Nonnull
    public class_5217.class_12064 method_74854() {
        return this.properties;
    }

    public void method_43275(@Nullable class_1297 entity, @Nonnull class_6880<class_5712> event, @Nonnull class_243 pos) {
    }

    public void method_33596(@Nullable class_1297 entity, @Nonnull class_6880<class_5712> event, @Nonnull class_2338 pos) {
    }

    public void method_55764(@Nonnull class_5321<class_5712> event, @Nonnull class_2338 pos, @Nullable class_5712.class_7397 emitter) {
    }

    @Nonnull
    public class_2784 method_8621() {
        return new class_2784();
    }
}

