/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.world;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.class_1923;
import net.minecraft.class_238;
import net.minecraft.class_5568;
import net.minecraft.class_5575;
import net.minecraft.class_5577;
import net.minecraft.class_7927;
import org.jetbrains.annotations.Nullable;

public class SchematicEntityLookup<T extends class_5568>
implements class_5577<T>,
AutoCloseable {
    private final ConcurrentHashMap<Integer, T> entityMap = new ConcurrentHashMap(128, 0.9f, 1);
    private final ConcurrentHashMap<UUID, Integer> uuidMap = new ConcurrentHashMap(128, 0.9f, 1);
    private final ConcurrentHashMap<Long, List<UUID>> chunkMap = new ConcurrentHashMap(128, 0.9f, 1);

    protected SchematicEntityLookup() {
    }

    protected String getDebugString() {
        return String.format("E: %02d, U: %02d, C: %02d", this.entityMap.size(), this.uuidMap.size(), this.chunkMap.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void put(T entity, class_1923 pos) {
        T tmp = this.method_31808(entity.method_5667());
        if (tmp != null) {
            this.remove(entity.method_5667());
        }
        ConcurrentHashMap<Comparable<Long>, Object> concurrentHashMap = this.chunkMap;
        synchronized (concurrentHashMap) {
            List list = this.chunkMap.getOrDefault(pos.method_8324(), new ArrayList());
            list.add(entity.method_5667());
            this.chunkMap.put(pos.method_8324(), list);
        }
        concurrentHashMap = this.uuidMap;
        synchronized (concurrentHashMap) {
            this.uuidMap.put(entity.method_5667(), entity.method_5628());
        }
        concurrentHashMap = this.entityMap;
        synchronized (concurrentHashMap) {
            this.entityMap.put(entity.method_5628(), entity);
        }
    }

    protected synchronized int size() {
        return this.entityMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean remove(UUID uuid) {
        Integer key = this.uuidMap.get(uuid);
        ConcurrentHashMap<Comparable<Long>, Object> concurrentHashMap = this.chunkMap;
        synchronized (concurrentHashMap) {
            for (Long longPos : this.chunkMap.keySet()) {
                List<UUID> list = this.chunkMap.get(longPos);
                if (!list.remove(uuid)) continue;
                if (list.isEmpty()) {
                    this.chunkMap.remove(longPos);
                    continue;
                }
                this.chunkMap.put(longPos, list);
            }
        }
        if (key != null) {
            concurrentHashMap = this.uuidMap;
            synchronized (concurrentHashMap) {
                this.uuidMap.remove(uuid);
            }
            concurrentHashMap = this.entityMap;
            synchronized (concurrentHashMap) {
                class_5568 e = (class_5568)this.entityMap.remove(key);
                if (e != null) {
                    return true;
                }
            }
        }
        concurrentHashMap = this.entityMap;
        synchronized (concurrentHashMap) {
            for (Integer id : this.entityMap.keySet()) {
                class_5568 e = (class_5568)this.entityMap.get(id);
                if (!e.method_5667().equals(uuid)) continue;
                this.entityMap.remove(id);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized int removeByChunk(class_1923 pos) {
        Long longPos = pos.method_8324();
        int count = 0;
        ConcurrentHashMap<Long, List<UUID>> concurrentHashMap = this.chunkMap;
        synchronized (concurrentHashMap) {
            List<UUID> list = this.chunkMap.get(longPos);
            if (list == null || list.isEmpty()) {
                return count;
            }
            for (UUID uuid : list) {
                Integer key;
                ConcurrentHashMap<Comparable<UUID>, Integer> concurrentHashMap2 = this.uuidMap;
                synchronized (concurrentHashMap2) {
                    key = this.uuidMap.remove(uuid);
                }
                if (key != null) {
                    concurrentHashMap2 = this.entityMap;
                    synchronized (concurrentHashMap2) {
                        this.entityMap.remove(key);
                        ++count;
                        continue;
                    }
                }
                concurrentHashMap2 = this.entityMap;
                synchronized (concurrentHashMap2) {
                    for (Integer id : this.entityMap.keySet()) {
                        class_5568 e = (class_5568)this.entityMap.get(id);
                        if (!e.method_5667().equals(uuid)) continue;
                        this.entityMap.remove(id);
                        ++count;
                    }
                }
            }
            this.chunkMap.remove(longPos);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public synchronized T method_31804(int id) {
        if (this.entityMap.containsKey(id)) {
            class_5568 e = (class_5568)this.entityMap.get(id);
            if (!this.uuidMap.containsKey(e.method_5667())) {
                ConcurrentHashMap<UUID, Integer> concurrentHashMap = this.uuidMap;
                synchronized (concurrentHashMap) {
                    this.uuidMap.put(e.method_5667(), id);
                }
            }
            return (T)e;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public synchronized T method_31808(@Nonnull UUID uuid) {
        if (this.uuidMap.containsKey(uuid)) {
            int key = this.uuidMap.get(uuid);
            if (this.entityMap.containsKey(key)) {
                return (T)((class_5568)this.entityMap.get(key));
            }
            ConcurrentHashMap<UUID, Integer> concurrentHashMap = this.uuidMap;
            synchronized (concurrentHashMap) {
                this.uuidMap.remove(uuid);
            }
            return null;
        }
        for (Integer id : this.entityMap.keySet()) {
            class_5568 e = (class_5568)this.entityMap.get(id);
            if (!e.method_5667().equals(uuid)) continue;
            if (!this.uuidMap.containsKey(uuid)) {
                ConcurrentHashMap<UUID, Integer> concurrentHashMap = this.uuidMap;
                synchronized (concurrentHashMap) {
                    this.uuidMap.put(uuid, id);
                }
            }
            return (T)e;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Iterable<T> getAllByChunk(class_1923 pos) {
        ConcurrentHashMap<Long, List<UUID>> concurrentHashMap = this.chunkMap;
        synchronized (concurrentHashMap) {
            List<UUID> list = this.chunkMap.get(pos.method_8324());
            if (list == null || list.isEmpty()) {
                return Collections.emptyList();
            }
            ConcurrentHashMap<Integer, T> concurrentHashMap2 = this.entityMap;
            synchronized (concurrentHashMap2) {
                return Iterables.unmodifiableIterable(this.entityMap.values().stream().filter(e -> list.contains(e.method_5667())).toList());
            }
        }
    }

    @Nonnull
    public synchronized Iterable<T> method_31803() {
        return Iterables.unmodifiableIterable(this.entityMap.values());
    }

    public synchronized void method_31807(@Nonnull class_238 box, @Nonnull Consumer<T> action) {
        class_238 adjBox = new class_238(box.field_1323 - 2.0, box.field_1322 - 4.0, box.field_1321 - 2.0, box.field_1320 + 2.0, box.field_1325 + 0.0, box.field_1324 + 2.0);
        ArrayList added = new ArrayList();
        this.entityMap.forEach((id, e) -> {
            if (adjBox.method_994(e.method_5829())) {
                class_7927 consumer = class_7927.forConsumer((Consumer)action);
                if (!added.contains(e.method_5667())) {
                    added.add(e.method_5667());
                    if (consumer.accept(e).method_47543()) {
                        return;
                    }
                }
            }
        });
    }

    public synchronized <U extends T> void method_31805(@Nonnull class_5575<T, U> filter, @Nonnull class_238 box, @Nonnull class_7927<U> consumer) {
        class_238 adjBox = new class_238(box.field_1323 - 2.0, box.field_1322 - 4.0, box.field_1321 - 2.0, box.field_1320 + 2.0, box.field_1325 + 0.0, box.field_1324 + 2.0);
        ArrayList added = new ArrayList();
        this.entityMap.forEach((id, e) -> {
            class_5568 filtered = (class_5568)filter.method_31796(e);
            if (filtered != null && adjBox.method_994(filtered.method_5829()) && !added.contains(e.method_5667())) {
                added.add(e.method_5667());
                if (consumer.accept((Object)filtered).method_47543()) {
                    return;
                }
            }
        });
    }

    public synchronized <U extends T> void method_31806(@Nonnull class_5575<T, U> filter, @Nonnull class_7927<U> consumer) {
        this.entityMap.forEach((id, e) -> {
            class_5568 filtered = (class_5568)filter.method_31796(e);
            if (filtered != null && consumer.accept((Object)filtered).method_47543()) {
                return;
            }
        });
    }

    public synchronized boolean contains(int id) {
        return this.entityMap.containsKey(id);
    }

    public synchronized boolean contains(UUID uuid) {
        return this.uuidMap.containsKey(uuid);
    }

    public synchronized boolean contains(class_1923 pos) {
        return this.chunkMap.containsKey(pos.method_8324());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset() {
        ConcurrentHashMap<Comparable<Integer>, Object> concurrentHashMap = this.entityMap;
        synchronized (concurrentHashMap) {
            this.entityMap.clear();
        }
        concurrentHashMap = this.uuidMap;
        synchronized (concurrentHashMap) {
            this.uuidMap.clear();
        }
        concurrentHashMap = this.chunkMap;
        synchronized (concurrentHashMap) {
            this.chunkMap.clear();
        }
    }

    @Override
    public void close() throws Exception {
        this.reset();
    }
}

