/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.world;

import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.world.ChunkSchematicState;
import javax.annotation.Nonnull;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ChunkSchematic
extends class_2818 {
    private static final class_2680 AIR = class_2246.field_10124.method_9564();
    private final long timeCreated;
    private final int bottomY;
    private final int topY;
    private boolean isEmpty = true;
    private ChunkSchematicState state = ChunkSchematicState.NEW;

    public ChunkSchematic(class_1937 worldIn, class_1923 pos) {
        super(worldIn, pos);
        this.timeCreated = worldIn.method_75260();
        this.bottomY = worldIn.method_31607();
        this.topY = worldIn.method_31600();
    }

    public void setState(ChunkSchematicState state) {
        this.state = state;
    }

    public ChunkSchematicState getState() {
        return this.state;
    }

    @Nonnull
    public class_2680 method_8320(class_2338 pos) {
        class_2826 chunkSection;
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        int cy = this.method_31602(y);
        class_2826[] sections = this.method_12006();
        if (cy >= 0 && cy < sections.length && !(chunkSection = sections[cy]).method_38292()) {
            return chunkSection.method_12254(x & 0xF, y & 0xF, z & 0xF);
        }
        return AIR;
    }

    public class_2680 method_12010(@Nonnull class_2338 pos, @Nonnull class_2680 newState, @class_2248.class_12132 int flags) {
        class_2586 te;
        class_2680 stateOld = this.method_8320(pos);
        int y = pos.method_10264();
        if (stateOld == newState || y >= this.topY || y < this.bottomY) {
            return null;
        }
        int x = pos.method_10263() & 0xF;
        int z = pos.method_10260() & 0xF;
        int cy = this.method_31602(y);
        class_2248 blockNew = newState.method_26204();
        class_2248 blockOld = stateOld.method_26204();
        class_2826 section = this.method_12006()[cy];
        if (section.method_38292() && newState.method_26215()) {
            return null;
        }
        y &= 0xF;
        if (!newState.method_26215()) {
            this.isEmpty = false;
        }
        section.method_16675(x, y, z, newState);
        if (blockOld != blockNew) {
            this.method_12200().method_8544(pos);
        }
        if (section.method_12254(x, y, z).method_26204() != blockNew) {
            return null;
        }
        if (newState.method_31709() && blockNew instanceof class_2343 && (te = this.createBlockEntity(pos)) == null && (te = ((class_2343)blockNew).method_10123(pos, newState)) != null) {
            this.method_12007(te);
        }
        return stateOld;
    }

    public @Nullable class_2586 createBlockEntity(class_2338 pos) {
        class_2680 state = this.method_8320(pos);
        return !state.method_31709() ? null : ((class_2343)state.method_26204()).method_10123(pos, state);
    }

    public void method_12007(@NonNull class_2586 te) {
        class_2338 pos = te.method_11016();
        class_2680 currState = this.method_8320(pos);
        if (!currState.method_31709()) {
            Litematica.LOGGER.error("setBlockEntity: Can't set block entity at pos '{}', because the existing state '{}' doesn't accept block entities", (Object)pos.method_23854(), (Object)currState.toString());
            return;
        }
        class_2680 teState = te.method_11010();
        if (!teState.equals((Object)currState) && te.method_11017().method_20526(currState)) {
            if (!currState.method_26204().equals(teState.method_26204())) {
                Litematica.LOGGER.error("setBlockEntity: Can't set block entity at pos '{}', because the Tile Entities' Block '{}' doesn't match '{}'", (Object)pos.method_23854(), (Object)currState.method_26204().toString(), (Object)teState.method_26204().toString());
                return;
            }
            te.method_31664(currState);
        }
        te.method_31662(this.method_12200());
        te.method_10996();
        class_2586 oldTe = this.field_34543.put(pos.method_10062(), te);
        if (oldTe != null && oldTe != te) {
            oldTe.method_11012();
        }
    }

    public class_238 getBoundingBox() {
        class_1923 pos = this.method_12004();
        return new class_238((double)pos.method_8326(), (double)this.method_31607(), (double)pos.method_8328(), (double)pos.method_8327(), (double)this.method_31600(), (double)pos.method_8329());
    }

    public void method_12002(@Nonnull class_1297 entity) {
        this.method_12200().method_8649(entity);
    }

    public int getTileEntityCount() {
        return this.field_34543.size();
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }

    public boolean method_12223() {
        return this.isEmpty;
    }
}

