/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.world;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.world.ChunkSchematic;
import fi.dy.masa.litematica.world.ChunkSchematicState;
import fi.dy.masa.litematica.world.FakeLightingProvider;
import fi.dy.masa.litematica.world.WorldSchematic;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1923;
import net.minecraft.class_2802;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2823;
import net.minecraft.class_3568;

public class ChunkManagerSchematic
extends class_2802 {
    private final WorldSchematic world;
    private final ConcurrentHashMap<Long, ChunkSchematic> loadedChunks;
    private final ChunkSchematic blankChunk;
    private final class_3568 lightingProvider;
    private final FakeLightingProvider fakeLightingProvider;

    public ChunkManagerSchematic(WorldSchematic world) {
        this.world = world;
        this.loadedChunks = new ConcurrentHashMap(4096, 0.9f, 2);
        this.blankChunk = new ChunkSchematic(world, new class_1923(0, 0));
        this.blankChunk.setState(ChunkSchematicState.EMPTY);
        this.lightingProvider = new class_3568((class_2823)this, true, world.method_8597().comp_642());
        this.fakeLightingProvider = new FakeLightingProvider((class_2823)this);
    }

    @Nonnull
    public WorldSchematic getLevel() {
        return this.world;
    }

    public synchronized void loadChunk(int chunkX, int chunkZ) {
        ChunkSchematic chunk = new ChunkSchematic(this.world, new class_1923(chunkX, chunkZ));
        chunk.setState(ChunkSchematicState.LOADED);
        this.loadedChunks.put(class_1923.method_8331((int)chunkX, (int)chunkZ), chunk);
    }

    public synchronized boolean method_12123(int chunkX, int chunkZ) {
        return this.loadedChunks.containsKey(class_1923.method_8331((int)chunkX, (int)chunkZ));
    }

    public synchronized ChunkSchematicState getChunkState(int chunkX, int chunkZ) {
        long key = class_1923.method_8331((int)chunkX, (int)chunkZ);
        if (this.loadedChunks.containsKey(key)) {
            return this.loadedChunks.get(key).getState();
        }
        return ChunkSchematicState.UNLOADED;
    }

    public synchronized void setChunkState(int chunkX, int chunkZ, ChunkSchematicState state) {
        long key = class_1923.method_8331((int)chunkX, (int)chunkZ);
        if (this.loadedChunks.containsKey(key)) {
            this.loadedChunks.get(key).setState(state);
        }
    }

    @Nonnull
    public String method_12122() {
        return "Schematic Chunk Manager: " + this.method_14151();
    }

    public synchronized int method_14151() {
        return this.loadedChunks.size();
    }

    public synchronized ImmutableList<Long> getLoadedKeySet() {
        ImmutableList.Builder builder = ImmutableList.builder();
        ((ConcurrentHashMap.KeySetView)this.loadedChunks.keySet()).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public synchronized ImmutableList<class_1923> getLoadedNonEmptyChunkPosSet() {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.loadedChunks.forEach((key, chunk) -> {
            if (!chunk.method_12223()) {
                builder.add((Object)chunk.method_12004());
            }
        });
        return builder.build();
    }

    public synchronized class_2818 getChunk(int chunkX, int chunkZ, @Nonnull class_2806 status, boolean fallbackToEmpty) {
        ChunkSchematic chunk = this.getChunkForLighting(chunkX, chunkZ);
        return chunk == null && fallbackToEmpty ? this.blankChunk : chunk;
    }

    public synchronized ChunkSchematic getChunkForLighting(int chunkX, int chunkZ) {
        ChunkSchematic chunk = this.loadedChunks.get(class_1923.method_8331((int)chunkX, (int)chunkZ));
        return chunk == null ? this.blankChunk : chunk;
    }

    @Nullable
    public synchronized ChunkSchematic getChunkIfExists(int chunkX, int chunkZ) {
        return this.loadedChunks.get(class_1923.method_8331((int)chunkX, (int)chunkZ));
    }

    public synchronized void unloadChunk(int chunkX, int chunkZ) {
        ChunkSchematic chunk = this.loadedChunks.remove(class_1923.method_8331((int)chunkX, (int)chunkZ));
        if (chunk != null) {
            this.world.unloadEntitiesByChunk(chunkX, chunkZ);
            chunk.setState(ChunkSchematicState.UNLOADED);
        }
    }

    public synchronized boolean replaceChunk(int chunkX, int chunkZ, @Nonnull ChunkSchematic newChunk) {
        class_1923 pos = new class_1923(chunkX, chunkZ);
        if (!newChunk.method_12004().equals((Object)pos)) {
            Litematica.LOGGER.error("replaceChunk: Position of new Chunk is mismatched: '{}' != '{}' -- Please fix", (Object)pos.toString(), (Object)newChunk.method_12004().toString());
            return false;
        }
        if (this.method_12123(chunkX, chunkZ)) {
            this.world.unloadEntitiesByChunk(chunkX, chunkZ);
            this.unloadChunk(chunkX, chunkZ);
        }
        if (!newChunk.getState().atLeast(ChunkSchematicState.LOADED)) {
            newChunk.setState(ChunkSchematicState.LOADED);
        }
        this.loadedChunks.put(class_1923.method_8331((int)chunkX, (int)chunkZ), newChunk);
        return true;
    }

    @Nonnull
    public class_3568 method_12130() {
        if (Configs.Visuals.ENABLE_SCHEMATIC_FAKE_LIGHTING.getBooleanValue()) {
            return this.fakeLightingProvider;
        }
        return this.lightingProvider;
    }

    public void method_12127(@Nonnull BooleanSupplier shouldKeepTicking, boolean tickChunks) {
    }

    public synchronized int getTileEntityCount() {
        int count = 0;
        Iterator iter = this.loadedChunks.values().stream().iterator();
        while (iter.hasNext()) {
            count += ((ChunkSchematic)((Object)iter.next())).getTileEntityCount();
        }
        return count;
    }
}

