/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.world.ChunkSchematicState;
import fi.dy.masa.litematica.world.ProtoChunkSchematic;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.nbt.NbtUtils;
import fi.dy.masa.malilib.util.nbt.NbtView;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1533;
import net.minecraft.class_1534;
import net.minecraft.class_1535;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_5455;
import net.minecraft.class_8113;
import org.apache.commons.lang3.tuple.Pair;

public class WorldPlacingUtils {
    public static ProtoChunkSchematic placeToProtoChunk(@Nonnull ProtoChunkSchematic chunk, class_1923 chunkPos, SchematicPlacement schematicPlacement) {
        ProtoChunkSchematic filledChunk = null;
        LitematicaSchematic schematic = schematicPlacement.getSchematic();
        Set<String> regionsTouchingChunk = schematicPlacement.getRegionsTouchingChunk(chunkPos.field_9181, chunkPos.field_9180);
        class_2338 origin = schematicPlacement.getOrigin();
        boolean allSuccess = true;
        try {
            for (String regionName : regionsTouchingChunk) {
                LitematicaBlockStateContainer container = schematic.getSubRegionContainer(regionName);
                if (container == null) {
                    allSuccess = false;
                    continue;
                }
                SubRegionPlacement placement = schematicPlacement.getRelativeSubRegionPlacement(regionName);
                if (placement == null || !placement.isEnabled()) continue;
                Map<class_2338, class_2487> blockEntityMap = schematic.getBlockEntityMapForRegion(regionName);
                filledChunk = WorldPlacingUtils.placeBlocksToProtoChunk(chunk, chunkPos, regionName, container, blockEntityMap, origin, schematicPlacement, placement);
                if (filledChunk == null) {
                    allSuccess = false;
                    Litematica.LOGGER.warn("Invalid/missing schematic data in schematic '{}' for sub-region '{}'", (Object)schematic.getMetadata().getName(), (Object)regionName);
                }
                List<LitematicaSchematic.EntityInfo> entityList = schematic.getEntityListForRegion(regionName);
                if (filledChunk == null || schematicPlacement.ignoreEntities() || placement.ignoreEntities() || entityList == null) continue;
                filledChunk = WorldPlacingUtils.prepareEntitiesInProtoChunk(filledChunk, chunkPos, entityList, origin, schematicPlacement, placement);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (allSuccess) {
            return filledChunk;
        }
        return null;
    }

    public static ProtoChunkSchematic placeBlocksToProtoChunk(@Nonnull ProtoChunkSchematic chunk, class_1923 chunkPos, String regionName, LitematicaBlockStateContainer container, Map<class_2338, class_2487> blockEntityMap, class_2338 origin, SchematicPlacement schematicPlacement, SubRegionPlacement placement) {
        IntBoundingBox bounds = schematicPlacement.getBoxWithinChunkForRegion(regionName, chunkPos.field_9181, chunkPos.field_9180);
        class_2382 regionSize = schematicPlacement.getSchematic().getAreaSizeAsVec3i(regionName);
        if (bounds == null || container == null || blockEntityMap == null || regionSize == null) {
            return null;
        }
        class_2338 regionPos = placement.getPos();
        class_2338 posEndRel = new class_2338((class_2382)PositionUtils.getRelativeEndPositionFromAreaSize(regionSize)).method_10081((class_2382)regionPos);
        class_2338 posMinRel = PositionUtils.getMinCorner(regionPos, posEndRel);
        class_2338 regionPosTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        class_2338 boxMinRel = new class_2338(bounds.minX() - origin.method_10263() - regionPosTransformed.method_10263(), 0, bounds.minZ() - origin.method_10260() - regionPosTransformed.method_10260());
        class_2338 boxMaxRel = new class_2338(bounds.maxX() - origin.method_10263() - regionPosTransformed.method_10263(), 0, bounds.maxZ() - origin.method_10260() - regionPosTransformed.method_10260());
        boxMinRel = PositionUtils.getReverseTransformedBlockPos(boxMinRel, placement.getMirror(), placement.getRotation());
        boxMaxRel = PositionUtils.getReverseTransformedBlockPos(boxMaxRel, placement.getMirror(), placement.getRotation());
        boxMinRel = PositionUtils.getReverseTransformedBlockPos(boxMinRel, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        boxMaxRel = PositionUtils.getReverseTransformedBlockPos(boxMaxRel, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        boxMinRel = boxMinRel.method_10059((class_2382)posMinRel.method_10059((class_2382)regionPos));
        boxMaxRel = boxMaxRel.method_10059((class_2382)posMinRel.method_10059((class_2382)regionPos));
        class_2338 posMin = PositionUtils.getMinCorner(boxMinRel, boxMaxRel);
        class_2338 posMax = PositionUtils.getMaxCorner(boxMinRel, boxMaxRel);
        class_2338 totalRegionPosTransformed = regionPosTransformed.method_10081((class_2382)origin);
        int startX = posMin.method_10263();
        int startZ = posMin.method_10260();
        int endX = posMax.method_10263();
        int endZ = posMax.method_10260();
        boolean startY = false;
        int endY = Math.abs(regionSize.method_10264()) - 1;
        class_2338.class_2339 posMutable = new class_2338.class_2339();
        if (startX < 0 || startZ < 0 || endX >= container.getSize().method_10263() || endZ >= container.getSize().method_10260()) {
            System.out.printf("DEBUG ============= OUT OF BOUNDS - region: %s, sx: %d, sz: %d, ex: %d, ez: %d - size x: %d z: %d =============\n", regionName, startX, startZ, endX, endZ, container.getSize().method_10263(), container.getSize().method_10260());
            return null;
        }
        class_2470 rotationCombined = schematicPlacement.getRotation().method_10501(placement.getRotation());
        class_2415 mirrorMain = schematicPlacement.getMirror();
        class_2680 barrier = class_2246.field_10499.method_9564();
        class_2415 mirrorSub = placement.getMirror();
        boolean ignoreInventories = Configs.Generic.PASTE_IGNORE_INVENTORY.getBooleanValue();
        if (mirrorSub != class_2415.field_11302 && (schematicPlacement.getRotation() == class_2470.field_11463 || schematicPlacement.getRotation() == class_2470.field_11465)) {
            mirrorSub = mirrorSub == class_2415.field_11301 ? class_2415.field_11300 : class_2415.field_11301;
        }
        int posMinRelMinusRegX = posMinRel.method_10263() - regionPos.method_10263();
        int posMinRelMinusRegY = posMinRel.method_10264() - regionPos.method_10264();
        int posMinRelMinusRegZ = posMinRel.method_10260() - regionPos.method_10260();
        for (int y = 0; y <= endY; ++y) {
            for (int z = startZ; z <= endZ; ++z) {
                for (int x = startX; x <= endX; ++x) {
                    class_2586 te;
                    class_2680 state = container.get(x, y, z);
                    if (state.method_26204() == class_2246.field_10369) continue;
                    posMutable.method_10103(x, y, z);
                    class_2487 teNBT = blockEntityMap.get(posMutable);
                    class_2338 origPos = posMutable.method_10062();
                    posMutable.method_10103(posMinRelMinusRegX + x, posMinRelMinusRegY + y, posMinRelMinusRegZ + z);
                    class_2338 pos = PositionUtils.getTransformedPlacementPosition((class_2338)posMutable, schematicPlacement, placement);
                    pos = pos.method_10081((class_2382)totalRegionPosTransformed);
                    if (state.method_31709() && state.method_27852(class_2246.field_10034) && !ignoreInventories && mirrorMain != class_2415.field_11302 && state.method_11654((class_2769)class_2281.field_10770) != class_2745.field_12569 && Configs.Generic.FIX_CHEST_MIRROR.getBooleanValue()) {
                        class_2350 facingAdj;
                        class_2338 posAdj;
                        class_2350 facing = (class_2350)state.method_11654((class_2769)class_2281.field_10768);
                        class_2350.class_2351 axis = facing.method_10166();
                        class_2745 type = ((class_2745)state.method_11654((class_2769)class_2281.field_10770)).method_11824();
                        if (mirrorMain != class_2415.field_11302 && axis != class_2350.class_2351.field_11052 && blockEntityMap.containsKey(posAdj = origPos.method_10093(facingAdj = type == class_2745.field_12574 ? facing.method_35834(class_2350.class_2351.field_11052) : facing.method_35833(class_2350.class_2351.field_11052)))) {
                            teNBT = blockEntityMap.getOrDefault(posAdj, teNBT).method_10553();
                        }
                    }
                    if (mirrorMain != class_2415.field_11302) {
                        state = state.method_26185(mirrorMain);
                    }
                    if (mirrorSub != class_2415.field_11302) {
                        state = state.method_26185(mirrorSub);
                    }
                    if (rotationCombined != class_2470.field_11467) {
                        state = state.method_26186(rotationCombined);
                    }
                    if ((te = chunk.method_8321(pos)) != null) {
                        if (te instanceof class_1263) {
                            ((class_1263)te).method_5448();
                        }
                        chunk.method_12010(pos, barrier, 20);
                    }
                    chunk.method_12010(pos, state, 18);
                    if (teNBT == null || (te = chunk.createBlockEntity(pos)) == null) continue;
                    teNBT = teNBT.method_10553();
                    teNBT.method_10569("x", pos.method_10263());
                    teNBT.method_10569("y", pos.method_10264());
                    teNBT.method_10569("z", pos.method_10260());
                    if (ignoreInventories) {
                        teNBT.method_10551("Items");
                    }
                    try {
                        NbtView view = NbtView.getReader((class_2487)teNBT, (class_5455)SchematicWorldHandler.INSTANCE.getRegistryManager());
                        te.method_58690(view.getReader());
                        if (ignoreInventories && te instanceof class_1263) {
                            ((class_1263)te).method_5448();
                        }
                    }
                    catch (Exception e) {
                        Litematica.LOGGER.warn("Failed to load BlockEntity data for {} @ {}", (Object)state, (Object)pos);
                    }
                    chunk.method_12007(te);
                }
            }
        }
        if (!chunk.getState().atLeast(ChunkSchematicState.FILLED)) {
            chunk.setState(ChunkSchematicState.FILLED);
        }
        return chunk;
    }

    public static ProtoChunkSchematic prepareEntitiesInProtoChunk(@Nonnull ProtoChunkSchematic chunk, class_1923 chunkPos, List<LitematicaSchematic.EntityInfo> entityList, class_2338 origin, SchematicPlacement schematicPlacement, SubRegionPlacement placement) {
        class_2338 regionPos = placement.getPos();
        if (entityList == null) {
            return chunk;
        }
        class_2338 regionPosRelTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        int offX = regionPosRelTransformed.method_10263() + origin.method_10263();
        int offY = regionPosRelTransformed.method_10264() + origin.method_10264();
        int offZ = regionPosRelTransformed.method_10260() + origin.method_10260();
        double minX = chunkPos.field_9181 << 4;
        double minZ = chunkPos.field_9180 << 4;
        double maxX = (chunkPos.field_9181 << 4) + 16;
        double maxZ = (chunkPos.field_9180 << 4) + 16;
        class_2470 rotationCombined = schematicPlacement.getRotation().method_10501(placement.getRotation());
        class_2415 mirrorMain = schematicPlacement.getMirror();
        class_2415 mirrorSub = placement.getMirror();
        if (mirrorSub != class_2415.field_11302 && (schematicPlacement.getRotation() == class_2470.field_11463 || schematicPlacement.getRotation() == class_2470.field_11465)) {
            mirrorSub = mirrorSub == class_2415.field_11301 ? class_2415.field_11300 : class_2415.field_11301;
        }
        for (LitematicaSchematic.EntityInfo info : entityList) {
            class_243 pos = info.posVec;
            pos = PositionUtils.getTransformedPosition(pos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
            pos = PositionUtils.getTransformedPosition(pos, placement.getMirror(), placement.getRotation());
            double x = pos.field_1352 + (double)offX;
            double y = pos.field_1351 + (double)offY;
            double z = pos.field_1350 + (double)offZ;
            float[] origRot = new float[2];
            if (!(x >= minX) || !(x < maxX) || !(z >= minZ) || !(z < maxZ)) continue;
            class_2487 tag = info.nbt.method_10553();
            String id = tag.method_68564("id", "");
            if (id.equals("minecraft:glow_item_frame") || id.equals("minecraft:item_frame") || id.equals("minecraft:leash_knot") || id.equals("minecraft:painting")) {
                class_243 p = NbtUtils.readEntityPositionFromTag((class_2487)tag);
                if (p == null) {
                    p = new class_243(x, y, z);
                    NbtUtils.putVec3dCodec((class_2487)tag, (class_243)p, (String)"Pos");
                }
                tag.method_10569("TileX", (int)p.field_1352);
                tag.method_10569("TileY", (int)p.field_1351);
                tag.method_10569("TileZ", (int)p.field_1350);
                tag.method_67491("block_pos", class_2338.field_25064).ifPresent(px -> tag.method_67494("block_pos", class_2338.field_25064, (Object)new class_2338((int)x, (int)y, (int)z)));
            }
            class_2499 rotation = tag.method_68569("Rotation");
            origRot[0] = rotation.method_68575(0, 0.0f);
            origRot[1] = rotation.method_68575(1, 0.0f);
            chunk.addEntityPairForLater((Pair<EntityPosAndRot, class_2487>)Pair.of((Object)new EntityPosAndRot(x, y, z, rotationCombined, mirrorMain, mirrorSub, origRot), (Object)tag));
        }
        return chunk;
    }

    public static void spawnEntityToWorldNow(@Nonnull class_1937 world, Pair<EntityPosAndRot, class_2487> entityPair) {
        double x = ((EntityPosAndRot)entityPair.getLeft()).x;
        double y = ((EntityPosAndRot)entityPair.getLeft()).y;
        double z = ((EntityPosAndRot)entityPair.getLeft()).z;
        class_2470 rotationCombined = ((EntityPosAndRot)entityPair.getLeft()).rot();
        class_2415 mirrorMain = ((EntityPosAndRot)entityPair.getLeft()).mirrorMain();
        class_2415 mirrorSub = ((EntityPosAndRot)entityPair.getLeft()).mirrorSub();
        float[] origRot = ((EntityPosAndRot)entityPair.getLeft()).origRot();
        class_1297 entity = EntityUtils.createEntityAndPassengersFromNBT((class_2487)entityPair.getRight(), world);
        if (entity != null) {
            class_1533 frameEntity;
            class_1309 living;
            WorldPlacingUtils.rotateEntity(entity, x, y, z, rotationCombined, mirrorMain, mirrorSub);
            if (entity instanceof class_1309 && (living = (class_1309)entity).method_6113()) {
                living.method_18402(class_2338.method_49637((double)x, (double)y, (double)z));
            }
            if (entity instanceof class_1534) {
                class_1534 paintingEntity = (class_1534)entity;
                class_2350 right = paintingEntity.method_5735().method_10160();
                if (((class_1535)paintingEntity.method_43404().comp_349()).comp_2670() % 2 == 0 && right.method_10171() == class_2350.class_2352.field_11056) {
                    x -= 1.0 * (double)right.method_10148();
                    z -= 1.0 * (double)right.method_10165();
                }
                if (((class_1535)paintingEntity.method_43404().comp_349()).comp_2671() % 2 == 0) {
                    y -= 1.0;
                }
                entity.method_5814(x, y, z);
            }
            if (entity instanceof class_1533 && (frameEntity = (class_1533)entity).method_36454() != origRot[0] && (frameEntity.method_36455() == 90.0f || frameEntity.method_36455() == -90.0f)) {
                frameEntity.method_36456(origRot[0]);
            }
            EntityUtils.spawnEntityAndPassengersInWorld(entity, world);
            if (entity instanceof class_8113) {
                entity.method_5773();
            }
        }
    }

    public static void rotateEntity(class_1297 entity, double x, double y, double z, class_2470 rotationCombined, class_2415 mirrorMain, class_2415 mirrorSub) {
        float rotationYaw = entity.method_36454();
        if (mirrorMain != class_2415.field_11302) {
            rotationYaw = entity.method_5763(mirrorMain);
        }
        if (mirrorSub != class_2415.field_11302) {
            rotationYaw = entity.method_5763(mirrorSub);
        }
        if (rotationCombined != class_2470.field_11467) {
            rotationYaw += entity.method_36454() - entity.method_5832(rotationCombined);
        }
        entity.method_5808(x, y, z, rotationYaw, entity.method_36455());
        EntityUtils.setEntityRotations(entity, rotationYaw, entity.method_36455());
    }

    public record EntityPosAndRot(double x, double y, double z, class_2470 rot, class_2415 mirrorMain, class_2415 mirrorSub, float[] origRot) {
    }
}

