/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic.placement;

import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.schematic.placement.TemporaryWorldHolder;
import fi.dy.masa.malilib.util.FileNameUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public class TemporaryWorldManager
implements AutoCloseable {
    public static final TemporaryWorldManager INSTANCE = new TemporaryWorldManager();
    private final ConcurrentHashMap<String, TemporaryWorldHolder> tempWorlds = new ConcurrentHashMap(2, 0.9f, 1);

    private TemporaryWorldManager() {
    }

    protected synchronized TemporaryWorldHolder getTemporaryWorld(String worldName) {
        if (!this.tempWorlds.containsKey(worldName = this.ensureSafeWorldName(worldName))) {
            this.tempWorlds.put(worldName, new TemporaryWorldHolder());
            Litematica.debugLog("TemporaryWorldManager: Created New temporary world: '{}' (No origin / size provided)", worldName);
        }
        return this.tempWorlds.get(worldName);
    }

    public synchronized TemporaryWorldHolder getTemporaryWorld(String worldName, class_2338 origin, class_2382 size) {
        if (!this.tempWorlds.containsKey(worldName = this.ensureSafeWorldName(worldName))) {
            this.tempWorlds.put(worldName, new TemporaryWorldHolder(origin, size));
            Litematica.debugLog("TemporaryWorldManager: Created New temporary world: '{}', at '{}' with a size of: '{}'", worldName, origin.method_23854(), size.method_23854());
        }
        return this.tempWorlds.get(worldName);
    }

    public synchronized boolean hasTemporaryWorld(String worldName) {
        return this.tempWorlds.containsKey(this.ensureSafeWorldName(worldName));
    }

    public synchronized void removeTemporaryWorld(String worldName) {
        worldName = this.ensureSafeWorldName(worldName);
        try (TemporaryWorldHolder removed = this.tempWorlds.remove(worldName);){
            if (removed != null) {
                Litematica.debugLog("TemporaryWorldManager: Removed temporary world: '{}'", worldName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void setOriginAndSize(String worldName, class_2338 origin, class_2382 size) {
        if (!this.tempWorlds.containsKey(worldName = this.ensureSafeWorldName(worldName))) {
            this.tempWorlds.get(worldName).clear();
            this.tempWorlds.put(worldName, new TemporaryWorldHolder(origin, size));
            Litematica.debugLog("TemporaryWorldManager: Replaced temporary world: '{}', at '{}' with a size of: '{}'", worldName, origin.method_23854(), size.method_23854());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized List<class_1923> getChunks(String worldName) {
        worldName = this.ensureSafeWorldName(worldName);
        ArrayList<class_1923> chunks = new ArrayList<class_1923>();
        if (this.tempWorlds.containsKey(worldName)) {
            TemporaryWorldHolder world = this.tempWorlds.get(worldName);
            if (!world.isEmpty()) return world.chunkList().stream().map(pair -> new class_1923(((Integer)pair.getLeft()).intValue(), ((Integer)pair.getRight()).intValue())).toList();
            Litematica.LOGGER.error("TemporaryWorldManager#getChunks(): Temporary world: '{}' is empty!  Cannot replace a chunk that was not calculated!", (Object)worldName);
            return chunks;
        } else {
            Litematica.LOGGER.error("TemporaryWorldManager#getChunks(): Temporary world: '{}'; was not found!", (Object)worldName);
        }
        return chunks;
    }

    private String ensureSafeWorldName(String worldName) throws IllegalStateException {
        if (worldName == null || worldName.isEmpty()) {
            throw new IllegalStateException("Temporary World Name is empty!");
        }
        if (worldName.length() > 256) {
            throw new IllegalStateException("Temporary World Name is too long!");
        }
        return FileNameUtils.generateSafeFileName((String)worldName);
    }

    public void reset() {
        this.clear();
    }

    public synchronized void clear() {
        if (!this.tempWorlds.isEmpty()) {
            this.tempWorlds.forEach((s, world) -> {
                try {
                    world.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            this.tempWorlds.clear();
        }
    }

    @Override
    public void close() throws Exception {
        this.clear();
    }
}

