/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic.placement;

import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.world.ChunkManagerSchematic;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import org.apache.commons.lang3.tuple.Pair;
import org.jspecify.annotations.Nullable;

public class TemporaryWorldHolder
implements AutoCloseable {
    private WorldSchematic world = null;
    private class_2338 origin = class_2338.field_10980;
    private class_2382 size = class_2338.field_10980;
    private List<Pair<Integer, Integer>> chunks = new ArrayList<Pair<Integer, Integer>>();

    protected TemporaryWorldHolder() {
    }

    protected TemporaryWorldHolder(class_2338 origin, class_2382 size) {
        this();
        this.createWorld();
        this.calculateChunks(origin, size);
    }

    protected void createWorld() {
        this.world = SchematicWorldHandler.createSchematicWorld(null);
    }

    protected void calculateChunks(class_2338 origin, class_2382 size) throws IllegalArgumentException {
        this.ensureWorld();
        this.chunks = new ArrayList<Pair<Integer, Integer>>();
        this.origin = origin;
        this.size = size;
        class_2338 posEnd = origin.method_10081((class_2382)PositionUtils.getRelativeEndPositionFromAreaSize(size));
        class_2338 posMin = PositionUtils.getMinCorner(origin, posEnd);
        class_2338 posMax = PositionUtils.getMaxCorner(origin, posEnd);
        int cxMin = posMin.method_10263() >> 4;
        int czMin = posMin.method_10260() >> 4;
        int cxMax = posMax.method_10263() >> 4;
        int czMax = posMax.method_10260() >> 4;
        for (int cz = czMin; cz <= czMax; ++cz) {
            for (int cx = cxMin; cx <= cxMax; ++cx) {
                this.chunkManager().loadChunk(cx, cz);
                this.chunks.add((Pair<Integer, Integer>)Pair.of((Object)cx, (Object)cz));
            }
        }
    }

    public boolean hasWorld() {
        return this.world != null;
    }

    public boolean isEmpty() {
        return this.chunks.isEmpty();
    }

    public @Nullable WorldSchematic world() {
        return this.world;
    }

    public class_2338 origin() {
        return this.origin;
    }

    public class_2382 size() {
        return this.size;
    }

    public List<Pair<Integer, Integer>> chunkList() {
        return this.chunks;
    }

    protected @Nullable ChunkManagerSchematic chunkManager() throws IllegalStateException {
        this.ensureWorld();
        return this.world.getChunkSource();
    }

    private void ensureWorld() throws IllegalStateException {
        if (this.world == null) {
            throw new IllegalStateException("TemporaryWorldHolder: No World!");
        }
    }

    protected void clear() {
        this.chunks.clear();
        this.origin = class_2338.field_10980;
        this.size = class_2338.field_10980;
        if (this.world != null) {
            this.world.clearEntities();
            try {
                this.world.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.world = null;
        }
    }

    @Override
    public void close() throws Exception {
        this.clear();
    }
}

