/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic.placement;

import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.data.EntitiesDataStorage;
import fi.dy.masa.litematica.render.LitematicaRenderer;
import fi.dy.masa.litematica.schematic.placement.PlacementManagerDaemonExecutor;
import fi.dy.masa.litematica.schematic.placement.PlacementManagerTask;
import fi.dy.masa.litematica.schematic.placement.PlacementManagerTaskRebuild;
import fi.dy.masa.litematica.schematic.placement.PlacementManagerTaskUnload;
import fi.dy.masa.litematica.schematic.placement.TemporaryWorldManager;
import fi.dy.masa.malilib.interfaces.IThreadDaemonHandler;
import fi.dy.masa.malilib.util.MathUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadFactory;
import net.minecraft.class_1923;
import net.minecraft.class_310;
import org.apache.commons.lang3.tuple.Pair;

public class PlacementManagerDaemonHandler
implements IThreadDaemonHandler<PlacementManagerTask> {
    private final int threadCount = this.calculateMaxThreads();
    private final ConcurrentHashMap<String, Pair<Thread, PlacementManagerDaemonExecutor>> threadMap = this.builder();
    public static final PlacementManagerDaemonHandler INSTANCE = new PlacementManagerDaemonHandler();
    private final ConcurrentLinkedQueue<PlacementManagerTask> queueUnload = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<PlacementManagerTask> queueRebuild = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<PlacementManagerTask> queueOther = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<PlacementManagerTask> deferredQueue = new ConcurrentLinkedQueue();
    private static final float taskInterval = 0.75f;
    private long lastTick = System.currentTimeMillis();
    private boolean processing = false;

    private int calculateMaxThreads() {
        return Math.clamp((long)(Runtime.getRuntime().availableProcessors() / 4), 1, 4);
    }

    private ConcurrentHashMap<String, Pair<Thread, PlacementManagerDaemonExecutor>> builder() {
        ConcurrentHashMap<String, Pair<Thread, PlacementManagerDaemonExecutor>> threads = new ConcurrentHashMap<String, Pair<Thread, PlacementManagerDaemonExecutor>>(4, 0.9f, 1);
        String prefix = "Litematica Placement Manager ";
        for (int i = 0; i < this.threadCount; ++i) {
            String name = prefix + (i + 1);
            ThreadFactory FACTORY = Thread.ofPlatform().name(name).daemon(true).factory();
            PlacementManagerDaemonExecutor executor = new PlacementManagerDaemonExecutor();
            threads.put(name, (Pair<Thread, PlacementManagerDaemonExecutor>)Pair.of((Object)FACTORY.newThread((Runnable)((Object)executor)), (Object)executor));
        }
        return threads;
    }

    private PlacementManagerDaemonHandler() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Litematica.LOGGER.info("Starting [{}] Placement Manager Daemon threads", (Object)this.threadMap.size());
        ConcurrentHashMap<String, Pair<Thread, PlacementManagerDaemonExecutor>> concurrentHashMap = this.threadMap;
        synchronized (concurrentHashMap) {
            this.threadMap.forEach((name, pair) -> {
                ((Thread)pair.getLeft()).start();
                ((PlacementManagerDaemonExecutor)pair.getRight()).start();
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Litematica.debugLog("Stopping [{}] Placement Manager Daemon threads", this.threadMap.size());
        ConcurrentHashMap<String, Pair<Thread, PlacementManagerDaemonExecutor>> concurrentHashMap = this.threadMap;
        synchronized (concurrentHashMap) {
            this.threadMap.forEach((name, pair) -> {
                ((PlacementManagerDaemonExecutor)pair.getRight()).stop();
                ((Thread)pair.getLeft()).interrupt();
            });
        }
    }

    public void reset() {
        this.clearAllTasks();
    }

    public synchronized void addTask(PlacementManagerTask newTask) {
        if (this.checkIfTasksAreFull()) {
            this.deferredQueue.add(newTask);
            return;
        }
        PlacementManagerTask placementManagerTask = newTask;
        Objects.requireNonNull(placementManagerTask);
        PlacementManagerTask placementManagerTask2 = placementManagerTask;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlacementManagerTaskUnload.class, PlacementManagerTaskRebuild.class}, (Object)((Object)placementManagerTask2), n)) {
            case 0: {
                PlacementManagerTaskUnload tU = (PlacementManagerTaskUnload)placementManagerTask2;
                this.queueUnload.offer(newTask);
                break;
            }
            case 1: {
                PlacementManagerTaskRebuild tL = (PlacementManagerTaskRebuild)placementManagerTask2;
                this.queueRebuild.offer(newTask);
                break;
            }
            default: {
                this.queueOther.offer(newTask);
            }
        }
        this.processing = true;
    }

    public synchronized PlacementManagerTask getNextTask() {
        if (!this.queueUnload.isEmpty()) {
            return this.queueUnload.poll();
        }
        if (!this.queueRebuild.isEmpty()) {
            return this.queueRebuild.poll();
        }
        if (!this.queueOther.isEmpty()) {
            return this.queueOther.poll();
        }
        return null;
    }

    public long getTaskInterval() {
        return MathUtils.floor((float)750.0f);
    }

    private synchronized boolean checkIfTasksAreFull() {
        int calc;
        int threadCount = this.threadMap.size();
        int total = this.queueUnload.size() + this.queueRebuild.size() + this.queueOther.size();
        return total >= (calc = MathUtils.clamp((int)(threadCount / 3), (int)1, (int)threadCount) * 1000) && total > 0;
    }

    protected boolean allDone() {
        if (this.queueUnload.isEmpty() && this.queueRebuild.isEmpty() && this.queueOther.isEmpty()) {
            if (!this.deferredQueue.isEmpty()) {
                this.fillDeferredTasks();
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void fillDeferredTasks() {
        CopyOnWriteArrayList<PlacementManagerTask> tasks = new CopyOnWriteArrayList<PlacementManagerTask>(this.deferredQueue);
        ConcurrentLinkedQueue<PlacementManagerTask> concurrentLinkedQueue = this.deferredQueue;
        synchronized (concurrentLinkedQueue) {
            this.deferredQueue.clear();
        }
        tasks.forEach(this::addTask);
        tasks.clear();
    }

    public void onClientTick(class_310 mc) {
        long now = System.currentTimeMillis();
        if (this.lastTick > now) {
            this.lastTick = now;
        }
        if (now - this.lastTick > this.getTaskInterval()) {
            this.ensureThreadSafety();
            if (this.processing && this.allDone()) {
                LitematicaRenderer.getInstance().getWorldRenderer().markNeedsUpdate();
                this.processing = false;
            }
            this.lastTick = now;
        }
    }

    private void ensureThreadSafety() throws RuntimeException {
        this.threadMap.forEach((name, pair) -> {
            if (!((Thread)pair.getLeft()).isAlive() || ((Thread)pair.getLeft()).isInterrupted()) {
                String err = String.format("'%s' was killed [%s]", name, this.getThreadStatus((Thread)pair.getLeft()));
                this.clearAllTasks();
                this.stop();
                TemporaryWorldManager.INSTANCE.reset();
                EntitiesDataStorage.getInstance().reset(true);
                Configs.saveToFile();
                DataManager.save(true);
                DataManager.getInstance().reset(true);
                DataManager.clear();
                Litematica.LOGGER.fatal(err);
                throw new RuntimeException(err);
            }
        });
    }

    private String getThreadStatus(Thread thread) {
        if (thread == null) {
            return "<>";
        }
        return "(" + thread.threadId() + ")/" + thread.getState().name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeUnloadTasksFor(int x, int z) {
        ConcurrentLinkedQueue<PlacementManagerTask> concurrentLinkedQueue = this.queueUnload;
        synchronized (concurrentLinkedQueue) {
            ConcurrentLinkedQueue<PlacementManagerTask> newQueue = new ConcurrentLinkedQueue<PlacementManagerTask>(this.queueUnload);
            this.queueUnload.clear();
            this.queueUnload.addAll(newQueue.stream().filter(task -> task.cx() != x || task.cz() != z).toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRebuildTasksFor(int x, int z) {
        ConcurrentLinkedQueue<PlacementManagerTask> concurrentLinkedQueue = this.queueUnload;
        synchronized (concurrentLinkedQueue) {
            ConcurrentLinkedQueue<PlacementManagerTask> newQueue = new ConcurrentLinkedQueue<PlacementManagerTask>(this.queueRebuild);
            this.queueRebuild.clear();
            this.queueRebuild.addAll(newQueue.stream().filter(task -> task.cx() != x || task.cz() != z).toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeOtherTasksFor(int x, int z) {
        ConcurrentLinkedQueue<PlacementManagerTask> concurrentLinkedQueue = this.queueOther;
        synchronized (concurrentLinkedQueue) {
            ConcurrentLinkedQueue<PlacementManagerTask> newQueue = new ConcurrentLinkedQueue<PlacementManagerTask>(this.queueOther);
            this.queueOther.clear();
            this.queueOther.addAll(newQueue.stream().filter(task -> task.cx() != x || task.cz() != z).toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDeferredTasksFor(int x, int z) {
        ConcurrentLinkedQueue<PlacementManagerTask> concurrentLinkedQueue = this.deferredQueue;
        synchronized (concurrentLinkedQueue) {
            ConcurrentLinkedQueue<PlacementManagerTask> newQueue = new ConcurrentLinkedQueue<PlacementManagerTask>(this.deferredQueue);
            this.deferredQueue.clear();
            this.deferredQueue.addAll(newQueue.stream().filter(task -> task.cx() != x || task.cz() != z).toList());
        }
    }

    public boolean hasAnyRebuildTasksFor(class_1923 pos) {
        return this.hasAnyRebuildTasksFor(pos.field_9181, pos.field_9180);
    }

    public synchronized boolean hasAnyUnloadTasksFor(int cx, int cz) {
        return !this.queueUnload.stream().filter(task -> task.cx() == cx && task.cz() == cz).toList().isEmpty();
    }

    public synchronized boolean hasAnyRebuildTasksFor(int cx, int cz) {
        return !this.queueRebuild.stream().filter(task -> task.cx() == cx && task.cz() == cz).toList().isEmpty();
    }

    public synchronized boolean hasAnyOtherTasksFor(int cx, int cz) {
        return !this.queueOther.stream().filter(task -> task.cx() == cx && task.cz() == cz).toList().isEmpty();
    }

    public synchronized boolean hasAnyDeferredTasksFor(int cx, int cz) {
        return !this.deferredQueue.stream().filter(task -> task.cx() == cx && task.cz() == cz).toList().isEmpty();
    }

    public boolean hasAnyTasks() {
        return this.hasAnyUnloadTasks() || this.hasAnyRebuildTasks() || this.hasAnyOtherTasks() || this.hasAnyDeferredTasks();
    }

    public boolean hasAnyUnloadTasks() {
        return !this.queueUnload.isEmpty();
    }

    public boolean hasAnyRebuildTasks() {
        return !this.queueRebuild.isEmpty();
    }

    public boolean hasAnyOtherTasks() {
        return !this.queueOther.isEmpty();
    }

    public boolean hasAnyDeferredTasks() {
        return !this.deferredQueue.isEmpty();
    }

    public boolean hasAnyTasksFor(int cx, int cz) {
        return this.hasAnyUnloadTasksFor(cx, cz) || this.hasAnyRebuildTasksFor(cx, cz) || this.hasAnyOtherTasksFor(cx, cz) || this.hasAnyDeferredTasksFor(cx, cz);
    }

    protected void removeAllTasksFor(int cx, int cz) {
        this.removeOtherTasksFor(cx, cz);
        this.removeRebuildTasksFor(cx, cz);
        this.removeUnloadTasksFor(cx, cz);
        this.removeDeferredTasksFor(cx, cz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllUnloadTasks() {
        ConcurrentLinkedQueue<PlacementManagerTask> concurrentLinkedQueue = this.queueUnload;
        synchronized (concurrentLinkedQueue) {
            this.queueUnload.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllRebuildTasks() {
        ConcurrentLinkedQueue<PlacementManagerTask> concurrentLinkedQueue = this.queueRebuild;
        synchronized (concurrentLinkedQueue) {
            this.queueRebuild.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllOtherTasks() {
        ConcurrentLinkedQueue<PlacementManagerTask> concurrentLinkedQueue = this.queueOther;
        synchronized (concurrentLinkedQueue) {
            this.queueOther.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllDeferredTasks() {
        ConcurrentLinkedQueue<PlacementManagerTask> concurrentLinkedQueue = this.deferredQueue;
        synchronized (concurrentLinkedQueue) {
            this.deferredQueue.clear();
        }
    }

    public String getDebugString() {
        return String.format("T: %02d RB: %03d UL: %02d O: %02d D: %02d", this.threadMap.size(), this.queueRebuild.size(), this.queueUnload.size(), this.queueOther.size(), this.deferredQueue.size());
    }

    public void clearAllTasks() {
        this.removeAllUnloadTasks();
        this.removeAllRebuildTasks();
        this.removeAllOtherTasks();
        this.removeAllDeferredTasks();
        this.processing = false;
    }

    public void endAll() {
        this.clearAllTasks();
        this.stop();
    }

    public void close() throws Exception {
        this.endAll();
    }
}

