/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.Reference;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.mixin.entity.IMixinEntity;
import fi.dy.masa.litematica.mixin.render.IMixinGameRenderer;
import fi.dy.masa.litematica.render.IWorldSchematicRenderer;
import fi.dy.masa.litematica.render.schematic.BlockModelRendererSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderBatchDraw;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDataSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDispatcherLitematica;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDispatcherSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderObjectBuffers;
import fi.dy.masa.litematica.render.schematic.ChunkRendererSchematicVbo;
import fi.dy.masa.litematica.render.schematic.IChunkRendererFactory;
import fi.dy.masa.litematica.render.schematic.OverlayRenderType;
import fi.dy.masa.litematica.render.schematic.SchematicRenderState;
import fi.dy.masa.litematica.render.schematic.blocks.FallbackBlocks;
import fi.dy.masa.litematica.util.IAvatarInvoker;
import fi.dy.masa.litematica.util.IEntityInvoker;
import fi.dy.masa.litematica.util.IEntityRendererInvoker;
import fi.dy.masa.litematica.world.ChunkSchematic;
import fi.dy.masa.litematica.world.ChunkSchematicState;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.render.uniform.ChunkFixUniform;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.MathUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_10017;
import net.minecraft.class_10209;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_11282;
import net.minecraft.class_11515;
import net.minecraft.class_11531;
import net.minecraft.class_11658;
import net.minecraft.class_11659;
import net.minecraft.class_11890;
import net.minecraft.class_11903;
import net.minecraft.class_11954;
import net.minecraft.class_12137;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_1431;
import net.minecraft.class_1462;
import net.minecraft.class_1474;
import net.minecraft.class_148;
import net.minecraft.class_1496;
import net.minecraft.class_1920;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_276;
import net.minecraft.class_2769;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_7110;
import net.minecraft.class_758;
import net.minecraft.class_776;
import net.minecraft.class_824;
import net.minecraft.class_898;
import net.minecraft.class_9779;
import net.minecraft.class_9848;
import net.minecraft.class_9866;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class WorldRendererSchematic
implements IWorldSchematicRenderer {
    private static final Logger LOGGER = Litematica.LOGGER;
    private final class_310 mc;
    private final class_898 entityRenderManager;
    private final class_824 blockEntityRenderManager;
    private class_776 blockRenderManager;
    private final BlockModelRendererSchematic blockModelRenderer;
    private final Set<class_2586> blockEntities;
    private final List<ChunkRendererSchematicVbo> renderInfos;
    private final SchematicRenderState schematicRenderState;
    private Set<ChunkRendererSchematicVbo> chunksToUpdate;
    private WorldSchematic world;
    private ChunkRenderDispatcherSchematic chunkRendererDispatcher;
    private class_758 fogRenderer;
    private ChunkFixUniform chunkFixUniform;
    private ChunkRenderBatchDraw batchDraw;
    private GpuBufferSlice vanillaFogBuffer;
    private class_3695 profiler;
    private double lastCameraChunkUpdateX;
    private double lastCameraChunkUpdateY;
    private double lastCameraChunkUpdateZ;
    private double lastCameraX;
    private double lastCameraY;
    private double lastCameraZ;
    private float lastCameraPitch;
    private float lastCameraYaw;
    private ChunkRenderDispatcherLitematica renderDispatcher;
    private final IChunkRendererFactory renderChunkFactory;
    private final HashMap<class_243, UUID> renderedEntities;
    private int renderDistanceChunks;
    private int renderEntitiesStartupCounter;
    private int countEntitiesTotal;
    private int countEntitiesRendered;
    private int countEntitiesHidden;
    private double lastTranslucentSortX;
    private double lastTranslucentSortY;
    private double lastTranslucentSortZ;
    private boolean displayListEntitiesDirty;
    private boolean shouldDraw;

    public WorldRendererSchematic(class_310 mc) {
        this.mc = mc;
        this.renderChunkFactory = ChunkRendererSchematicVbo::new;
        this.blockRenderManager = class_310.method_1551().method_1541();
        this.blockEntities = new HashSet<class_2586>();
        this.renderInfos = new ArrayList<ChunkRendererSchematicVbo>(1024);
        this.renderedEntities = new HashMap();
        this.entityRenderManager = mc.method_1561();
        this.blockEntityRenderManager = mc.method_31975();
        this.blockModelRenderer = new BlockModelRendererSchematic(mc.method_1505(), this.blockRenderManager);
        this.blockModelRenderer.setBakedManager(mc.method_1554());
        this.fogRenderer = ((IMixinGameRenderer)mc.field_1773).litematica_getFogRenderer();
        this.schematicRenderState = new SchematicRenderState();
        this.chunksToUpdate = new LinkedHashSet<ChunkRendererSchematicVbo>();
        this.profiler = null;
        this.vanillaFogBuffer = null;
        this.batchDraw = null;
        this.chunkFixUniform = new ChunkFixUniform();
        this.shouldDraw = false;
        this.lastCameraChunkUpdateX = Double.MIN_VALUE;
        this.lastCameraChunkUpdateY = Double.MIN_VALUE;
        this.lastCameraChunkUpdateZ = Double.MIN_VALUE;
        this.lastCameraX = Double.MIN_VALUE;
        this.lastCameraY = Double.MIN_VALUE;
        this.lastCameraZ = Double.MIN_VALUE;
        this.lastCameraPitch = Float.MIN_VALUE;
        this.lastCameraYaw = Float.MIN_VALUE;
        this.renderDistanceChunks = -1;
        this.renderEntitiesStartupCounter = 2;
        this.displayListEntitiesDirty = true;
    }

    @Override
    public void markNeedsUpdate() {
        this.displayListEntitiesDirty = true;
    }

    @Override
    public boolean hasWorld() {
        return this.world != null;
    }

    @Override
    public String getDebugInfoRenders() {
        int rcTotal = this.chunkRendererDispatcher != null ? this.chunkRendererDispatcher.getRendererCount() : 0;
        int rcRendered = this.chunkRendererDispatcher != null ? this.getRenderedChunks() : 0;
        return String.format("C: %02d/%02d %sD: %02d, L: %02d, %s", rcRendered, rcTotal, this.mc.field_1730 ? "(s) " : "", this.renderDistanceChunks, 0, this.renderDispatcher == null ? "null" : this.renderDispatcher.getDebugInfo());
    }

    @Override
    public String getDebugInfoEntities() {
        return String.format("E: %02d/%02d, B: %02d", this.countEntitiesRendered, this.countEntitiesTotal, this.countEntitiesHidden);
    }

    protected ChunkRenderDispatcherLitematica getRenderDispatcher() {
        return this.renderDispatcher;
    }

    protected int getRenderedChunks() {
        int count = 0;
        for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
            ChunkRenderDataSchematic data = chunkRenderer.chunkRenderData;
            if (data == ChunkRenderDataSchematic.EMPTY || data.isBlockLayerEmpty()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public class_3695 getProfiler() {
        if (this.profiler == null) {
            this.profiler = class_10209.method_64146();
            this.profiler.method_16065();
        }
        return this.profiler;
    }

    @Override
    public class_898 getEntityRenderer() {
        return this.entityRenderManager;
    }

    @Override
    public class_824 getBlockEntityRenderer() {
        return this.blockEntityRenderManager;
    }

    @Override
    public <T extends Comparable<T>> class_2680 getFallbackState(class_2680 origState) {
        Collection props = origState.method_28501();
        class_2248 block = origState.method_26204();
        if (FallbackBlocks.BLOCK_TO_ID.containsKey(block)) {
            class_2960 id = FallbackBlocks.BLOCK_TO_ID.get(block);
            class_2680 newState = (class_2680)FallbackBlocks.ID_TO_STATE_MANAGER.get(id).method_11664();
            for (class_2769 entry : props) {
                class_2769 p = entry;
                if (!newState.method_28498(p)) continue;
                Comparable value = origState.method_11654(p);
                if (newState.method_11654(p).equals(value)) continue;
                newState = (class_2680)newState.method_11657(p, value);
            }
            return newState;
        }
        return origState;
    }

    protected GpuBufferSlice getEmptyFogBuffer() {
        if (this.fogRenderer == null) {
            this.fogRenderer = ((IMixinGameRenderer)this.mc.field_1773).litematica_getFogRenderer();
        }
        return this.fogRenderer.method_71109(class_758.class_4596.field_60101);
    }

    @Override
    public ChunkFixUniform getChunkFixUniform() {
        return this.chunkFixUniform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWorldAndLoadRenderers(@Nullable WorldSchematic worldSchematic) {
        this.lastCameraChunkUpdateX = Double.MIN_VALUE;
        this.lastCameraChunkUpdateY = Double.MIN_VALUE;
        this.lastCameraChunkUpdateZ = Double.MIN_VALUE;
        this.world = worldSchematic;
        if (worldSchematic != null) {
            this.loadRenderers(this.profiler);
        } else {
            this.chunksToUpdate.forEach(ChunkRendererSchematicVbo::deleteGlResources);
            this.chunksToUpdate.clear();
            this.renderInfos.forEach(ChunkRendererSchematicVbo::deleteGlResources);
            this.renderInfos.clear();
            if (this.chunkRendererDispatcher != null) {
                this.chunkRendererDispatcher.delete();
                this.chunkRendererDispatcher = null;
            }
            if (this.renderDispatcher != null) {
                this.renderDispatcher.stopWorkerThreads();
            }
            this.renderDispatcher = null;
            this.profiler = null;
            this.clearBlockBatchDraw();
            this.clearWorldRenderStates();
            this.clearChunkFixUniform();
            if (this.vanillaFogBuffer != null) {
                this.vanillaFogBuffer = null;
            }
            Set<class_2586> set = this.blockEntities;
            synchronized (set) {
                this.blockEntities.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadRenderers(@Nullable class_3695 profiler) {
        if (this.hasWorld()) {
            if (profiler == null) {
                profiler = class_10209.method_64146();
            }
            this.profiler = profiler;
            profiler.method_15396("load_renderers");
            if (this.renderDispatcher == null) {
                this.renderDispatcher = new ChunkRenderDispatcherLitematica(profiler);
            }
            this.displayListEntitiesDirty = true;
            this.renderDistanceChunks = (Integer)this.mc.field_1690.method_42503().method_41753() + 2;
            if (this.chunkRendererDispatcher != null) {
                this.chunkRendererDispatcher.delete();
            }
            this.stopChunkUpdates(profiler);
            this.clearBlockBatchDraw();
            this.clearWorldRenderStates();
            Set<class_2586> set = this.blockEntities;
            synchronized (set) {
                this.blockEntities.clear();
            }
            this.chunkRendererDispatcher = new ChunkRenderDispatcherSchematic(this.world, this.renderDistanceChunks, this, this.renderChunkFactory);
            this.renderEntitiesStartupCounter = 2;
            profiler.method_15407();
        }
    }

    protected void stopChunkUpdates(class_3695 profiler) {
        if (!this.chunksToUpdate.isEmpty()) {
            this.chunksToUpdate.forEach(ChunkRendererSchematicVbo::deleteGlResources);
        }
        this.chunksToUpdate.clear();
        this.renderDispatcher.stopChunkUpdates(profiler);
        this.profiler = null;
        this.clearBlockBatchDraw();
        this.clearWorldRenderStates();
        this.vanillaFogBuffer = null;
    }

    @Override
    public void setupTerrain(class_4184 camera, class_4604 frustum, int frameCount, boolean playerSpectator, class_3695 profiler) {
        this.profiler = profiler;
        profiler.method_15396("setup_terrain");
        if (this.chunkRendererDispatcher == null || (Integer)this.mc.field_1690.method_42503().method_41753() + 2 != this.renderDistanceChunks) {
            this.loadRenderers(profiler);
        }
        class_1297 entity = EntityUtils.getCameraEntity();
        if (this.mc.field_1724 == null) {
            return;
        }
        if (entity == null) {
            entity = this.mc.field_1724;
        }
        profiler.method_15405("camera");
        double entityX = entity.method_23317();
        double entityY = entity.method_23318();
        double entityZ = entity.method_23321();
        double diffX = entityX - this.lastCameraChunkUpdateX;
        double diffY = entityY - this.lastCameraChunkUpdateY;
        double diffZ = entityZ - this.lastCameraChunkUpdateZ;
        if (diffX * diffX + diffY * diffY + diffZ * diffZ > 256.0) {
            this.lastCameraChunkUpdateX = entityX;
            this.lastCameraChunkUpdateY = entityY;
            this.lastCameraChunkUpdateZ = entityZ;
            this.chunkRendererDispatcher.removeOutOfRangeRenderers();
        }
        profiler.method_15405("renderlist_camera");
        class_243 cameraPos = camera.method_71156();
        double cameraX = cameraPos.field_1352;
        double cameraY = cameraPos.field_1351;
        double cameraZ = cameraPos.field_1350;
        this.renderDispatcher.setCameraPosition(cameraPos);
        profiler.method_15405("culling");
        class_2338 viewPos = class_2338.method_49637((double)cameraX, (double)(cameraY + (double)entity.method_5751()), (double)cameraZ);
        int centerChunkX = viewPos.method_10263() >> 4;
        int centerChunkZ = viewPos.method_10260() >> 4;
        int renderDistance = (Integer)this.mc.field_1690.method_42503().method_41753() + 2;
        class_1923 viewChunk = new class_1923(viewPos);
        this.displayListEntitiesDirty = this.displayListEntitiesDirty || !this.chunksToUpdate.isEmpty() || entityX != this.lastCameraX || entityY != this.lastCameraY || entityZ != this.lastCameraZ || entity.method_36455() != this.lastCameraPitch || entity.method_36454() != this.lastCameraYaw;
        this.lastCameraX = cameraX;
        this.lastCameraY = cameraY;
        this.lastCameraZ = cameraZ;
        this.lastCameraPitch = camera.method_19329();
        this.lastCameraYaw = camera.method_19330();
        profiler.method_15405("update");
        ArrayList<class_1923> updatePositions = new ArrayList<class_1923>();
        if (this.displayListEntitiesDirty) {
            this.displayListEntitiesDirty = false;
            this.renderInfos.clear();
            profiler.method_15396("update_sort");
            List<class_1923> positions = DataManager.getSchematicPlacementManager().getAndUpdateVisibleChunks(viewChunk);
            int count = 0;
            profiler.method_15405("update_iteration");
            for (class_1923 chunkPos : positions) {
                ChunkRendererSchematicVbo chunkRenderer;
                int cx = chunkPos.field_9181;
                int cz = chunkPos.field_9180;
                if (Math.abs(cx - centerChunkX) <= renderDistance && Math.abs(cz - centerChunkZ) <= renderDistance && this.world.getChunkSource().method_12123(cx, cz) && (chunkRenderer = this.chunkRendererDispatcher.getChunkRenderer(cx, cz)) != null && frustum.method_23093(chunkRenderer.getBoundingBox())) {
                    if (chunkRenderer.needsUpdate() && chunkPos.equals((Object)viewChunk)) {
                        chunkRenderer.setNeedsUpdate(true);
                    }
                    this.renderInfos.add(chunkRenderer);
                }
                updatePositions.add(chunkPos);
                ++count;
            }
            profiler.method_15407();
        }
        profiler.method_15405("rebuild_near");
        Set<ChunkRendererSchematicVbo> set = this.chunksToUpdate;
        this.chunksToUpdate = new LinkedHashSet<ChunkRendererSchematicVbo>();
        for (ChunkRendererSchematicVbo chunkRendererTmp : this.renderInfos) {
            boolean isNear;
            if (!chunkRendererTmp.needsUpdate() && !set.contains(chunkRendererTmp)) continue;
            this.displayListEntitiesDirty = true;
            class_2338 pos = chunkRendererTmp.getOrigin().method_10069(8, 8, 8);
            boolean bl = isNear = pos.method_10262((class_2382)viewPos) < 1024.0;
            if (!chunkRendererTmp.needsImmediateUpdate() && !isNear) {
                this.chunksToUpdate.add(chunkRendererTmp);
                continue;
            }
            profiler.method_15396("update_now");
            this.profiler = profiler;
            this.renderDispatcher.updateChunkNow(chunkRendererTmp, profiler);
            chunkRendererTmp.clearNeedsUpdate();
            profiler.method_15407();
        }
        this.chunksToUpdate.addAll(set);
        this.clearBlockBatchDraw();
        this.clearWorldRenderStates();
        profiler.method_15407();
    }

    @Override
    public void updateChunks(long finishTimeNano, class_3695 profiler) {
        this.profiler = profiler;
        profiler.method_15396("run_chunk_updates");
        this.displayListEntitiesDirty |= this.renderDispatcher.runChunkUploads(finishTimeNano, profiler);
        if (this.profiler == null) {
            this.profiler = profiler;
        }
        profiler.method_15405("check_update");
        if (!this.chunksToUpdate.isEmpty()) {
            ChunkRendererSchematicVbo renderChunk;
            boolean immediate;
            boolean flag;
            Iterator<ChunkRendererSchematicVbo> iterator = this.chunksToUpdate.iterator();
            int index = 0;
            while (iterator.hasNext() && (flag = (immediate = (renderChunk = iterator.next()).needsImmediateUpdate()) ? this.renderDispatcher.updateChunkNow(renderChunk, profiler) : this.renderDispatcher.updateChunkLater(renderChunk, profiler))) {
                renderChunk.clearNeedsUpdate();
                iterator.remove();
                long i = finishTimeNano - System.nanoTime();
                if (i < 0L) break;
                ++index;
            }
            if (Reference.DEBUG_MODE && index > 0) {
                LOGGER.info("[WorldRenderer] updateChunks(): {} Chunks updated.", (Object)index);
            }
        }
        profiler.method_15407();
    }

    @Override
    public void capturePreMainValues(class_4184 camera, GpuBufferSlice fogBuffer, class_3695 profiler) {
        this.vanillaFogBuffer = fogBuffer;
        this.profiler = profiler;
    }

    @Override
    public int prepareBlockLayers(Matrix4fc matrix4fc, double cameraX, double cameraY, double cameraZ, class_3695 profiler) {
        this.profiler = profiler;
        RenderSystem.assertOnRenderThread();
        profiler.method_15396("layer_multi_phase");
        ArrayList<class_11282.class_11283> transformValues = new ArrayList<class_11282.class_11283>();
        EnumMap<class_11515, List<RenderPass.class_10884<GpuBufferSlice[]>>> renderMap = new EnumMap<class_11515, List<RenderPass.class_10884<GpuBufferSlice[]>>>(class_11515.class);
        for (class_11515 layer : class_11515.values()) {
            renderMap.put(layer, new ArrayList());
        }
        profiler.method_15405("layer_setup");
        int startIndex = 0;
        int stopIndex = this.renderInfos.size();
        int increment = 1;
        int indexCount = 0;
        int count = 0;
        boolean renderAsTranslucent = Configs.Visuals.RENDER_BLOCKS_AS_TRANSLUCENT.getBooleanValue();
        boolean renderCollidingBlocks = Configs.Visuals.RENDER_COLLIDING_SCHEMATIC_BLOCKS.getBooleanValue();
        GpuTextureView blockAtlas = this.mc.method_1531().method_4619(class_1059.field_5275).method_71659();
        int atlasWidth = blockAtlas.getWidth(0);
        int atlasHeight = blockAtlas.getHeight(0);
        Vector4f colorMod = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
        Matrix4f texMatrix = new Matrix4f();
        if (renderAsTranslucent) {
            colorMod = new Vector4f(1.0f, 1.0f, 1.0f, (float)Configs.Visuals.GHOST_BLOCK_ALPHA.getDoubleValue());
        }
        boolean startedDrawing = false;
        profiler.method_15405("layer_iteration");
        this.profiler = profiler;
        for (int i = startIndex; i != stopIndex; i += increment) {
            ChunkRendererSchematicVbo renderer = this.renderInfos.get(i);
            for (class_11515 layer : class_11515.values()) {
                VertexFormat.class_5595 indexType;
                GpuBuffer vertexBuffer;
                profiler.method_15405("layer_" + layer.method_72022());
                if (renderer.getChunkRenderData().isBlockLayerEmpty(layer)) continue;
                class_2338 chunkOrigin = renderer.getOrigin();
                ChunkRenderObjectBuffers buffers = renderer.getBlockBuffersByBlockLayer(layer);
                if (buffers == null || buffers.isClosed() || !renderer.getChunkRenderData().getBuiltBufferCache().hasBuiltBufferByBlockLayer(layer)) continue;
                if (buffers.getIndexBuffer() == null) {
                    if (buffers.getIndexCount() > indexCount) {
                        indexCount = buffers.getIndexCount();
                    }
                    vertexBuffer = null;
                    indexType = null;
                } else {
                    vertexBuffer = buffers.getIndexBuffer();
                    indexType = buffers.getIndexType();
                }
                int pos = transformValues.size();
                transformValues.add(new class_11282.class_11283(matrix4fc, (Vector4fc)colorMod, (Vector3fc)new Vector3f((float)((double)chunkOrigin.method_10263() - cameraX), (float)((double)chunkOrigin.method_10264() - cameraY), (float)((double)chunkOrigin.method_10260() - cameraZ)), (Matrix4fc)texMatrix));
                renderMap.get(layer).add((RenderPass.class_10884<GpuBufferSlice[]>)new RenderPass.class_10884(0, buffers.getVertexBuffer(), vertexBuffer, indexType, 0, buffers.getIndexCount(), (slices, uploader) -> uploader.upload("DynamicTransforms", slices[pos])));
                startedDrawing = true;
                ++count;
            }
        }
        if (startedDrawing) {
            this.chunkFixUniform.fillBuffer(atlasWidth, atlasHeight, 1.0f);
            GpuBufferSlice[] transformSlices = RenderSystem.getDynamicUniforms().method_71107(transformValues.toArray(new class_11282.class_11283[0]));
            this.batchDraw = new ChunkRenderBatchDraw(blockAtlas, renderMap, renderCollidingBlocks, renderAsTranslucent, indexCount, transformSlices, this.chunkFixUniform.getCurrentBuffer());
            this.shouldDraw = true;
        }
        profiler.method_15407();
        return count;
    }

    @Override
    public void drawBlockLayerGroup(class_11531 group, @Nullable class_12137 sampler) {
        if (this.batchDraw != null && this.shouldDraw) {
            this.profiler.method_15396("litematica_batch_draw_" + group.method_72166());
            RenderSystem.setShaderFog((GpuBufferSlice)this.getEmptyFogBuffer());
            this.batchDraw.draw(group, sampler, this.profiler);
            RenderSystem.setShaderFog((GpuBufferSlice)this.vanillaFogBuffer);
            this.profiler.method_15407();
        }
    }

    @Override
    public void clearBlockBatchDraw() {
        if (this.batchDraw != null) {
            this.batchDraw = null;
        }
        this.shouldDraw = false;
    }

    @Override
    public void clearChunkFixUniform() {
        if (this.chunkFixUniform != null) {
            try {
                this.chunkFixUniform.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.chunkFixUniform = new ChunkFixUniform();
    }

    @Override
    public void clearWorldRenderStates() {
        this.schematicRenderState.clear();
    }

    @Override
    public void updateCameraState(class_4184 camera, float tickProgress) {
        this.schematicRenderState.cameraState.field_63079 = camera.method_19332();
        this.schematicRenderState.cameraState.field_63078 = camera.method_71156();
        this.schematicRenderState.cameraState.field_63077 = camera.method_19328();
        this.schematicRenderState.cameraState.field_63080 = camera.method_19331().method_30951(tickProgress);
        this.schematicRenderState.cameraState.field_63081 = new Quaternionf((Quaternionfc)camera.method_23767());
    }

    @Override
    public void scheduleTranslucentSorting(class_243 cameraPos, class_3695 profiler) {
        double x = cameraPos.method_10216();
        double y = cameraPos.method_10214();
        double z = cameraPos.method_10215();
        this.profiler = profiler;
        double diffX = x - this.lastTranslucentSortX;
        double diffY = y - this.lastTranslucentSortY;
        double diffZ = z - this.lastTranslucentSortZ;
        if (diffX * diffX + diffY * diffY + diffZ * diffZ > 1.0) {
            this.lastTranslucentSortX = x;
            this.lastTranslucentSortY = y;
            this.lastTranslucentSortZ = z;
            int h = 0;
            for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
                if (!chunkRenderer.getChunkRenderData().isBlockLayerStarted(class_11515.field_60926) && (chunkRenderer.getChunkRenderData() == ChunkRenderDataSchematic.EMPTY || !chunkRenderer.hasOverlay()) || h++ >= 15) continue;
                this.renderDispatcher.updateTransparencyLater(chunkRenderer, profiler);
            }
        }
    }

    @Override
    public void renderBlockOverlays(class_4184 camera, float lineWidth, class_3695 profiler) {
        this.profiler = profiler;
        this.renderBlockOverlay(OverlayRenderType.OUTLINE, camera, lineWidth, profiler);
        this.renderBlockOverlay(OverlayRenderType.QUAD, camera, lineWidth, profiler);
    }

    protected void renderBlockOverlay(OverlayRenderType type, class_4184 camera, float lineWidth, class_3695 profiler) {
        profiler.method_15396("overlay_" + type.name());
        this.profiler = profiler;
        class_243 cameraPos = camera.method_71156();
        double x = cameraPos.field_1352;
        double y = cameraPos.field_1351;
        double z = cameraPos.field_1350;
        boolean renderThrough = Configs.Visuals.SCHEMATIC_OVERLAY_RENDER_THROUGH.getBooleanValue() || Hotkeys.RENDER_OVERLAY_THROUGH_BLOCKS.getKeybind().isKeybindHeld();
        RenderPipeline pipeline = renderThrough ? type.getRenderThrough() : type.getPipeline();
        float[] offset = new float[]{0.3f, 0.0f, 0.6f};
        Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
        profiler.method_15405("overlay_iterate");
        this.profiler = profiler;
        for (int i = this.renderInfos.size() - 1; i >= 0; --i) {
            ChunkRenderDataSchematic compiledChunk;
            ChunkRendererSchematicVbo renderer = this.renderInfos.get(i);
            if (renderer.getChunkRenderData() == ChunkRenderDataSchematic.EMPTY || !renderer.hasOverlay() || (compiledChunk = renderer.getChunkRenderData()).isOverlayTypeEmpty(type)) continue;
            ChunkRenderObjectBuffers buffers = renderer.getOverlayBuffersByType(type);
            class_2338 chunkOrigin = renderer.getOrigin();
            if (buffers == null || buffers.isClosed() || !renderer.getChunkRenderData().getBuiltBufferCache().hasBuiltBufferByType(type)) continue;
            matrix4fStack.pushMatrix();
            matrix4fStack.translate((float)((double)chunkOrigin.method_10263() - x), (float)((double)chunkOrigin.method_10264() - y), (float)((double)chunkOrigin.method_10260() - z));
            this.drawOverlayInternal(pipeline, buffers, -1, offset, false, false);
            matrix4fStack.popMatrix();
        }
        profiler.method_15407();
    }

    @Override
    public boolean renderBlock(class_1920 world, class_2680 state, class_2338 pos, class_4587 matrixStack, class_287 bufferBuilderIn) {
        this.getProfiler().method_15396("render_block");
        try {
            class_2464 renderType = state.method_26217();
            if (renderType == class_2464.field_11455) {
                this.getProfiler().method_15407();
                return false;
            }
            this.blockModelRenderer.setSeed(state.method_26190(pos));
            List<class_10889> parts = this.getModelParts(pos, state, (class_5819)this.blockModelRenderer.getRandom());
            boolean result = renderType == class_2464.field_11458 && this.blockModelRenderer.renderModel(world, parts, state, pos, matrixStack, (class_4588)bufferBuilderIn, false, class_4608.field_21444);
            this.getProfiler().method_15407();
            return result;
        }
        catch (Throwable throwable) {
            class_128 crashreport = class_128.method_560((Throwable)throwable, (String)"Tesselating block in world");
            class_129 crashReportSection = crashreport.method_562("Block being tesselated");
            class_129.method_586((class_129)crashReportSection, (class_5539)world, (class_2338)pos, (class_2680)state);
            this.getProfiler().method_15407();
            throw new class_148(crashreport);
        }
    }

    @Override
    public void renderFluid(class_1920 world, class_2680 blockState, class_3610 fluidState, class_2338 pos, class_287 bufferBuilderIn) {
        this.getProfiler().method_15396("render_fluid");
        try {
            this.blockRenderManager.method_3352(pos, world, (class_4588)bufferBuilderIn, blockState, fluidState);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getProfiler().method_15407();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void drawOverlayInternal(RenderPipeline pipeline, ChunkRenderObjectBuffers buffers, int color, float[] offset, boolean useColor, boolean useOffset) throws RuntimeException {
        VertexFormat.class_5595 indexType;
        GpuBuffer indexBuffer;
        if (!RenderSystem.isOnRenderThread()) return;
        Vector4f colorMod = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
        Vector3f modelOffset = new Vector3f();
        Matrix4f texMatrix = new Matrix4f();
        if (useOffset) {
            modelOffset.set(offset);
        }
        if (useColor) {
            float[] rgba = new float[]{class_9848.method_65101((int)color), class_9848.method_65102((int)color), class_9848.method_65103((int)color), class_9848.method_65100((int)color)};
            colorMod.set(rgba);
        }
        class_276 mainFb = RenderUtils.fb();
        GpuTextureView texture1 = mainFb.method_71639();
        GpuTextureView texture2 = mainFb.field_1478 ? mainFb.method_71640() : null;
        RenderSystem.class_5590 shapeIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)pipeline.getVertexFormatMode());
        if (buffers.getIndexBuffer() == null) {
            if (buffers.getIndexCount() <= 0) {
                LOGGER.error("WorldRendererSchematic#drawInternal() [{}] --> setup IndexBuffer --> NO INDEX COUNT!", (Object)buffers.getName());
                return;
            }
            indexBuffer = shapeIndexBuffer.method_68274(buffers.getIndexCount());
            indexType = shapeIndexBuffer.method_31924();
        } else {
            indexBuffer = buffers.getIndexBuffer();
            indexType = buffers.getIndexType();
        }
        GpuBufferSlice gpuSlice = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)colorMod, (Vector3fc)modelOffset, (Matrix4fc)texMatrix);
        try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "litematica:drawInternal/schematic_overlay", texture1, OptionalInt.empty(), texture2, OptionalDouble.empty());){
            pass.setPipeline(pipeline);
            RenderSystem.bindDefaultUniforms((RenderPass)pass);
            pass.setUniform("DynamicTransforms", gpuSlice);
            pass.setVertexBuffer(0, buffers.getVertexBuffer());
            pass.setIndexBuffer(indexBuffer, indexType);
            pass.drawIndexed(0, 0, buffers.getIndexCount(), 1);
            return;
        }
    }

    @Override
    public boolean hasQuadsForModel(List<class_10889> modelParts, class_2680 state, @Nullable class_2350 side) {
        class_10889 part = modelParts.getFirst();
        if (side != null) {
            List list = part.method_68509(side);
            return !list.isEmpty();
        }
        for (class_2350 entry : class_2350.values()) {
            List list = part.method_68509(entry);
            if (list.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasQuadsForModelPart(class_10889 modelPart, class_2680 state, @Nullable class_2350 side) {
        if (side != null) {
            List list = modelPart.method_68509(side);
            return !list.isEmpty();
        }
        for (class_2350 entry : class_2350.values()) {
            List list = modelPart.method_68509(entry);
            if (list.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public class_1087 getModelForState(class_2680 state) {
        return this.blockRenderManager.method_3351().method_3335(state);
    }

    @Override
    public List<class_10889> getModelParts(class_2338 pos, class_2680 state, class_5819 rand) {
        List parts = this.getModelForState(state).method_68512(rand);
        if (parts.isEmpty()) {
            parts = this.getModelForState(this.getFallbackState(state)).method_68512(rand);
        }
        if (parts.isEmpty()) {
            parts = this.getModelForState(state.method_26204().method_9564()).method_68512(rand);
            LOGGER.warn("getModelParts: Invalid Block Model for block at [{}] with state [{}]; Attempting to reset to default.", (Object)pos.method_23854(), (Object)state.toString());
        }
        return parts;
    }

    @Override
    public void prepareEntities(class_4184 camera, class_4604 frustum, class_11658 renderStates, class_9779 tickCounter, class_3695 profiler) {
        this.profiler = profiler;
        if (this.renderEntitiesStartupCounter > 0) {
            --this.renderEntitiesStartupCounter;
        } else {
            profiler.method_15396("entities_prepare");
            double cameraX = camera.method_71156().field_1352;
            double cameraY = camera.method_71156().field_1351;
            double cameraZ = camera.method_71156().field_1350;
            this.entityRenderManager.method_3941(camera, this.mc.field_1692);
            this.countEntitiesTotal = 0;
            this.countEntitiesRendered = 0;
            this.countEntitiesHidden = 0;
            this.countEntitiesTotal = this.world.getRegularEntityCount();
            this.renderedEntities.clear();
            LayerRange layerRange = DataManager.getRenderLayerRange();
            profiler.method_15405("entities_iterate");
            this.schematicRenderState.entityStates.clear();
            for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
                class_2338 pos = chunkRenderer.getOrigin();
                class_1923 chunkPos = chunkRenderer.getChunkPos();
                ImmutableList<class_1297> list = this.world.getEntitiesByChunk(chunkPos.field_9181, chunkPos.field_9180, fi.dy.masa.litematica.util.EntityUtils.NOT_PLAYER);
                for (class_1297 entityTmp : list) {
                    class_10017 state;
                    if (this.renderedEntities.containsKey(entityTmp.method_73189()) && this.renderedEntities.get(entityTmp.method_73189()).equals(entityTmp.method_5667()) || !layerRange.isPositionWithinRange(MathUtils.floor((double)entityTmp.method_23317()), MathUtils.floor((double)entityTmp.method_23318()), MathUtils.floor((double)entityTmp.method_23321()))) continue;
                    float tickProgress = tickCounter.method_60637(false);
                    if (entityTmp instanceof class_11890) {
                        class_11890 ple = (class_11890)entityTmp;
                        if (!(ple instanceof class_11903)) continue;
                        ((IAvatarInvoker)ple).litematica$tryUpdateSkin();
                        state = ((IEntityRendererInvoker)this.entityRenderManager).litematica_getRenderStateNullSafe(entityTmp, tickProgress);
                        if (state == null) continue;
                        this.schematicRenderState.entityStates.add(state);
                        this.renderedEntities.put(entityTmp.method_73189(), entityTmp.method_5667());
                        ++this.countEntitiesRendered;
                        continue;
                    }
                    boolean shouldRender = this.entityRenderManager.method_3950(entityTmp, frustum, cameraX, cameraY, cameraZ);
                    if (!shouldRender) continue;
                    if (entityTmp instanceof class_1462 || entityTmp instanceof class_1431 || entityTmp instanceof class_7110 || entityTmp instanceof class_1496 || entityTmp instanceof class_1474 || entityTmp instanceof class_9866) {
                        class_3611 fluid;
                        state = this.world.method_8320(entityTmp.method_24515());
                        class_3611 class_36112 = fluid = state.method_26227() != null ? state.method_26227().method_15772() : class_3612.field_15906;
                        if (!(fluid != class_3612.field_15910 && fluid != class_3612.field_15909 || ((IMixinEntity)entityTmp).litematica_isTouchingWater())) {
                            ((IEntityInvoker)entityTmp).litematica$toggleTouchingWater(true);
                        }
                    }
                    state = this.entityRenderManager.method_72977(entityTmp, tickProgress);
                    this.schematicRenderState.entityStates.add(state);
                    this.renderedEntities.put(entityTmp.method_73189(), entityTmp.method_5667());
                    ++this.countEntitiesRendered;
                }
            }
            profiler.method_15407();
        }
    }

    @Override
    public void renderEntities(class_4184 camera, class_4604 frustum, class_4587 matrices, class_11658 renderStates, class_11659 queue, class_3695 profiler) {
        if (this.schematicRenderState.entityStates.isEmpty()) {
            return;
        }
        class_243 pos = camera.method_71156();
        double cameraX = pos.method_10216();
        double cameraY = pos.method_10214();
        double cameraZ = pos.method_10215();
        profiler.method_15396("render_entities");
        for (class_10017 state : this.schematicRenderState.entityStates) {
            if (state == null) continue;
            this.entityRenderManager.method_72976(state, this.schematicRenderState.cameraState, state.field_53325 - cameraX, state.field_53326 - cameraY, state.field_53327 - cameraZ, matrices, queue);
        }
        profiler.method_15407();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareBlockEntities(class_4184 camera, class_4604 frustum, class_11658 renderStates, class_4587 matrices, float tickProgress, class_3695 profiler) {
        this.profiler = profiler;
        profiler.method_15396("block_entities_prepare");
        double cameraX = camera.method_71156().field_1352;
        double cameraY = camera.method_71156().field_1351;
        double cameraZ = camera.method_71156().field_1350;
        this.blockEntityRenderManager.method_3549(camera);
        LayerRange layerRange = DataManager.getRenderLayerRange();
        profiler.method_15405("block_entities");
        this.profiler = profiler;
        this.schematicRenderState.tileEntityStates.clear();
        profiler.method_15405("render_be");
        for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
            ChunkRenderDataSchematic data = chunkRenderer.getChunkRenderData();
            List<class_2586> tiles = data.getBlockEntities();
            if (tiles.isEmpty()) continue;
            class_2338 chunkOrigin = chunkRenderer.getOrigin();
            ChunkSchematic chunk = this.world.getChunkSource().getChunkForLighting(chunkOrigin.method_10263() >> 4, chunkOrigin.method_10260() >> 4);
            if (chunk == null || !chunk.getState().atLeast(ChunkSchematicState.LOADED) || data.getTimeBuilt() < chunk.getTimeCreated()) continue;
            for (class_2586 te : tiles) {
                class_2338 pos = te.method_11016();
                if (!layerRange.isPositionWithinRange(pos.method_10263(), pos.method_10264(), pos.method_10260())) continue;
                try {
                    matrices.method_22903();
                    matrices.method_22904((double)pos.method_10263() - cameraX, (double)pos.method_10264() - cameraY, (double)pos.method_10260() - cameraZ);
                    class_11954 state = this.blockEntityRenderManager.method_74348(te, tickProgress, null);
                    this.schematicRenderState.tileEntityStates.add(state);
                    matrices.method_22909();
                }
                catch (Exception err) {
                    LOGGER.error("[Pass 1] Error rendering blockEntities; Exception: {}", (Object)err.getLocalizedMessage());
                }
            }
        }
        profiler.method_15405("render_be_no_cull");
        Set<class_2586> set = this.blockEntities;
        synchronized (set) {
            for (class_2586 te : this.blockEntities) {
                class_2338 pos = te.method_11016();
                if (!layerRange.isPositionWithinRange(pos.method_10263(), pos.method_10264(), pos.method_10260())) continue;
                try {
                    matrices.method_22903();
                    matrices.method_22904((double)pos.method_10263() - cameraX, (double)pos.method_10264() - cameraY, (double)pos.method_10260() - cameraZ);
                    class_11954 state = this.blockEntityRenderManager.method_74348(te, tickProgress, null);
                    this.schematicRenderState.tileEntityStates.add(state);
                    matrices.method_22909();
                }
                catch (Exception err) {
                    LOGGER.error("[Pass 2] Error rendering blockEntities; Exception: {}", (Object)err.getLocalizedMessage());
                }
            }
        }
        profiler.method_15407();
    }

    @Override
    public void renderBlockEntities(class_4184 camera, class_4604 frustum, class_4587 matrices, class_11658 renderStates, class_11659 queue, class_3695 profiler) {
        if (this.schematicRenderState.tileEntityStates.isEmpty()) {
            return;
        }
        class_243 cameraPos = camera.method_71156();
        double cameraX = cameraPos.method_10216();
        double cameraY = cameraPos.method_10214();
        double cameraZ = cameraPos.method_10215();
        profiler.method_15396("render_block_entities");
        for (class_11954 state : this.schematicRenderState.tileEntityStates) {
            if (state == null) continue;
            class_2338 pos = state.field_62673;
            matrices.method_22903();
            matrices.method_22904((double)pos.method_10263() - cameraX, (double)pos.method_10264() - cameraY, (double)pos.method_10260() - cameraZ);
            this.blockEntityRenderManager.method_3555(state, matrices, queue, this.schematicRenderState.cameraState);
            matrices.method_22909();
        }
        profiler.method_15407();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlockEntities(Collection<class_2586> toRemove, Collection<class_2586> toAdd) {
        Set<class_2586> set = this.blockEntities;
        synchronized (set) {
            this.blockEntities.removeAll(toRemove);
            this.blockEntities.addAll(toAdd);
        }
    }

    @Override
    public void scheduleChunkRenders(int chunkX, int chunkZ, boolean immediate) {
        if (Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue()) {
            this.chunkRendererDispatcher.scheduleChunkRender(chunkX, chunkZ, immediate);
        }
    }

    @Override
    public ChunkSchematicState getChunkSchematicState(int chunkX, int chunkZ) {
        if (this.hasWorld()) {
            return this.world.getChunkSource().getChunkState(chunkX, chunkZ);
        }
        return ChunkSchematicState.NO_WORLD_EXCEPTION;
    }

    @Override
    public void setChunkSchematicState(int chunkX, int chunkZ, ChunkSchematicState state) {
        if (this.hasWorld()) {
            this.world.getChunkSource().setChunkState(chunkX, chunkZ, state);
        }
    }

    @Override
    public void reloadBlockRenderManager(class_776 manager) {
        this.blockRenderManager = manager;
        this.blockModelRenderer.reload(manager);
    }
}

