/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.Reference;
import fi.dy.masa.litematica.render.IWorldSchematicRenderer;
import fi.dy.masa.litematica.render.schematic.ChunkRendererSchematicVbo;
import fi.dy.masa.litematica.render.schematic.IChunkRendererFactory;
import fi.dy.masa.litematica.world.WorldSchematic;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.class_1923;

public class ChunkRenderDispatcherSchematic {
    protected final ConcurrentHashMap<Long, ChunkRendererSchematicVbo> chunkRenderers;
    protected final IWorldSchematicRenderer renderer;
    protected final IChunkRendererFactory chunkRendererFactory;
    protected final WorldSchematic world;
    protected int viewDistanceChunks;
    protected int viewDistanceBlocksSq;

    protected ChunkRenderDispatcherSchematic(WorldSchematic world, int viewDistanceChunks, IWorldSchematicRenderer worldRenderer, IChunkRendererFactory factory) {
        this.chunkRendererFactory = factory;
        this.chunkRenderers = new ConcurrentHashMap(4096, 0.9f, 2);
        this.renderer = worldRenderer;
        this.world = world;
        this.setViewDistanceChunks(viewDistanceChunks);
    }

    protected void setViewDistanceChunks(int viewDistanceChunks) {
        this.viewDistanceChunks = viewDistanceChunks;
        this.viewDistanceBlocksSq = viewDistanceChunks + 2 << 4;
        this.viewDistanceBlocksSq *= this.viewDistanceBlocksSq;
    }

    protected void delete() {
        for (Long key : this.chunkRenderers.keySet()) {
            ChunkRendererSchematicVbo chunkRenderer = this.chunkRenderers.get(key);
            if (chunkRenderer == null) continue;
            chunkRenderer.deleteGlResources();
        }
        this.chunkRenderers.clear();
    }

    private boolean rendererOutOfRange(ChunkRendererSchematicVbo cr) {
        if (cr == null) {
            return false;
        }
        if (cr.getDistanceSq() > (double)this.viewDistanceBlocksSq || cr.isEmpty()) {
            cr.deleteGlResources();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void removeOutOfRangeRenderers() {
        if (!this.chunkRenderers.isEmpty()) {
            int prevCount = this.chunkRenderers.size();
            try {
                for (Long key : this.chunkRenderers.keySet()) {
                    ConcurrentHashMap<Long, ChunkRendererSchematicVbo> concurrentHashMap = this.chunkRenderers;
                    synchronized (concurrentHashMap) {
                        ChunkRendererSchematicVbo cr = this.chunkRenderers.get(key);
                        if (this.rendererOutOfRange(cr)) {
                            try (ChunkRendererSchematicVbo cx = this.chunkRenderers.remove(key);){
                                cr.close();
                                cx.close();
                            }
                            catch (Exception e) {
                                Litematica.debugLogError("removeOutOfRangeRenderers: mapRemove() threw an exception; {}", e.getLocalizedMessage());
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                Litematica.debugLogError("removeOutOfRangeRenderers: keySet() threw an exception; {}", e.getLocalizedMessage());
            }
            if (Reference.DEBUG_MODE && prevCount != this.chunkRenderers.size()) {
                Litematica.LOGGER.warn("[Dispatch] removeOutOfRangeRenderers: [{}] -> [{}]", (Object)prevCount, (Object)this.chunkRenderers.size());
            }
        }
    }

    protected void scheduleChunkRender(int chunkX, int chunkZ, boolean immediate) {
        this.getOrCreateChunkRenderer(chunkX, chunkZ).ifPresent(cr -> cr.setNeedsUpdate(immediate));
    }

    protected int getRendererCount() {
        return this.chunkRenderers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Optional<ChunkRendererSchematicVbo> getOrCreateChunkRenderer(int chunkX, int chunkZ) {
        long index = class_1923.method_8331((int)chunkX, (int)chunkZ);
        try {
            if (!this.chunkRenderers.containsKey(index)) {
                ChunkRendererSchematicVbo renderer = this.chunkRendererFactory.create(this.world, this.renderer);
                renderer.setPosition(chunkX << 4, this.world.method_31607(), chunkZ << 4);
                renderer.setChunkPosition(chunkX, chunkZ);
                renderer.setNeedsUpdate(false);
                ConcurrentHashMap<Long, ChunkRendererSchematicVbo> concurrentHashMap = this.chunkRenderers;
                synchronized (concurrentHashMap) {
                    this.chunkRenderers.put(index, renderer);
                }
            }
            return Optional.of(this.chunkRenderers.get(index));
        }
        catch (Exception e) {
            Litematica.debugLogError("getOrCreateChunkRenderer: Exception obtaining a Chunk Renderer; {}", e.getLocalizedMessage());
            return Optional.empty();
        }
    }

    @Nullable
    protected ChunkRendererSchematicVbo getChunkRenderer(int chunkX, int chunkZ) {
        return this.getOrCreateChunkRenderer(chunkX, chunkZ).orElse(null);
    }
}

