/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render;

import fi.dy.masa.litematica.Reference;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.IWorldSchematicRenderer;
import fi.dy.masa.litematica.render.LitematicaRenderer;
import fi.dy.masa.litematica.schematic.placement.PlacementManagerDaemonHandler;
import fi.dy.masa.litematica.util.DebugHudMode;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.game.DebugHudUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_11630;
import net.minecraft.class_11632;
import net.minecraft.class_1937;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NonNull;

public class LitematicaDebugHud
implements class_11632 {
    public static final class_2960 LITEMATICA_DEBUG = class_2960.method_60655((String)"litematica", (String)"litematica_renderer");
    public static final class_2960 SECTION_ID = class_2960.method_60656((String)"litematica");
    public static final LitematicaDebugHud INSTANCE = new LitematicaDebugHud();
    private boolean left = true;

    private LitematicaDebugHud() {
    }

    public DebugHudMode getMode() {
        return (DebugHudMode)Configs.Generic.DEBUG_HUD_MODE.getOptionListValue();
    }

    public void checkConfig() {
        class_310 mc = class_310.method_1551();
        if (mc.field_61504 == null) {
            return;
        }
        if (this.getMode() == DebugHudMode.VANILLA) {
            DebugHudUtils.register((class_2960)LITEMATICA_DEBUG, (class_11632)INSTANCE);
        } else if (this.getMode() != DebugHudMode.VANILLA) {
            DebugHudUtils.unregister((class_2960)LITEMATICA_DEBUG);
        }
    }

    public boolean isLeft() {
        return this.left;
    }

    public void toggleRight() {
        this.left = false;
    }

    public void toggleLeft() {
        this.left = true;
    }

    public void method_72751(@Nonnull class_11630 lines, @Nullable class_1937 world, @Nullable class_2818 clientChunk, @Nullable class_2818 chunk) {
        if (this.getMode() == DebugHudMode.NONE) {
            return;
        }
        List<String> list = INSTANCE.getDebugLines();
        if (!list.isEmpty()) {
            lines.method_72744(SECTION_ID, list);
        }
    }

    public boolean method_72753(boolean reducedDebugInfo) {
        return true;
    }

    public List<String> getDebugLines() {
        WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
        ArrayList<String> list = new ArrayList<String>();
        String pre = GuiBase.TXT_GOLD;
        String red = GuiBase.TXT_RED;
        String rst = GuiBase.TXT_RST;
        if (worldSchematic != null) {
            Pair<String, String> pair = EntityUtils.getEntityDebug();
            IWorldSchematicRenderer renderer = LitematicaRenderer.getInstance().getWorldRenderer();
            String str = this.getWorldDebug(worldSchematic);
            String pmStr = PlacementManagerDaemonHandler.INSTANCE.getDebugString();
            if (this.isLeft()) {
                list.add(String.format("%s[Litematica]%s %s", pre, rst, renderer.getDebugInfoRenders()));
                if (Configs.Generic.DEBUG_HUD_WORLD.getBooleanValue()) {
                    list.add(String.format("%s[Litematica]%s %s %s", pre, rst, renderer.getDebugInfoEntities(), str));
                }
                if (Configs.Generic.DEBUG_HUD_PM_THREADS.getBooleanValue()) {
                    list.add(String.format("%s[Litematica]%s %s", pre, rst, pmStr));
                }
                if (!((String)pair.getLeft()).isEmpty()) {
                    list.add(String.format("%s[%s]%s %s", pre, pair.getLeft(), rst, pair.getRight()));
                }
            } else {
                list.add(String.format("%s %s[Litematica]%s", renderer.getDebugInfoRenders(), rst + pre, rst));
                if (Configs.Generic.DEBUG_HUD_WORLD.getBooleanValue()) {
                    list.add(String.format("%s %s %s[Litematica]%s", renderer.getDebugInfoEntities(), str, rst + pre, rst));
                }
                if (Configs.Generic.DEBUG_HUD_PM_THREADS.getBooleanValue()) {
                    list.add(String.format("%s %s[Litematica]%s", pmStr, pre, rst));
                }
                if (!((String)pair.getLeft()).isEmpty()) {
                    list.add(String.format("%s %s[%s]%s", pair.getRight(), rst + pre, pair.getLeft(), rst));
                }
            }
        } else if (this.isLeft()) {
            list.add(String.format("%s[Litematica]%s %s", pre, rst + red, StringUtils.translate((String)"litematica.gui.message.debug_hud.not_loaded", (Object[])new Object[0])));
        } else {
            list.add(String.format("%s%s %s[Litematica]%s", red, StringUtils.translate((String)"litematica.gui.message.debug_hud.not_loaded", (Object[])new Object[0]), rst + pre, rst));
        }
        return list;
    }

    private @NonNull String getWorldDebug(WorldSchematic worldSchematic) {
        String str = Reference.DEBUG_MODE ? String.format("[%s] // TE: %02d C: %02d, CT: %02d, CV: %02d", worldSchematic.getEntityDebug(), worldSchematic.getChunkSource().getTileEntityCount(), worldSchematic.getChunkSource().method_14151(), DataManager.getSchematicPlacementManager().getTouchedChunksCount(), DataManager.getSchematicPlacementManager().getLastVisibleChunksCount()) : String.format("E: %02d TE: %02d C: %02d, CT: %02d, CV: %02d", worldSchematic.getRegularEntityCount(), worldSchematic.getChunkSource().getTileEntityCount(), worldSchematic.getChunkSource().method_14151(), DataManager.getSchematicPlacementManager().getTouchedChunksCount(), DataManager.getSchematicPlacementManager().getLastVisibleChunksCount());
        return str;
    }
}

