/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.position;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.util.MathUtils;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.class_3542;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public enum SectorEdge implements class_3542
{
    START_ANGLE(false),
    END_ANGLE(false),
    INNER_RING(true),
    OUTER_RING(true);

    public static final // Could not load outer class - annotation placement on inner may be incorrect
    class_3542.class_7292<@NotNull SectorEdge> CODEC;
    public static final class_9139<@NotNull ByteBuf, @NotNull SectorEdge> PACKET_CODEC;
    public static final ImmutableList<@NotNull SectorEdge> VALUES;
    private final boolean isRadius;

    private SectorEdge(boolean isRadius) {
        this.isRadius = isRadius;
    }

    public boolean isRadius() {
        return this.isRadius;
    }

    public static SectorEdge getClosestEdge(int mouseX, int mouseY, double centerX, double centerY, double innerRadius, double outerRadius, double startAngle, double endAngle) {
        double line1X1 = centerX + innerRadius * Math.cos(startAngle);
        double line1Y1 = centerY + innerRadius * Math.sin(startAngle);
        double line1X2 = centerX + outerRadius * Math.cos(startAngle);
        double line1Y2 = centerY + outerRadius * Math.sin(startAngle);
        double line2X1 = centerX + innerRadius * Math.cos(endAngle);
        double line2Y1 = centerY + innerRadius * Math.sin(endAngle);
        double line2X2 = centerX + outerRadius * Math.cos(endAngle);
        double line2Y2 = centerY + outerRadius * Math.sin(endAngle);
        double distStart = MathUtils.distanceFromPointToLine(mouseX, mouseY, line1X1, line1Y1, line1X2, line1Y2);
        double distEnd = MathUtils.distanceFromPointToLine(mouseX, mouseY, line2X1, line2Y1, line2X2, line2Y2);
        double distMouse = Math.sqrt(((double)mouseX - centerX) * ((double)mouseX - centerX) + ((double)mouseY - centerY) * ((double)mouseY - centerY));
        double distInner = Math.abs(distMouse - innerRadius);
        double distOuter = Math.abs(distMouse - outerRadius);
        if (distStart < distEnd) {
            if (distInner < distOuter) {
                return distInner < distStart ? INNER_RING : START_ANGLE;
            }
            return distOuter < distStart ? OUTER_RING : START_ANGLE;
        }
        if (distInner < distOuter) {
            return distInner < distEnd ? INNER_RING : END_ANGLE;
        }
        return distOuter < distEnd ? OUTER_RING : END_ANGLE;
    }

    @Nonnull
    public String method_15434() {
        return this.name().toLowerCase();
    }

    public static SectorEdge fromStringStatic(String s) {
        for (SectorEdge e : VALUES) {
            if (!s.equalsIgnoreCase(e.name())) continue;
            return e;
        }
        return END_ANGLE;
    }

    static {
        CODEC = class_3542.method_28140(SectorEdge::values);
        PACKET_CODEC = class_9135.field_48554.method_56432(SectorEdge::fromStringStatic, SectorEdge::method_15434);
        VALUES = ImmutableList.copyOf((Object[])SectorEdge.values());
    }
}

