/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.position;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.util.position.Direction;
import fi.dy.masa.malilib.util.position.Vec3i;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.class_2495;
import net.minecraft.class_3341;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.NonNull;

public class IntBoundingBox {
    public static final IntBoundingBox ORIGIN = new IntBoundingBox(0, 0, 0, 0, 0, 0);
    public static final Codec<IntBoundingBox> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PrimitiveCodec.INT.fieldOf("minX").forGetter(get -> get.minX), (App)PrimitiveCodec.INT.fieldOf("minY").forGetter(get -> get.minY), (App)PrimitiveCodec.INT.fieldOf("minZ").forGetter(get -> get.minZ), (App)PrimitiveCodec.INT.fieldOf("maxX").forGetter(get -> get.maxX), (App)PrimitiveCodec.INT.fieldOf("maxY").forGetter(get -> get.maxY), (App)PrimitiveCodec.INT.fieldOf("maxZ").forGetter(get -> get.maxZ)).apply((Applicative)inst, IntBoundingBox::new));
    public static final class_9139<@NotNull ByteBuf, @NotNull IntBoundingBox> PACKET_CODEC = new class_9139<ByteBuf, IntBoundingBox>(){

        public void encode(ByteBuf buf, IntBoundingBox value) {
            class_9135.field_49675.encode((Object)buf, (Object)value.minX);
            class_9135.field_49675.encode((Object)buf, (Object)value.minY);
            class_9135.field_49675.encode((Object)buf, (Object)value.minZ);
            class_9135.field_49675.encode((Object)buf, (Object)value.maxX);
            class_9135.field_49675.encode((Object)buf, (Object)value.maxY);
            class_9135.field_49675.encode((Object)buf, (Object)value.maxZ);
        }

        public IntBoundingBox decode(ByteBuf buf) {
            return new IntBoundingBox((Integer)class_9135.field_49675.decode((Object)buf), (Integer)class_9135.field_49675.decode((Object)buf), (Integer)class_9135.field_49675.decode((Object)buf), (Integer)class_9135.field_49675.decode((Object)buf), (Integer)class_9135.field_49675.decode((Object)buf), (Integer)class_9135.field_49675.decode((Object)buf));
        }
    };
    public final int minX;
    public final int minY;
    public final int minZ;
    public final int maxX;
    public final int maxY;
    public final int maxZ;

    public IntBoundingBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public boolean contains(Vec3i pos) {
        return pos.method_10263() >= this.minX && pos.method_10263() <= this.maxX && pos.method_10260() >= this.minZ && pos.method_10260() <= this.maxZ && pos.method_10264() >= this.minY && pos.method_10264() <= this.maxY;
    }

    public boolean intersects(IntBoundingBox box) {
        return this.maxX >= box.minX && this.minX <= box.maxX && this.maxZ >= box.minZ && this.minZ <= box.maxZ && this.maxY >= box.minY && this.minY <= box.maxY;
    }

    public int getMinValueForAxis(Direction.Axis axis) {
        switch (axis) {
            case X: {
                return this.minX;
            }
            case Y: {
                return this.minY;
            }
            case Z: {
                return this.minZ;
            }
        }
        return 0;
    }

    public int getMaxValueForAxis(Direction.Axis axis) {
        switch (axis) {
            case X: {
                return this.maxX;
            }
            case Y: {
                return this.maxY;
            }
            case Z: {
                return this.maxZ;
            }
        }
        return 0;
    }

    public class_3341 toVanillaBox() {
        return new class_3341(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public class_2495 toNbtIntArray() {
        return new class_2495(new int[]{this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ});
    }

    public JsonArray toJson() {
        JsonArray arr = new JsonArray();
        arr.add((JsonElement)new JsonPrimitive((Number)this.minX));
        arr.add((JsonElement)new JsonPrimitive((Number)this.minY));
        arr.add((JsonElement)new JsonPrimitive((Number)this.minZ));
        arr.add((JsonElement)new JsonPrimitive((Number)this.maxX));
        arr.add((JsonElement)new JsonPrimitive((Number)this.maxY));
        arr.add((JsonElement)new JsonPrimitive((Number)this.maxZ));
        return arr;
    }

    @Nullable
    public IntBoundingBox createIntersectingBox(IntBoundingBox other) {
        if (this.intersects(other)) {
            int minX = Math.max(this.minX, other.minX);
            int minY = Math.max(this.minY, other.minY);
            int minZ = Math.max(this.minZ, other.minZ);
            int maxX = Math.min(this.maxX, other.maxX);
            int maxY = Math.min(this.maxY, other.maxY);
            int maxZ = Math.min(this.maxZ, other.maxZ);
            return new IntBoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
        }
        return null;
    }

    @Nullable
    public static IntBoundingBox fromJson(JsonArray arr) {
        if (arr.size() == 6) {
            try {
                return new IntBoundingBox(arr.get(0).getAsInt(), arr.get(1).getAsInt(), arr.get(2).getAsInt(), arr.get(3).getAsInt(), arr.get(4).getAsInt(), arr.get(5).getAsInt());
            }
            catch (Exception e) {
                MaLiLib.LOGGER.warn("Failed to read an IntBoundingBox from JSON '{}'", (Object)arr);
            }
        }
        return null;
    }

    public static IntBoundingBox fromVanillaBox(class_3341 box) {
        return IntBoundingBox.createProper(box.method_35415(), box.method_35416(), box.method_35417(), box.method_35418(), box.method_35419(), box.method_35420());
    }

    public static IntBoundingBox createProper(Vec3i pos1, Vec3i pos2) {
        return IntBoundingBox.createProper(pos1.method_10263(), pos1.method_10264(), pos1.method_10260(), pos2.method_10263(), pos2.method_10264(), pos2.method_10260());
    }

    public static IntBoundingBox createProper(int x1, int y1, int z1, int x2, int y2, int z2) {
        return new IntBoundingBox(Math.min(x1, x2), Math.min(y1, y2), Math.min(z1, z2), Math.max(x1, x2), Math.max(y1, y2), Math.max(z1, z2));
    }

    public static IntBoundingBox fromArray(int[] coords) {
        if (coords.length == 6) {
            return new IntBoundingBox(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
        }
        return ORIGIN;
    }

    public boolean equals(Object otherObj) {
        if (otherObj == this) {
            return true;
        }
        if (otherObj == null || this.getClass() != otherObj.getClass()) {
            return false;
        }
        if (otherObj instanceof IntBoundingBox) {
            IntBoundingBox other = (IntBoundingBox)otherObj;
            return this.minX == other.minX && this.minY == other.minY && this.minZ == other.minZ && this.maxX == other.maxX && this.maxY == other.maxY && this.maxZ == other.maxZ;
        }
        return false;
    }

    public @NonNull String toString() {
        return String.format("IntBoundingBox:{minX:%d, minY:%d, minZ:%d, maxX:%d, maxY:%d, maxZ:%d}\n", this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }
}

