/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.position;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.util.MathUtils;
import fi.dy.masa.malilib.util.StringUtils;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import net.minecraft.class_2350;
import net.minecraft.class_3542;
import net.minecraft.class_7995;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.NonNull;

public enum Direction implements class_3542
{
    DOWN(0, 1, -1, Axis.Y, AxisDirection.NEGATIVE, "down", class_2350.field_11033),
    UP(1, 0, -1, Axis.Y, AxisDirection.POSITIVE, "up", class_2350.field_11036),
    NORTH(2, 3, 2, Axis.Z, AxisDirection.NEGATIVE, "north", class_2350.field_11043),
    SOUTH(3, 2, 0, Axis.Z, AxisDirection.POSITIVE, "south", class_2350.field_11035),
    WEST(4, 5, 1, Axis.X, AxisDirection.NEGATIVE, "west", class_2350.field_11039),
    EAST(5, 4, 3, Axis.X, AxisDirection.POSITIVE, "east", class_2350.field_11034);

    public static final Direction[] ALL_DIRECTIONS;
    public static final Direction[] HORIZONTAL_DIRECTIONS;
    public static final Direction[] HORIZONTALS_BY_INDEX;
    public static final Direction[] VERTICAL_DIRECTIONS;
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    class_3542.class_7292<@NotNull Direction> CODEC;
    public static final IntFunction<Direction> INDEX_TO_VALUE;
    public static final class_9139<@NotNull ByteBuf, @NotNull Direction> PACKET_CODEC;
    public static final Direction[] VALUES;
    private final int index;
    private final int offsetX;
    private final int offsetY;
    private final int offsetZ;
    private final int oppositeId;
    private final int horizontalIndex;
    private final Axis axis;
    private final AxisDirection axisDirection;
    private final class_2350 vanillaDirection;
    private final String name;
    private final String translationKey;

    private Direction(int index, int oppositeId, int horizontalIndex, Axis axis, AxisDirection axisDirection, String name, class_2350 vanillaDirection) {
        this.index = index;
        this.offsetX = axis == Axis.X ? axisDirection.getOffset() : 0;
        this.offsetY = axis == Axis.Y ? axisDirection.getOffset() : 0;
        this.offsetZ = axis == Axis.Z ? axisDirection.getOffset() : 0;
        this.oppositeId = oppositeId;
        this.horizontalIndex = horizontalIndex;
        this.axis = axis;
        this.axisDirection = axisDirection;
        this.name = name;
        this.translationKey = "malilib.label.direction." + name;
        this.vanillaDirection = vanillaDirection;
    }

    public int getIndex() {
        return this.index;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public AxisDirection getAxisDirection() {
        return this.axisDirection;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return StringUtils.translate(this.translationKey, new Object[0]);
    }

    @Nonnull
    public String method_15434() {
        return this.name;
    }

    public int getXOffset() {
        return this.offsetX;
    }

    public int getYOffset() {
        return this.offsetY;
    }

    public int getZOffset() {
        return this.offsetZ;
    }

    public Direction getOpposite() {
        return ALL_DIRECTIONS[this.oppositeId];
    }

    public class_2350 getVanillaDirection() {
        return this.vanillaDirection;
    }

    public Direction rotateY() {
        switch (this.ordinal()) {
            case 2: {
                return EAST;
            }
            case 5: {
                return SOUTH;
            }
            case 3: {
                return WEST;
            }
            case 4: {
                return NORTH;
            }
        }
        return this;
    }

    public Direction rotateYCCW() {
        switch (this.ordinal()) {
            case 2: {
                return WEST;
            }
            case 4: {
                return SOUTH;
            }
            case 3: {
                return EAST;
            }
            case 5: {
                return NORTH;
            }
        }
        return this;
    }

    public Direction rotateAround(Axis axis) {
        switch (axis.ordinal()) {
            case 0: {
                if (this != WEST && this != EAST) {
                    return this.rotateX();
                }
                return this;
            }
            case 1: {
                if (this != UP && this != DOWN) {
                    return this.rotateY();
                }
                return this;
            }
            case 2: {
                if (this != NORTH && this != SOUTH) {
                    return this.rotateZ();
                }
                return this;
            }
        }
        return this;
    }

    public Direction rotateX() {
        switch (this.ordinal()) {
            case 2: {
                return DOWN;
            }
            case 0: {
                return SOUTH;
            }
            case 3: {
                return UP;
            }
            case 1: {
                return NORTH;
            }
        }
        return this;
    }

    public Direction rotateZ() {
        switch (this.ordinal()) {
            case 5: {
                return DOWN;
            }
            case 0: {
                return WEST;
            }
            case 4: {
                return UP;
            }
            case 1: {
                return EAST;
            }
        }
        return this;
    }

    public Direction cycle(boolean reverse) {
        return reverse ? this.cycleBackward() : this.cycleForward();
    }

    public Direction cycleForward() {
        int index = this.index;
        index = index >= 5 ? 0 : index + 1;
        return ALL_DIRECTIONS[index];
    }

    public Direction cycleBackward() {
        int index = this.index;
        index = index == 0 ? 5 : index - 1;
        return ALL_DIRECTIONS[index];
    }

    public static Direction byIndex(int index) {
        return ALL_DIRECTIONS[index % 6];
    }

    public static Direction byHorizontalIndex(int horizontalIndexIn) {
        return HORIZONTALS_BY_INDEX[horizontalIndexIn & 3];
    }

    public static Direction of(class_2350 facing) {
        return Direction.byIndex(facing.method_10146());
    }

    public static Direction fromAngle(double angle) {
        return Direction.byHorizontalIndex(MathUtils.floor(angle / 90.0 + 0.5) & 3);
    }

    public float getHorizontalAngle() {
        return (this.horizontalIndex & 3) * 90;
    }

    static {
        ALL_DIRECTIONS = new Direction[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
        HORIZONTAL_DIRECTIONS = new Direction[]{NORTH, SOUTH, WEST, EAST};
        HORIZONTALS_BY_INDEX = new Direction[]{SOUTH, WEST, NORTH, EAST};
        VERTICAL_DIRECTIONS = new Direction[]{DOWN, UP};
        CODEC = class_3542.method_28140(Direction::values);
        INDEX_TO_VALUE = class_7995.method_47914(Direction::getIndex, (Object[])Direction.values(), (class_7995.class_7996)class_7995.class_7996.field_41665);
        PACKET_CODEC = class_9135.method_56375(INDEX_TO_VALUE, Direction::getIndex);
        VALUES = Direction.values();
    }

    public static enum Axis implements class_3542
    {
        X(0, "x", false),
        Y(1, "y", true),
        Z(2, "z", false);

        public static final // Could not load outer class - annotation placement on inner may be incorrect
        class_3542.class_7292<@NotNull Axis> CODEC;
        public static final IntFunction<Axis> INDEX_TO_VALUE;
        public static final class_9139<@NotNull ByteBuf, @NotNull Axis> PACKET_CODEC;
        public static final Axis[] VALUES_ARR;
        public static final ImmutableList<Axis> ALL_AXES;
        private final int index;
        private final String name;
        private final boolean isVertical;

        private Axis(int index, String name, boolean isVertical) {
            this.index = index;
            this.name = name;
            this.isVertical = isVertical;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public @NonNull String method_15434() {
            return this.name;
        }

        public boolean isHorizontal() {
            return !this.isVertical;
        }

        public boolean isVertical() {
            return this.isVertical;
        }

        public Axis cycle(boolean reverse) {
            return reverse ? this.cycleBackward() : this.cycleForward();
        }

        public Axis cycleForward() {
            int index = this.index;
            if (++index >= VALUES_ARR.length) {
                index = 0;
            }
            return VALUES_ARR[index];
        }

        public Axis cycleBackward() {
            int index = this.index;
            if (--index < 0) {
                index = VALUES_ARR.length - 1;
            }
            return VALUES_ARR[index];
        }

        public static Axis byName(String name) {
            switch (name.toLowerCase(Locale.ROOT)) {
                case "x": {
                    return X;
                }
                case "y": {
                    return Y;
                }
                case "z": {
                    return Z;
                }
            }
            return Y;
        }

        static {
            CODEC = class_3542.method_28140(Axis::values);
            INDEX_TO_VALUE = class_7995.method_47914(Axis::getIndex, (Object[])Axis.values(), (class_7995.class_7996)class_7995.class_7996.field_41665);
            PACKET_CODEC = class_9135.method_56375(INDEX_TO_VALUE, Axis::getIndex);
            VALUES_ARR = Axis.values();
            ALL_AXES = ImmutableList.copyOf((Object[])VALUES_ARR);
        }
    }

    public static enum AxisDirection {
        NEGATIVE(-1),
        POSITIVE(1);

        private final int offset;

        private AxisDirection(int offset) {
            this.offset = offset;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

