/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.position;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fi.dy.masa.malilib.util.position.BlockPos;
import fi.dy.masa.malilib.util.position.Vec3i;
import io.netty.buffer.ByteBuf;
import java.util.Comparator;
import javax.annotation.Nonnull;
import net.minecraft.class_2382;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.NonNull;

public class ChunkSectionPos
extends Vec3i {
    public static final Codec<ChunkSectionPos> BLOCK_POS_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(get -> new BlockPos(get.method_10263(), get.method_10264(), get.method_10260()))).apply((Applicative)inst, ChunkSectionPos::new));
    public static final Codec<ChunkSectionPos> VEC3I_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PrimitiveCodec.INT.fieldOf("x").forGetter(class_2382::method_10263), (App)PrimitiveCodec.INT.fieldOf("y").forGetter(class_2382::method_10264), (App)PrimitiveCodec.INT.fieldOf("z").forGetter(class_2382::method_10260)).apply((Applicative)inst, ChunkSectionPos::new));
    public static final Codec<ChunkSectionPos> CODEC = VEC3I_CODEC;
    public static final class_9139<@NotNull ByteBuf, @NotNull ChunkSectionPos> PACKET_CODEC = new class_9139<ByteBuf, ChunkSectionPos>(){

        public void encode(@Nonnull ByteBuf buf, ChunkSectionPos value) {
            class_9135.field_49675.encode((Object)buf, (Object)value.method_10263());
            class_9135.field_49675.encode((Object)buf, (Object)value.method_10264());
            class_9135.field_49675.encode((Object)buf, (Object)value.method_10260());
        }

        @Nonnull
        public ChunkSectionPos decode(@Nonnull ByteBuf buf) {
            return new ChunkSectionPos((Integer)class_9135.field_49675.decode((Object)buf), (Integer)class_9135.field_49675.decode((Object)buf), (Integer)class_9135.field_49675.decode((Object)buf));
        }
    };

    public ChunkSectionPos(BlockPos pos) {
        this(pos.method_10263() >> 4, pos.method_10264() >> 4, pos.method_10260() >> 4);
    }

    public ChunkSectionPos(int x, int y, int z) {
        super(x, y, z);
    }

    @Override
    public @NonNull String toString() {
        return "ChunkSectionPos{x=" + this.method_10263() + ", y=" + this.method_10264() + ", z=" + this.method_10260() + "}";
    }

    public static ChunkSectionPos ofBlockPos(class_2382 blockPos) {
        return new ChunkSectionPos(blockPos.method_10263() >> 4, blockPos.method_10264() >> 4, blockPos.method_10260() >> 4);
    }

    public static class DistanceComparator
    implements Comparator<ChunkSectionPos> {
        private final ChunkSectionPos referencePosition;

        public DistanceComparator(ChunkSectionPos referencePosition) {
            this.referencePosition = referencePosition;
        }

        @Override
        public int compare(ChunkSectionPos pos1, ChunkSectionPos pos2) {
            double dist1 = pos1.getSquaredDistanceTo(this.referencePosition);
            double dist2 = pos2.getSquaredDistanceTo(this.referencePosition);
            return Double.compare(dist1, dist2);
        }
    }
}

