/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.position;

import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.util.StringUtils;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_3542;
import net.minecraft.class_7995;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public enum BlockRotation implements IConfigOptionListEntry,
class_3542
{
    NONE(0, "none", class_2470.field_11467),
    CW_90(1, "rotate_90", class_2470.field_11463),
    CW_180(2, "rotate_180", class_2470.field_11464),
    CCW_90(3, "rotate_270", class_2470.field_11465);

    public static final // Could not load outer class - annotation placement on inner may be incorrect
    class_3542.class_7292<@NotNull BlockRotation> CODEC;
    public static final IntFunction<BlockRotation> INDEX_TO_VALUE;
    public static final class_9139<@NotNull ByteBuf, @NotNull BlockRotation> PACKET_CODEC;
    public static final BlockRotation[] VALUES;
    private final int index;
    private final String name;
    private final String translationKey;
    private final class_2470 vanillaRotation;

    private BlockRotation(int index, String name, class_2470 vanillaRotation) {
        this.index = index;
        this.name = name;
        this.translationKey = "malilib.label.block_rotation." + name;
        this.vanillaRotation = vanillaRotation;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return StringUtils.translate(this.translationKey, new Object[0]);
    }

    @Override
    public String getStringValue() {
        return this.getName();
    }

    @Nonnull
    public String method_15434() {
        return this.name;
    }

    public BlockRotation add(BlockRotation rotation) {
        int index = this.index + rotation.index & 3;
        return VALUES[index];
    }

    public class_2350 rotate(class_2350 direction) {
        if (direction.method_10166() != class_2350.class_2351.field_11052) {
            switch (this.ordinal()) {
                case 1: {
                    return direction.method_10170();
                }
                case 2: {
                    return direction.method_10153();
                }
                case 3: {
                    return direction.method_10160();
                }
            }
        }
        return direction;
    }

    public BlockRotation getReverseRotation() {
        return switch (this.ordinal()) {
            case 3 -> CW_90;
            case 1 -> CCW_90;
            case 2 -> CW_180;
            default -> this;
        };
    }

    @Override
    public BlockRotation cycle(boolean reverse) {
        int index = this.index + (reverse ? -1 : 1) & 3;
        return VALUES[index];
    }

    @Override
    public IConfigOptionListEntry fromString(String value) {
        return BlockRotation.byName(value);
    }

    public class_2470 getVanillaRotation() {
        return this.vanillaRotation;
    }

    public static BlockRotation byName(String name) {
        for (BlockRotation rot : VALUES) {
            if (!rot.name.equalsIgnoreCase(name)) continue;
            return rot;
        }
        return NONE;
    }

    static {
        CODEC = class_3542.method_28140(BlockRotation::values);
        INDEX_TO_VALUE = class_7995.method_47914(BlockRotation::getIndex, (Object[])BlockRotation.values(), (class_7995.class_7996)class_7995.class_7996.field_41665);
        PACKET_CODEC = class_9135.method_56375(INDEX_TO_VALUE, BlockRotation::getIndex);
        VALUES = BlockRotation.values();
    }
}

