/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.position;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fi.dy.masa.malilib.util.MathUtils;
import fi.dy.masa.malilib.util.position.Direction;
import fi.dy.masa.malilib.util.position.Vec3d;
import fi.dy.masa.malilib.util.position.Vec3i;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.NonNull;

public class BlockPos
extends Vec3i {
    public static final Codec<BlockPos> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PrimitiveCodec.INT.fieldOf("x").forGetter(class_2382::method_10263), (App)PrimitiveCodec.INT.fieldOf("y").forGetter(class_2382::method_10264), (App)PrimitiveCodec.INT.fieldOf("z").forGetter(class_2382::method_10260)).apply((Applicative)inst, BlockPos::new));
    public static final class_9139<@NotNull ByteBuf, @NotNull BlockPos> PACKET_CODEC = new class_9139<ByteBuf, BlockPos>(){

        public void encode(@Nonnull ByteBuf buf, BlockPos value) {
            class_9135.field_49675.encode((Object)buf, (Object)value.method_10263());
            class_9135.field_49675.encode((Object)buf, (Object)value.method_10264());
            class_9135.field_49675.encode((Object)buf, (Object)value.method_10260());
        }

        @Nonnull
        public BlockPos decode(@Nonnull ByteBuf buf) {
            return new BlockPos((Integer)class_9135.field_49675.decode((Object)buf), (Integer)class_9135.field_49675.decode((Object)buf), (Integer)class_9135.field_49675.decode((Object)buf));
        }
    };
    public static final BlockPos ORIGIN = new BlockPos(0, 0, 0);

    public BlockPos(int x, int y, int z) {
        super(x, y, z);
    }

    public BlockPos(Vec3i pos) {
        super(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public BlockPos offset(Direction direction, int amount) {
        return new BlockPos(this.method_10263() + direction.getXOffset() * amount, this.method_10264() + direction.getYOffset() * amount, this.method_10260() + direction.getZOffset() * amount);
    }

    public BlockPos offset(Direction direction) {
        return this.offset(direction, 1);
    }

    public BlockPos add(int x, int y, int z) {
        return x == 0 && y == 0 && z == 0 ? this : new BlockPos(this.method_10263() + x, this.method_10264() + y, this.method_10260() + z);
    }

    public BlockPos subtract(int x, int y, int z) {
        return x == 0 && y == 0 && z == 0 ? this : new BlockPos(this.method_10263() - x, this.method_10264() - y, this.method_10260() - z);
    }

    public BlockPos add(class_2382 other) {
        return this.add(other.method_10263(), other.method_10264(), other.method_10260());
    }

    public @NonNull BlockPos subtract(class_2382 other) {
        return this.subtract(other.method_10263(), other.method_10264(), other.method_10260());
    }

    public BlockPos add(Vec3i other) {
        return this.add(other.method_10263(), other.method_10264(), other.method_10260());
    }

    public BlockPos subtract(Vec3i other) {
        return this.subtract(other.method_10263(), other.method_10264(), other.method_10260());
    }

    public BlockPos toImmutable() {
        return this;
    }

    public class_2338 toVanillaPos() {
        return this;
    }

    public BlockPos down() {
        return new BlockPos(this.method_10263(), this.method_10264() - 1, this.method_10260());
    }

    public BlockPos up() {
        return new BlockPos(this.method_10263(), this.method_10264() + 1, this.method_10260());
    }

    public @NonNull BlockPos north() {
        return new BlockPos(this.method_10263(), this.method_10264(), this.method_10260() - 1);
    }

    public @NonNull BlockPos south() {
        return new BlockPos(this.method_10263(), this.method_10264(), this.method_10260() + 1);
    }

    public @NonNull BlockPos west() {
        return new BlockPos(this.method_10263() - 1, this.method_10264(), this.method_10260());
    }

    public @NonNull BlockPos east() {
        return new BlockPos(this.method_10263() + 1, this.method_10264(), this.method_10260());
    }

    public long toPackedLong() {
        int x = this.method_10263() & 0x3FFFFFF;
        int y = this.method_10264() & 0xFFF;
        int z = this.method_10260() & 0x3FFFFFF;
        return (long)x << 38 | (long)y << 26 | (long)z;
    }

    @Override
    public @NonNull String toString() {
        return "BlockPos{x=" + this.method_10263() + ", y=" + this.method_10264() + ", z=" + this.method_10260() + "}";
    }

    public static BlockPos fromPacked(long posLong) {
        int x = (int)(posLong >> 38);
        int y = (int)(posLong << 26 >> 52);
        int z = (int)(posLong << 38 >> 38);
        return new BlockPos(x, y, z);
    }

    public static BlockPos ofFloored(Vec3d pos) {
        return BlockPos.ofFloored(pos.x, pos.y, pos.z);
    }

    public static BlockPos ofFloored(double x, double y, double z) {
        return new BlockPos(MathUtils.floor(x), MathUtils.floor(y), MathUtils.floor(z));
    }

    @Nullable
    public static BlockPos of(@Nullable class_2338 pos) {
        if (pos == null) {
            return null;
        }
        return new BlockPos(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public static class MutBlockPos
    extends BlockPos {
        private int x;
        private int y;
        private int z;

        public MutBlockPos() {
            this(0, 0, 0);
        }

        public MutBlockPos(int x, int y, int z) {
            super(x, y, z);
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public MutBlockPos(class_2382 pos) {
            this(pos.method_10263(), pos.method_10264(), pos.method_10260());
        }

        public int method_10263() {
            return this.x;
        }

        public int method_10264() {
            return this.y;
        }

        public int method_10260() {
            return this.z;
        }

        public @NonNull MutBlockPos setX(int x) {
            this.x = x;
            return this;
        }

        public @NonNull MutBlockPos setY(int y) {
            this.y = y;
            return this;
        }

        public @NonNull MutBlockPos setZ(int z) {
            this.z = z;
            return this;
        }

        public MutBlockPos set(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }

        public MutBlockPos set(class_2382 pos) {
            this.x = pos.method_10263();
            this.y = pos.method_10264();
            this.z = pos.method_10260();
            return this;
        }

        public MutBlockPos setOffset(class_2382 pos, class_2350 direction) {
            this.x = pos.method_10263() + this.getAxisOffset(direction, class_2350.class_2351.field_11048);
            this.y = pos.method_10264() + this.getAxisOffset(direction, class_2350.class_2351.field_11052);
            this.z = pos.method_10260() + this.getAxisOffset(direction, class_2350.class_2351.field_11051);
            return this;
        }

        public int getAxisOffset(class_2350 direction, class_2350.class_2351 axis) {
            return direction.method_10166() == class_2350.class_2351.field_11048 ? direction.method_10171().method_10181() : 0;
        }

        public MutBlockPos setOffset(class_2382 pos, Direction direction) {
            return this.setOffset(pos, direction, 1);
        }

        public MutBlockPos setOffset(class_2382 pos, Direction direction, int amount) {
            this.x = pos.method_10263() + direction.getXOffset() * amount;
            this.y = pos.method_10264() + direction.getYOffset() * amount;
            this.z = pos.method_10260() + direction.getZOffset() * amount;
            return this;
        }

        public MutBlockPos move(Direction direction, int amount) {
            this.set(this.method_10263() + direction.getXOffset() * amount, this.method_10264() + direction.getYOffset() * amount, this.method_10260() + direction.getZOffset() * amount);
            return this;
        }

        public MutBlockPos move(Direction direction) {
            return this.move(direction, 1);
        }

        public MutBlockPos addMut(Vec3i pos) {
            this.x += pos.method_10263();
            this.y += pos.method_10264();
            this.z += pos.method_10260();
            return this;
        }

        public MutBlockPos subtractMut(Vec3i pos) {
            this.x -= pos.method_10263();
            this.y -= pos.method_10264();
            this.z -= pos.method_10260();
            return this;
        }

        public MutBlockPos addMut(int x, int y, int z) {
            this.x += x;
            this.y += y;
            this.z += z;
            return this;
        }

        public MutBlockPos subtractMut(int x, int y, int z) {
            this.x -= x;
            this.y -= y;
            this.z -= z;
            return this;
        }

        @Override
        public BlockPos toImmutable() {
            return new BlockPos(this.x, this.y, this.z);
        }

        @Override
        public class_2338 toVanillaPos() {
            return new class_2338(this.x, this.y, this.z);
        }
    }
}

