/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.data.tag.util;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.util.data.tag.BaseData;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.data.tag.EmptyData;
import fi.dy.masa.malilib.util.data.tag.converter.DataConverterNbt;
import fi.dy.masa.malilib.util.data.tag.util.SizeTracker;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;

public class DataFileUtils {
    @Nullable
    public static CompoundData readCompoundDataFromNbtFile(Path file) {
        if (!Files.isReadable(file)) {
            return null;
        }
        BaseData data = null;
        try (DataInputStream is = new DataInputStream(new BufferedInputStream(new GZIPInputStream(Files.newInputStream(file, new OpenOption[0]))));){
            data = DataFileUtils.readFromNbtStream(is);
        }
        catch (ZipException e) {
            try (DataInputStream is2 = new DataInputStream(new BufferedInputStream(Files.newInputStream(file, new OpenOption[0])));){
                data = DataFileUtils.readFromNbtStream(is2);
            }
            catch (Exception e2) {
                MaLiLib.LOGGER.warn("DataFileUtils.readCompoundDataFromNbtFile: Failed to read (assumed uncompressed) NBT data from file '{}'", (Object)file.toAbsolutePath(), (Object)e2);
            }
        }
        catch (Exception e) {
            MaLiLib.LOGGER.warn("DataFileUtils.readCompoundDataFromNbtFile: Failed to read NBT data from file '{}'", (Object)file.toAbsolutePath(), (Object)e);
        }
        if (data instanceof CompoundData) {
            return (CompoundData)data;
        }
        return null;
    }

    public static boolean writeCompoundDataToCompressedNbtFile(Path file, BaseData data) {
        return DataFileUtils.writeCompoundDataToCompressedNbtFile(file, data, "");
    }

    public static boolean writeCompoundDataToCompressedNbtFile(Path file, BaseData data, String rootTagName) {
        boolean bl;
        DataOutputStream os = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(Files.newOutputStream(file, new OpenOption[0]))));
        try {
            bl = DataFileUtils.writeToNbtStream(os, data, rootTagName);
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                MaLiLib.LOGGER.warn("DataFileUtils.writeCompoundDataToCompressedNbtFile: Failed to write NBT data to file '{}'", (Object)file.toAbsolutePath(), (Object)e);
                return false;
            }
        }
        os.close();
        return bl;
    }

    @Nullable
    public static BaseData readFromNbtStream(DataInput input) {
        try {
            byte tagType = input.readByte();
            if (tagType == 0) {
                return EmptyData.INSTANCE;
            }
            input.readUTF();
            return BaseData.createTag(10, input, 0, new SizeTracker(0L));
        }
        catch (Exception e) {
            MaLiLib.LOGGER.warn("DataFileUtils.readFromNbtStream: Exception while reading NBT data", (Throwable)e);
            return null;
        }
    }

    public static boolean writeToNbtStream(DataOutput output, BaseData data, String tagName) {
        try {
            output.writeByte(data.getType());
            if (data.getType() != 0) {
                output.writeUTF(tagName);
                data.write(output);
            }
            return true;
        }
        catch (Exception e) {
            MaLiLib.LOGGER.warn("DataFileUtils.writeToNbtStream: Exception while writing NBT data", (Throwable)e);
            return false;
        }
    }

    @Deprecated
    public static CompoundData readFromFileUsingNbtIo(@Nonnull Path file) {
        return DataFileUtils.readFromFileUsingNbtIo(file, class_2505.method_53898());
    }

    @Deprecated
    public static CompoundData readFromFileUsingNbtIo(@Nonnull Path file, class_2505 tracker) {
        if (!Files.exists(file, new LinkOption[0]) || !Files.isReadable(file)) {
            return null;
        }
        try {
            return DataConverterNbt.fromVanillaCompound(class_2507.method_10629((InputStream)Files.newInputStream(file, new OpenOption[0]), (class_2505)tracker));
        }
        catch (Exception e) {
            MaLiLib.LOGGER.warn("DataFileUtils.readFromFileUsingNbtIo: Failed to read NBT data from file '{}'", (Object)file.toString());
            return null;
        }
    }

    @Deprecated
    public static void writeToFileUsingNbtIo(@Nonnull CompoundData tag, @Nonnull Path file) {
        try {
            class_2507.method_30614((class_2487)DataConverterNbt.toVanillaCompound(tag), (Path)file);
        }
        catch (Exception err) {
            MaLiLib.LOGGER.warn("DataFileUtils.writeToFileUsingNbtIo: Failed to write NBT data to file");
        }
    }
}

