/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.data.tag.util;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.util.data.tag.BaseData;
import fi.dy.masa.malilib.util.data.tag.EmptyData;
import fi.dy.masa.malilib.util.data.tag.util.DataFileUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataByteBufUtils {
    public static Optional<BaseData> fromByteBuf(ByteBuf byteBuf) {
        Optional<BaseData> optional;
        ByteBufInputStream is = new ByteBufInputStream(byteBuf);
        try {
            optional = Optional.ofNullable(DataFileUtils.readFromNbtStream((DataInput)is));
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                MaLiLib.LOGGER.error("Exception while reading data from ByteBuf; {}", (Object)e.getLocalizedMessage());
                return Optional.empty();
            }
        }
        is.close();
        return optional;
    }

    public static ByteBuf toByteBuf(@Nullable BaseData data, String rootTagName) {
        ByteBuf byteBuf = UnpooledByteBufAllocator.DEFAULT.buffer();
        return DataByteBufUtils.toByteBuf(byteBuf, data, rootTagName);
    }

    public static ByteBuf toByteBuf(@Nonnull ByteBuf byteBuf, @Nullable BaseData data, String rootTagName) {
        if (data == null || data.isEmpty()) {
            data = EmptyData.INSTANCE;
        }
        try (ByteBufOutputStream os = new ByteBufOutputStream(byteBuf);){
            DataFileUtils.writeToNbtStream((DataOutput)os, data, rootTagName);
        }
        catch (Exception e) {
            MaLiLib.LOGGER.error("Exception while writing data to a ByteBuf; {}", (Object)e.getLocalizedMessage());
        }
        return byteBuf;
    }
}

