/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.data.tag;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.util.data.tag.BaseData;
import fi.dy.masa.malilib.util.data.tag.ByteArrayData;
import fi.dy.masa.malilib.util.data.tag.ByteData;
import fi.dy.masa.malilib.util.data.tag.DataView;
import fi.dy.masa.malilib.util.data.tag.DoubleData;
import fi.dy.masa.malilib.util.data.tag.FloatData;
import fi.dy.masa.malilib.util.data.tag.IntArrayData;
import fi.dy.masa.malilib.util.data.tag.IntData;
import fi.dy.masa.malilib.util.data.tag.ListData;
import fi.dy.masa.malilib.util.data.tag.LongArrayData;
import fi.dy.masa.malilib.util.data.tag.LongData;
import fi.dy.masa.malilib.util.data.tag.ShortData;
import fi.dy.masa.malilib.util.data.tag.StringData;
import fi.dy.masa.malilib.util.data.tag.converter.DataConverterNbt;
import fi.dy.masa.malilib.util.data.tag.util.DataOps;
import fi.dy.masa.malilib.util.data.tag.util.SizeTracker;
import fi.dy.masa.malilib.util.log.AnsiLogger;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.class_2520;

public class CompoundData
extends BaseData
implements DataView {
    private static final AnsiLogger LOGGER = new AnsiLogger(CompoundData.class, true, true);
    public static final String TAG_NAME = "TAG_Compound";
    private static final Pattern SIMPLE_VALUE = Pattern.compile("[A-Za-z0-9._+-]+");
    private final LinkedHashMap<String, BaseData> values;

    public CompoundData() {
        this(new LinkedHashMap<String, BaseData>());
    }

    public CompoundData(LinkedHashMap<String, BaseData> values) {
        super(10, TAG_NAME);
        this.values = values;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public Set<String> getKeys() {
        return this.values.keySet();
    }

    public Set<Map.Entry<String, BaseData>> entrySet() {
        return this.values.entrySet();
    }

    @Override
    public boolean contains(String key, int requestedType) {
        BaseData data = this.values.get(key);
        if (data == null) {
            return false;
        }
        int hasType = data.getType();
        if (hasType == requestedType) {
            return true;
        }
        if (requestedType == 99) {
            return hasType == 1 || hasType == 2 || hasType == 3 || hasType == 4 || hasType == 5 || hasType == 6;
        }
        return false;
    }

    @Override
    public boolean containsList(String key, int listEntryType) {
        BaseData data = this.values.get(key);
        if (data.getType() == 9 && data instanceof ListData) {
            ListData listData = (ListData)data;
            LOGGER.debug("containsList: req [{}], has [{}]", listEntryType, listData.getContainedType());
            return listData.getContainedType() == listEntryType;
        }
        LOGGER.debug("containsList: req [{}], has: [NULL] (Type found: '{}')", listEntryType, data.getType());
        return false;
    }

    @Override
    public boolean containsLenient(String key) {
        return this.values.containsKey(key);
    }

    public boolean remove(String key) {
        return this.values.remove(key) != null;
    }

    @Override
    public Optional<BaseData> getData(String key) {
        return Optional.ofNullable(this.values.get(key));
    }

    @Override
    public Optional<Integer> getDataType(String key) {
        BaseData data = this.values.get(key);
        if (data != null) {
            return Optional.of(data.getType());
        }
        return Optional.empty();
    }

    @Override
    public boolean getBoolean(String key) {
        BaseData data = this.values.get(key);
        return data != null && data.getType() == 1 && ((ByteData)data).value != 0;
    }

    protected long getAsAnyInt(BaseData data) {
        if (data.getType() == 1) {
            return ((ByteData)data).value;
        }
        if (data.getType() == 2) {
            return ((ShortData)data).value;
        }
        if (data.getType() == 3) {
            return ((IntData)data).value;
        }
        if (data.getType() == 4) {
            return ((LongData)data).value;
        }
        return 0L;
    }

    @Override
    public byte getByte(String key) {
        BaseData data = this.values.get(key);
        if (data == null) {
            return 0;
        }
        if (data.getType() == 1) {
            return ((ByteData)data).value;
        }
        return (byte)this.getAsAnyInt(data);
    }

    @Override
    public short getShort(String key) {
        BaseData data = this.values.get(key);
        if (data == null) {
            return 0;
        }
        if (data.getType() == 2) {
            return ((ShortData)data).value;
        }
        return (short)this.getAsAnyInt(data);
    }

    @Override
    public int getInt(String key) {
        BaseData data = this.values.get(key);
        if (data == null) {
            return 0;
        }
        if (data.getType() == 3) {
            return ((IntData)data).value;
        }
        return (int)this.getAsAnyInt(data);
    }

    @Override
    public long getLong(String key) {
        BaseData data = this.values.get(key);
        if (data == null) {
            return 0L;
        }
        if (data.getType() == 4) {
            return ((LongData)data).value;
        }
        return this.getAsAnyInt(data);
    }

    @Override
    public float getFloat(String key) {
        BaseData data = this.values.get(key);
        return data != null && data.getType() == 5 ? ((FloatData)data).value : 0.0f;
    }

    @Override
    public double getDouble(String key) {
        BaseData data = this.values.get(key);
        return data != null && data.getType() == 6 ? ((DoubleData)data).value : 0.0;
    }

    @Override
    public String getString(String key) {
        BaseData data = this.values.get(key);
        return data != null && data.getType() == 8 ? ((StringData)data).value : "";
    }

    @Override
    public byte[] getByteArray(String key) {
        BaseData data = this.values.get(key);
        return data != null && data.getType() == 7 ? ((ByteArrayData)data).value : new byte[]{};
    }

    @Override
    public int[] getIntArray(String key) {
        BaseData data = this.values.get(key);
        return data != null && data.getType() == 11 ? ((IntArrayData)data).value : new int[]{};
    }

    @Override
    public long[] getLongArray(String key) {
        BaseData data = this.values.get(key);
        return data != null && data.getType() == 12 ? ((LongArrayData)data).value : new long[]{};
    }

    @Override
    public CompoundData getCompound(String key) {
        BaseData data = this.values.get(key);
        return data != null && data.getType() == 10 ? (CompoundData)data : new CompoundData();
    }

    @Override
    public ListData getList(String key) {
        BaseData data = this.values.get(key);
        return data != null && data.getType() == 9 ? (ListData)data : new ListData();
    }

    @Override
    public <T> Optional<T> getCodec(String key, Codec<T> codec, DynamicOps<BaseData> ops) {
        BaseData data = this.values.get(key);
        return data == null ? Optional.empty() : codec.parse(ops, (Object)data).resultOrPartial(e -> MaLiLib.LOGGER.error("getCodec: Failed to get field ({}={}): {}", (Object)key, (Object)data.toString(), e));
    }

    @Override
    @Deprecated
    public <T> Optional<T> getNbtCodec(String key, Codec<T> codec, DynamicOps<class_2520> ops) {
        BaseData data = this.values.get(key);
        return data == null ? Optional.empty() : codec.parse(ops, (Object)DataConverterNbt.toVanillaNbt(data)).resultOrPartial(e -> MaLiLib.LOGGER.error("getNbtCodec: Failed to get field ({}={}): {}", (Object)key, (Object)data.toString(), e));
    }

    public CompoundData putBoolean(String key, boolean value) {
        this.values.put(key, new ByteData(value ? (byte)1 : 0));
        return this;
    }

    public CompoundData putByte(String key, byte value) {
        this.values.put(key, new ByteData(value));
        return this;
    }

    public CompoundData putShort(String key, short value) {
        this.values.put(key, new ShortData(value));
        return this;
    }

    public CompoundData putInt(String key, int value) {
        this.values.put(key, new IntData(value));
        return this;
    }

    public CompoundData putLong(String key, long value) {
        this.values.put(key, new LongData(value));
        return this;
    }

    public CompoundData putFloat(String key, float value) {
        this.values.put(key, new FloatData(value));
        return this;
    }

    public CompoundData putDouble(String key, double value) {
        this.values.put(key, new DoubleData(value));
        return this;
    }

    public CompoundData putString(String key, String value) {
        this.values.put(key, new StringData(value));
        return this;
    }

    public CompoundData putByteArray(String key, byte[] value) {
        this.values.put(key, new ByteArrayData(value));
        return this;
    }

    public CompoundData putIntArray(String key, int[] value) {
        this.values.put(key, new IntArrayData(value));
        return this;
    }

    public CompoundData putLongArray(String key, long[] value) {
        this.values.put(key, new LongArrayData(value));
        return this;
    }

    public CompoundData put(String key, BaseData value) {
        this.values.put(key, value);
        return this;
    }

    public <T> CompoundData putCodec(String key, Codec<T> codec, @Nullable T value) {
        return this.putCodec(key, codec, DataOps.INSTANCE, value);
    }

    public <T> CompoundData putCodec(String key, Codec<T> codec, DynamicOps<BaseData> ops, @Nullable T value) {
        if (value != null) {
            this.values.put(key, (BaseData)codec.encodeStart(ops, value).getOrThrow());
        }
        return this;
    }

    @Deprecated
    public <T> CompoundData putNbtCodec(String key, Codec<T> codec, DynamicOps<class_2520> ops, @Nullable T value) {
        if (value != null) {
            this.values.put(key, DataConverterNbt.fromVanillaNbt((class_2520)codec.encodeStart(ops, value).getOrThrow()));
        }
        return this;
    }

    @Override
    public CompoundData copy() {
        CompoundData copy = new CompoundData();
        for (Map.Entry<String, BaseData> entry : this.values.entrySet()) {
            copy.values.put(entry.getKey(), entry.getValue().copy());
        }
        return copy;
    }

    public CompoundData combine(CompoundData other) {
        if (other == null || other.isEmpty()) {
            return this.copy();
        }
        for (String key : other.values.keySet()) {
            BaseData data = other.values.get(key);
            if (data.getType() == 10 && this.values.containsKey(key) && this.values.get(key).getType() == 10) {
                CompoundData out = ((CompoundData)this.values.get(key)).combine((CompoundData)data);
                this.values.put(key, out);
                continue;
            }
            this.values.put(key, data);
        }
        return this.copy();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        Set<String> keys = this.values.keySet();
        for (String key : keys) {
            if (sb.length() != 1) {
                sb.append(',');
            }
            sb.append(CompoundData.handleEscape(key));
            sb.append(':');
            sb.append(this.values.get(key));
        }
        return sb.append('}').toString();
    }

    @Override
    public void write(DataOutput output) throws IOException {
        for (Map.Entry<String, BaseData> entry : this.values.entrySet()) {
            CompoundData.writeEntry(entry.getKey(), entry.getValue(), output);
        }
        output.writeByte(0);
    }

    public static CompoundData read(DataInput input, int depth, SizeTracker sizeTracker) throws IOException {
        if (depth > 512) {
            throw new IOException("Tried to read NBT tag with too high complexity, depth > 512");
        }
        LinkedHashMap<String, BaseData> values = new LinkedHashMap<String, BaseData>();
        while (true) {
            BaseData data;
            byte tagType = input.readByte();
            sizeTracker.increment(1);
            if (tagType == 0) break;
            String key = input.readUTF();
            sizeTracker.increment(2 + key.length());
            try {
                data = BaseData.createTag(tagType, input, depth + 1, sizeTracker);
            }
            catch (IOException e) {
                MaLiLib.LOGGER.warn("Failed to read data for compound member {}", (Object)key);
                throw e;
            }
            if (data == null) {
                throw new IOException("CompoundData: Failed to read entry named " + key);
            }
            values.put(key, data);
        }
        return new CompoundData(values);
    }

    public static String handleEscape(String str) {
        return SIMPLE_VALUE.matcher(str).matches() ? str : StringData.quoteAndEscape(str);
    }

    public static void writeEntry(String key, BaseData data, DataOutput output) throws IOException {
        output.writeByte(data.getType());
        if (data.getType() != 0) {
            output.writeUTF(key);
            data.write(output);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (o instanceof CompoundData) {
            String key;
            CompoundData data = (CompoundData)o;
            boolean result = false;
            Iterator<String> iterator = this.getKeys().iterator();
            while (iterator.hasNext() && (result = this.values.get(key = iterator.next()).equals(data.values.get(key)))) {
            }
            return result;
        }
        return false;
    }

    public int hashCode() {
        return this.values != null ? this.values.hashCode() : 0;
    }
}

