/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.data.tag;

import fi.dy.masa.malilib.util.data.tag.BaseData;
import fi.dy.masa.malilib.util.data.tag.NumberData;
import fi.dy.masa.malilib.util.data.tag.util.SizeTracker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;

public class ByteData
extends BaseData
implements NumberData {
    public static final String TAG_NAME = "TAG_Byte";
    public final byte value;

    public ByteData(byte value) {
        super(1, TAG_NAME);
        this.value = value;
    }

    public byte getByte() {
        return this.value;
    }

    @Override
    public ByteData copy() {
        return this;
    }

    @Override
    public String toString() {
        return this.value + "b";
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Optional<Number> asNumber() {
        return Optional.of(this.value);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        output.writeByte(this.value);
    }

    public static ByteData read(DataInput input, int depth, SizeTracker sizeTracker) throws IOException {
        sizeTracker.increment(1);
        return new ByteData(input.readByte());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteData other = (ByteData)o;
        return this.value == other.value;
    }

    public int hashCode() {
        return this.value;
    }
}

