/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class IntRange {
    public static final Codec<IntRange> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PrimitiveCodec.INT.fieldOf("start").forGetter(get -> get.first), (App)PrimitiveCodec.INT.fieldOf("length").forGetter(get -> get.length)).apply((Applicative)inst, IntRange::new));
    public static final class_9139<@NotNull ByteBuf, @NotNull IntRange> PACKET_CODEC = new class_9139<ByteBuf, IntRange>(){

        public void encode(@Nonnull ByteBuf buf, IntRange value) {
            class_9135.field_49675.encode((Object)buf, (Object)value.first);
            class_9135.field_49675.encode((Object)buf, (Object)value.length);
        }

        @Nonnull
        public IntRange decode(@Nonnull ByteBuf buf) {
            return new IntRange((Integer)class_9135.field_49675.decode((Object)buf), (Integer)class_9135.field_49675.decode((Object)buf));
        }
    };
    protected final int first;
    protected final int last;
    protected final int length;

    public IntRange(int start, int length) {
        this.first = start;
        this.length = length;
        this.last = start + length - 1;
    }

    public int getFirst() {
        return this.first;
    }

    public int getLast() {
        return this.last;
    }

    public int getLength() {
        return this.length;
    }

    public boolean contains(int value) {
        return value >= this.first && value <= this.last;
    }

    public String toString() {
        return String.format("IntRange:{first:%d,last:%d,length:%d}", this.first, this.last, this.length);
    }

    public static IntRange of(int start, int length) {
        return new IntRange(start, length);
    }
}

