/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.data;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

public class ImmutableCopy<V> {
    private final List<V> list = new ArrayList<V>();

    public ImmutableCopy(List<V> values) {
        this.list.addAll(values);
    }

    public static <T> ImmutableCopy<T> of(List<T> list) {
        return new ImmutableCopy<T>(list);
    }

    public static <T> ImmutableCopy<T> of(Set<T> set) {
        return new ImmutableCopy(set.stream().toList());
    }

    public static <T> ImmutableCopy<T> of(Collection<T> coll) {
        return new ImmutableCopy<T>(coll.stream().toList());
    }

    public static <T> ImmutableCopy<T> of(Iterable<T> iter) {
        ArrayList list = new ArrayList();
        iter.forEach(list::add);
        return new ImmutableCopy(list);
    }

    public static <T> ImmutableCopy<T> of(Stream<T> stream) {
        ArrayList list = new ArrayList();
        stream.forEach(list::add);
        return new ImmutableCopy(list);
    }

    public static <T> ImmutableCopy<T> of(T[] arr) {
        return new ImmutableCopy<T>(Arrays.stream(arr).toList());
    }

    public ImmutableList<V> toList() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (V v : this.list) {
            builder.add(v);
        }
        this.clear();
        return builder.build();
    }

    public ImmutableSet<V> toSet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (V v : this.list) {
            builder.add(v);
        }
        this.clear();
        return builder.build();
    }

    public ImmutableCollection<V> toCollection() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (V v : this.list) {
            builder.add(v);
        }
        this.clear();
        return builder.build();
    }

    private void clear() {
        this.list.clear();
    }
}

