/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.data;

public enum DyeColorCode {
    WHITE(0, "\u00a7f", "white"),
    ORANGE(1, "\u00a76", "orange"),
    MAGENTA(2, "\u00a7d", "magenta"),
    LIGHT_BLUE(3, "\u00a79", "light_blue"),
    YELLOW(4, "\u00a7e", "yellow"),
    LIME(5, "\u00a7a", "lime"),
    PINK(6, "\u00a7d", "pink"),
    GRAY(7, "\u00a78", "gray"),
    SILVER(8, "\u00a77", "silver"),
    CYAN(9, "\u00a73", "cyan"),
    PURPLE(10, "\u00a75", "purple"),
    BLUE(11, "\u00a71", "blue"),
    BROWN(12, "\u00a76", "brown"),
    GREEN(13, "\u00a72", "green"),
    RED(14, "\u00a7c", "red"),
    BLACK(15, "\u00a70", "black");

    private static final DyeColorCode[] COLOR_CODES_BY_META;
    private final int meta;
    private final String name;
    private final String textColorCode;

    private DyeColorCode(int meta, String textColorCode, String name) {
        this.meta = meta;
        this.textColorCode = textColorCode;
        this.name = name;
    }

    public int getMetadata() {
        return this.meta;
    }

    public String getName() {
        return this.name;
    }

    public String getTextColorCode() {
        return this.textColorCode;
    }

    public static DyeColorCode getByMeta(int meta) {
        if (meta < 0 || meta > 15) {
            meta = 0;
        }
        return COLOR_CODES_BY_META[meta];
    }

    static {
        COLOR_CODES_BY_META = DyeColorCode.values();
    }
}

