/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import net.minecraft.class_2382;
import net.minecraft.class_243;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.ApiStatus;

public class MathUtils {
    private static final int[] MULTIPLY_DE_BRUIJN_BIT_POSITION = new int[]{0, 1, 28, 2, 29, 14, 24, 3, 30, 22, 20, 15, 25, 17, 4, 8, 31, 27, 13, 23, 21, 19, 16, 7, 26, 12, 18, 6, 11, 5, 10, 9};

    public static double average(int[] values) {
        int size = values.length;
        if (size == 0) {
            return 0.0;
        }
        long sum = 0L;
        for (int value : values) {
            sum += (long)value;
        }
        return (double)sum / (double)size;
    }

    public static double average(long[] values) {
        int size = values.length;
        if (size == 0) {
            return 0.0;
        }
        long sum = 0L;
        for (long value : values) {
            sum += value;
        }
        return (double)sum / (double)size;
    }

    public static double average(double[] values) {
        int size = values.length;
        if (size == 0) {
            return 0.0;
        }
        double sum = 0.0;
        for (double value : values) {
            sum += value;
        }
        return sum / (double)size;
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        return MathUtils.min(value, max);
    }

    public static long clamp(long value, long min, long max) {
        if (value < min) {
            return min;
        }
        return MathUtils.min(value, max);
    }

    public static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        return MathUtils.min(value, max);
    }

    public static double clamp(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        return MathUtils.min(value, max);
    }

    public static int floor(float value) {
        int i = (int)value;
        return value < (float)i ? i - 1 : i;
    }

    public static int floor(double value) {
        int i = (int)value;
        return value < (double)i ? i - 1 : i;
    }

    public static float round(float value, int decimalPlaces) {
        if (decimalPlaces < 0 || decimalPlaces > 9) {
            decimalPlaces = 0;
        }
        float fixedDec = value;
        double scale = Math.pow(10.0, decimalPlaces);
        fixedDec *= (float)scale;
        fixedDec = Math.round(fixedDec);
        return fixedDec / (float)scale;
    }

    public static double round(double value, int decimalPlaces) {
        if (decimalPlaces < 0 || decimalPlaces > 9) {
            decimalPlaces = 0;
        }
        int scale = (int)Math.pow(10.0, decimalPlaces);
        double scaledUp = value * (double)scale;
        double dec = scaledUp % 1.0;
        double fixedDec = (double)Math.round(dec * 10.0) / 10.0;
        double newValue = scaledUp + fixedDec;
        return (double)Math.round(newValue) / (double)scale;
    }

    public static int roundDown(int value, int interval) {
        int remainder;
        if (interval == 0 || value == 0) {
            return 0;
        }
        if (value < 0) {
            interval *= -1;
        }
        return (remainder = value % interval) == 0 ? value : value - remainder;
    }

    public static double roundDown(double value, double interval) {
        double remainder;
        if (interval == 0.0 || value == 0.0) {
            return 0.0;
        }
        if (value < 0.0) {
            interval *= -1.0;
        }
        return (remainder = value % interval) == 0.0 ? value : value - remainder;
    }

    public static int roundUp(int value, int interval) {
        int remainder;
        if (interval == 0) {
            return 0;
        }
        if (value == 0) {
            return interval;
        }
        if (value < 0) {
            interval *= -1;
        }
        return (remainder = value % interval) == 0 ? value : value + interval - remainder;
    }

    public static double roundUp(double value, double interval) {
        double remainder;
        if (interval == 0.0) {
            return 0.0;
        }
        if (value == 0.0) {
            return interval;
        }
        if (value < 0.0) {
            interval *= -1.0;
        }
        return (remainder = value % interval) == 0.0 ? value : value + interval - remainder;
    }

    public static long roundUp(long number, long interval) {
        long i;
        if (interval == 0L) {
            return 0L;
        }
        if (number == 0L) {
            return interval;
        }
        if (number < 0L) {
            interval *= -1L;
        }
        return (i = number % interval) == 0L ? number : number + interval - i;
    }

    public static float sqrtf(double value) {
        return (float)Math.sqrt(value);
    }

    public static double wrapRadianAngle(double angle) {
        double twoPi = Math.PI * 2;
        if ((angle %= twoPi) < 0.0) {
            angle += twoPi;
        }
        return angle;
    }

    public static double distanceFromPointToLine(double pointX, double pointY, double line1X, double line1Y, double line2X, double line2Y) {
        double num = Math.abs((line2X - line1X) * (line1Y - pointY) - (line1X - pointX) * (line2Y - line1Y));
        double diffX = line2X - line1X;
        double diffY = line2Y - line1Y;
        double den = Math.sqrt(diffX * diffX + diffY * diffY);
        return num / den;
    }

    public static int getMinValue(int[] arr) {
        if (arr.length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
        int size = arr.length;
        int minValue = arr[0];
        for (int i = 1; i < size; ++i) {
            if (arr[i] >= minValue) continue;
            minValue = arr[i];
        }
        return minValue;
    }

    public static int getMaxValue(int[] arr) {
        if (arr.length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
        int size = arr.length;
        int maxValue = arr[0];
        for (int i = 1; i < size; ++i) {
            if (arr[i] <= maxValue) continue;
            maxValue = arr[i];
        }
        return maxValue;
    }

    public static long getMinValue(long[] arr) {
        if (arr.length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
        int size = arr.length;
        long minValue = arr[0];
        for (int i = 1; i < size; ++i) {
            if (arr[i] >= minValue) continue;
            minValue = arr[i];
        }
        return minValue;
    }

    public static long getMaxValue(long[] arr) {
        if (arr.length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
        int size = arr.length;
        long maxValue = arr[0];
        for (int i = 1; i < size; ++i) {
            if (arr[i] <= maxValue) continue;
            maxValue = arr[i];
        }
        return maxValue;
    }

    public static float positiveModulo(float numerator, float denominator) {
        return (numerator % denominator + denominator) % denominator;
    }

    public static double positiveModulo(double numerator, double denominator) {
        return (numerator % denominator + denominator) % denominator;
    }

    public static float wrapDegrees(float value) {
        if ((value %= 360.0f) >= 180.0f) {
            value -= 360.0f;
        }
        if (value < -180.0f) {
            value += 360.0f;
        }
        return value;
    }

    public static double wrapDegrees(double value) {
        if ((value %= 360.0) >= 180.0) {
            value -= 360.0;
        }
        if (value < -180.0) {
            value += 360.0;
        }
        return value;
    }

    public static int wrapDegrees(int angle) {
        if ((angle %= 360) >= 180) {
            angle -= 360;
        }
        if (angle < -180) {
            angle += 360;
        }
        return angle;
    }

    public static class_243 getRotationVector(float yaw, float pitch) {
        double f = Math.cos((double)(-yaw) * (Math.PI / 180) - Math.PI);
        double g = Math.sin((double)(-yaw) * (Math.PI / 180) - Math.PI);
        double h = -Math.cos((double)(-pitch) * (Math.PI / 180));
        double i = Math.sin((double)(-pitch) * (Math.PI / 180));
        return new class_243(g * h, i, f * h);
    }

    public static long getCoordinateRandom(int x, int y, int z) {
        long l = (long)x * 3129871L ^ (long)z * 116129781L ^ (long)y;
        return l * l * 42317861L + l * 11L;
    }

    public static long getPositionRandom(class_2382 pos) {
        return MathUtils.getCoordinateRandom(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public static int smallestEncompassingPowerOfTwo(int value) {
        int i = value - 1;
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        return i + 1;
    }

    private static boolean isPowerOfTwo(int value) {
        return value != 0 && (value & value - 1) == 0;
    }

    public static int log2DeBruijn(int value) {
        value = MathUtils.isPowerOfTwo(value) ? value : MathUtils.smallestEncompassingPowerOfTwo(value);
        return MULTIPLY_DE_BRUIJN_BIT_POSITION[(int)((long)value * 125613361L >> 27) & 0x1F];
    }

    public static int log2(int value) {
        if (MathUtils.isPowerOfTwo(value)) {
            return MathUtils.log2DeBruijn(value);
        }
        return MathUtils.log2DeBruijn(value) - 1;
    }

    public static class_243 scale(class_243 vec, double factor) {
        return new class_243(vec.field_1352 * factor, vec.field_1351 * factor, vec.field_1350 * factor);
    }

    public static int min(int val1, int val2) {
        return Math.min(val1, val2);
    }

    public static float min(float val1, float val2) {
        return Math.min(val1, val2);
    }

    public static double min(double val1, double val2) {
        return Math.min(val1, val2);
    }

    public static long min(long val1, long val2) {
        return Math.min(val1, val2);
    }

    public static short min(short val1, short val2) {
        return val1 <= val2 ? val1 : val2;
    }

    public static byte min(byte val1, byte val2) {
        return val1 <= val2 ? val1 : val2;
    }

    public static Fraction min(Fraction val1, Fraction val2) {
        return val1.compareTo(val2) < 0 ? val1 : val2;
    }

    @ApiStatus.Experimental
    public static Number min(Number val1, Number val2) {
        try {
            return val1.doubleValue() <= val2.doubleValue() ? (Number)val1 : (Number)val2;
        }
        catch (Exception exception) {
            return val1.hashCode() <= val2.hashCode() ? (Number)val1 : (Number)val2;
        }
    }

    public static int max(int val1, int val2) {
        return Math.max(val1, val2);
    }

    public static float max(float val1, float val2) {
        return Math.max(val1, val2);
    }

    public static double max(double val1, double val2) {
        return Math.max(val1, val2);
    }

    public static long max(long val1, long val2) {
        return Math.max(val1, val2);
    }

    public static short max(short val1, short val2) {
        return val1 >= val2 ? val1 : val2;
    }

    public static byte max(byte val1, byte val2) {
        return val1 >= val2 ? val1 : val2;
    }

    public static Fraction max(Fraction val1, Fraction val2) {
        return val1.compareTo(val2) > 0 ? val1 : val2;
    }

    @ApiStatus.Experimental
    public static Number max(Number val1, Number val2) {
        try {
            return val1.doubleValue() >= val2.doubleValue() ? (Number)val1 : (Number)val2;
        }
        catch (Exception exception) {
            return val1.hashCode() >= val2.hashCode() ? (Number)val1 : (Number)val2;
        }
    }
}

