/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.gui.interfaces.IDirectoryNavigator;
import fi.dy.masa.malilib.interfaces.IStringDualConsumerFeedback;
import fi.dy.masa.malilib.util.FileNameUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public record FileRenamerDualInput(Path dir, @Nullable IDirectoryNavigator navigator, boolean feedback) implements IStringDualConsumerFeedback
{
    @Override
    public boolean setStrings(String string1, String string2) {
        if (string1.isEmpty() || string2.isEmpty()) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.message.error.invalid_file_or_directory", new Object[0]);
            MaLiLib.debugLog("FileRenamer: Failed to rename file; File is invalid/empty.", new Object[0]);
            return false;
        }
        MaLiLib.LOGGER.error("string1: [{}], string2: [{}]", (Object)string1, (Object)string2);
        Path file = this.dir().resolve(FileNameUtils.generateSafeFileName(string1)).normalize();
        Path newFile = this.dir().resolve(FileNameUtils.generateSafeFileName(string2)).normalize();
        if (file.getFileName().equals(newFile.getFileName())) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.message.error.file_rename.same_name", newFile.toAbsolutePath());
            MaLiLib.debugLog("FileRenamer: Failed to rename file '{}'; Destination is the same.", file.toAbsolutePath());
            return true;
        }
        if (!Files.exists(file, new LinkOption[0])) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.message.error.file_or_directory_does_not_exist", file.toAbsolutePath());
            MaLiLib.debugLog("FileRenamer: Failed to rename file '{}'; Source does not exist.", file.toAbsolutePath());
            return false;
        }
        if (Files.exists(newFile, new LinkOption[0])) {
            if (GuiBase.isShiftDown()) {
                try {
                    Files.delete(newFile);
                }
                catch (Exception err) {
                    InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.error.failed_to_delete_file", file.toAbsolutePath());
                    MaLiLib.debugLog("FileRenamer: Failed to delete file '{}'; {}", file.toAbsolutePath(), err.getLocalizedMessage());
                    return false;
                }
            } else {
                InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.message.error.failed_to_rename_file.exists", file.toAbsolutePath(), newFile.toAbsolutePath());
                MaLiLib.debugLog("FileRenamer: Failed to rename file '{}'; Destination file exists.", file.toAbsolutePath());
                return false;
            }
        }
        try {
            Files.move(file, newFile, new CopyOption[0]);
        }
        catch (Exception err) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.message.error.failed_to_rename_file.exception", file.toAbsolutePath(), newFile.toAbsolutePath(), err.getLocalizedMessage());
            MaLiLib.debugLog("FileRenamer: Exception renaming file '{}'; {}", file.toAbsolutePath(), err.getLocalizedMessage());
            return false;
        }
        if (this.feedback()) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.SUCCESS, "malilib.message.file_or_directory_renamed", file.getFileName(), newFile.getFileName());
        }
        MaLiLib.debugLog("FileRenamer: Renamed file '{}' -> '{}'", file.toAbsolutePath(), newFile.toAbsolutePath());
        return true;
    }
}

