/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.gui.interfaces.IDirectoryNavigator;
import fi.dy.masa.malilib.interfaces.IStringDualConsumerFeedback;
import fi.dy.masa.malilib.util.FileNameUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public record FileCopierDualInput(Path dir, @Nullable IDirectoryNavigator navigator, boolean feedback) implements IStringDualConsumerFeedback
{
    @Override
    public boolean setStrings(String string1, String string2) {
        if (string1.isEmpty() || string2.isEmpty()) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.message.error.invalid_file_or_directory", new Object[0]);
            MaLiLib.LOGGER.warn("FileCopier: Failed to copy file; File is invalid/empty.");
            return false;
        }
        Path file = this.dir().resolve(FileNameUtils.generateSafeFileName(string1)).normalize();
        Path newFile = this.dir().resolve(FileNameUtils.generateSafeFileName(string2)).normalize();
        if (file.getFileName().equals(newFile.getFileName())) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.message.error.failed_to_copy_file.destination_exists", file.toAbsolutePath(), newFile.toAbsolutePath());
            MaLiLib.LOGGER.warn("FileCopier: Failed to copy file '{}'; Destination is the same.", (Object)file.toAbsolutePath());
            return true;
        }
        if (!Files.exists(file, new LinkOption[0])) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.message.error.file_or_directory_does_not_exist", file.toAbsolutePath());
            MaLiLib.LOGGER.warn("FileCopier: Failed to copy file '{}'; Source does not exist.", (Object)file.toAbsolutePath());
            return false;
        }
        if (Files.exists(newFile, new LinkOption[0])) {
            if (GuiBase.isShiftDown()) {
                try {
                    Files.delete(newFile);
                }
                catch (Exception err) {
                    InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.error.failed_to_delete_file", file.toAbsolutePath());
                    MaLiLib.debugLog("FileCopier: Failed to delete file '{}'; {}", file.toAbsolutePath(), err.getLocalizedMessage());
                    return false;
                }
            } else {
                InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.message.error.failed_to_copy_file.destination_exists", file.toAbsolutePath(), newFile.toAbsolutePath());
                MaLiLib.debugLog("FileCopier: Failed to copy file '{}'; Destination file exists.", file.toAbsolutePath());
                return false;
            }
        }
        try {
            Files.copy(file, newFile, new CopyOption[0]);
        }
        catch (Exception err) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.message.error.failed_to_copy_file.exception", file.toAbsolutePath(), newFile.toAbsolutePath(), err.getLocalizedMessage());
            MaLiLib.debugLog("FileCopier: Exception copying file '{}'; {}", file.toAbsolutePath(), err.getLocalizedMessage());
            return false;
        }
        if (this.feedback()) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.SUCCESS, "malilib.message.file_copied", file.getFileName(), newFile.getFileName());
        }
        MaLiLib.debugLog("FileCopier: Copied file '{}' -> '{}'", file.toAbsolutePath(), newFile.toAbsolutePath());
        return true;
    }
}

