/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.test.thread;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.interfaces.IThreadDaemonExecutor;
import fi.dy.masa.malilib.test.thread.TestThreadDaemonDefaultHandler;
import fi.dy.masa.malilib.test.thread.TestThreadTaskDefault;
import java.util.concurrent.atomic.AtomicBoolean;

public class TestThreadDaemonExecutorDefault
implements IThreadDaemonExecutor<TestThreadTaskDefault> {
    private final AtomicBoolean running = new AtomicBoolean(true);

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public void start() {
        this.running.set(true);
    }

    @Override
    public void stop() {
        this.running.set(false);
    }

    @Override
    public void run() {
        while (this.isRunning()) {
            try {
                TestThreadTaskDefault task = TestThreadDaemonDefaultHandler.INSTANCE.getNextTask();
                if (task == null) continue;
                this.processTask(task);
            }
            catch (InterruptedException interrupt) {
                MaLiLib.LOGGER.error("TestThreadDaemonExecutorDefault: Interrupted: {}", (Object)interrupt.getLocalizedMessage());
                this.stop();
                return;
            }
            catch (Exception err) {
                MaLiLib.LOGGER.error("TestThreadDaemonExecutorDefault: Exception: {}", (Object)err.getLocalizedMessage());
                this.stop();
                return;
            }
        }
    }

    @Override
    public void processTask(TestThreadTaskDefault task) throws InterruptedException {
        try {
            task.run();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("TestThreadTaskDefault: completed with error: {}", (Object)err.getLocalizedMessage());
            return;
        }
        MaLiLib.LOGGER.info("TestThreadTaskDefault: completed");
    }
}

