/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.test.render;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.MaLiLibConfigs;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.render.RenderContext;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.test.config.ConfigTestEnum;
import fi.dy.masa.malilib.test.render.TestRenderUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_9801;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

@ApiStatus.Experimental
public class TestRenderWalls
implements AutoCloseable {
    public static final TestRenderWalls INSTANCE = new TestRenderWalls();
    protected boolean renderThrough = false;
    protected boolean useCulling = false;
    protected float glLineWidth = 1.6f;
    private List<class_238> boxes;
    private class_2338 center = null;
    protected class_2338 lastUpdatePos = null;
    private class_243 updateCameraPos = class_243.field_1353;
    private boolean hasData = false;
    private final boolean shouldResort;
    private boolean needsUpdate = true;
    private final int updateDistance = 48;

    public TestRenderWalls() {
        this.shouldResort = false;
        this.boxes = new ArrayList<class_238>();
    }

    public class_243 getUpdatePosition() {
        return this.updateCameraPos;
    }

    public void setUpdatePosition(class_243 cameraPosition) {
        this.updateCameraPos = cameraPosition;
    }

    public boolean needsUpdate(class_1297 cameraEntity, class_310 mc) {
        return this.needsUpdate || this.lastUpdatePos == null || Math.abs(cameraEntity.method_23317() - (double)this.lastUpdatePos.method_10263()) > (double)this.updateDistance || Math.abs(cameraEntity.method_23321() - (double)this.lastUpdatePos.method_10260()) > (double)this.updateDistance || Math.abs(cameraEntity.method_23318() - (double)this.lastUpdatePos.method_10264()) > (double)this.updateDistance;
    }

    public void setNeedsUpdate() {
        this.needsUpdate = true;
    }

    public void update(class_4184 camera, class_1297 entity, class_310 mc) {
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        int radius = MaLiLibConfigs.Test.TEST_CONFIG_INTEGER.getIntegerValue();
        this.glLineWidth = 1.6f;
        class_243 vec = camera.method_71156();
        class_2338 pos = entity.method_24515();
        class_2338 testPos = pos.method_10069(2, 0, 2);
        Pair<class_2338, class_2338> corners = TestRenderUtils.getSpawnChunkCorners(testPos, radius, (class_1937)mc.field_1687);
        this.boxes = TestRenderUtils.calculateBoxes((class_2338)corners.getLeft(), (class_2338)corners.getRight());
        if (!this.boxes.isEmpty()) {
            this.center = testPos;
            this.hasData = true;
        } else {
            this.center = null;
            this.hasData = false;
        }
        this.needsUpdate = false;
        this.setUpdatePosition(vec);
    }

    public void render(class_4184 camera, Matrix4f matrix4f, Matrix4f projMatrix, class_310 mc, class_3695 profiler) {
        profiler.method_15396("render_test_walls");
        if (this.hasData && !this.boxes.isEmpty() && this.center != null) {
            this.renderQuads(camera, mc, profiler);
            this.renderOutlines(camera, mc, profiler);
            this.boxes.clear();
            this.center = null;
            this.hasData = false;
        }
        profiler.method_15407();
    }

    private void renderQuads(class_4184 camera, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null || !this.hasData || this.boxes.isEmpty()) {
            return;
        }
        profiler.method_15396("quads");
        Color4f quadsColor = MaLiLibConfigs.Test.TEST_CONFIG_COLOR.getColor();
        class_243 cameraPos = camera.method_71156();
        RenderContext ctx = new RenderContext(() -> "malilib:TestWalls/quads", MaLiLibPipelines.MINIHUD_SHAPE_OFFSET_NO_CULL);
        class_287 builder = ctx.getBuilder();
        Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
        class_243 updatePos = this.getUpdatePosition();
        matrix4fstack.pushMatrix();
        matrix4fstack.translate((float)(updatePos.field_1352 - cameraPos.field_1352), (float)(updatePos.field_1351 - cameraPos.field_1351), (float)(updatePos.field_1350 - cameraPos.field_1350));
        RenderUtils.drawBlockBoundingBoxSidesBatchedQuads(this.center, cameraPos, quadsColor, 0.001, builder);
        for (class_238 entry : this.boxes) {
            TestRenderUtils.renderWallQuads(entry, cameraPos, quadsColor, builder);
        }
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                if (this.shouldResort) {
                    ctx.upload(meshData, true);
                    ctx.startResorting(meshData, ctx.createVertexSorter(camera));
                } else {
                    ctx.upload(meshData, false);
                }
                ctx.drawPost();
                meshData.close();
            }
            ctx.close();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("TestWalls#renderQuads(): Exception; {}", (Object)err.getMessage());
        }
        matrix4fstack.popMatrix();
        profiler.method_15407();
    }

    private void renderOutlines(class_4184 camera, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        profiler.method_15396("outlines");
        boolean useColor = ConfigTestEnum.TEST_WALLS_USE_COLOR.getBooleanValue();
        Color4f linesColor = useColor ? Color4f.fromColor(MaLiLibConfigs.Test.TEST_CONFIG_COLOR.getColor(), 255.0f) : Color4f.WHITE;
        class_243 cameraPos = camera.method_71156();
        RenderContext ctx = new RenderContext(() -> "malilib:TestWalls/lines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        class_287 builder = ctx.getBuilder();
        Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
        class_243 updatePos = this.getUpdatePosition();
        matrix4fstack.pushMatrix();
        matrix4fstack.translate((float)(updatePos.field_1352 - cameraPos.field_1352), (float)(updatePos.field_1351 - cameraPos.field_1351), (float)(updatePos.field_1350 - cameraPos.field_1350));
        RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines(this.center, cameraPos, linesColor, 0.001, this.glLineWidth, builder);
        for (class_238 entry : this.boxes) {
            TestRenderUtils.renderWallOutlines(entry, 16.0, 16.0, true, cameraPos, linesColor, this.glLineWidth, builder);
        }
        matrix4fstack.popMatrix();
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                ctx.draw(meshData, false, true);
                meshData.close();
            }
            ctx.close();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("TestWalls#renderOutlines(): Exception; {}", (Object)err.getMessage());
        }
        profiler.method_15407();
    }

    public void clear() {
        this.lastUpdatePos = class_2338.field_10980;
        this.hasData = false;
        this.boxes.clear();
    }

    @Override
    public void close() {
        this.clear();
    }
}

