/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.test.render;

import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_310;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class TestRenderUtils {
    protected static Pair<class_2338, class_2338> getSpawnChunkCorners(class_2338 worldSpawn, int chunkRange, class_1937 world) {
        int cx = worldSpawn.method_10263() >> 4;
        int cz = worldSpawn.method_10260() >> 4;
        int minY = TestRenderUtils.getMinY(world);
        int maxY = world != null ? world.method_31600() + 1 : 320;
        class_2338 pos1 = new class_2338(cx - chunkRange << 4, minY, cz - chunkRange << 4);
        class_2338 pos2 = new class_2338((cx + chunkRange << 4) + 15, maxY, (cz + chunkRange << 4) + 15);
        return Pair.of((Object)pos1, (Object)pos2);
    }

    private static int getMinY(class_1937 world) {
        class_310 mc = class_310.method_1551();
        int minY = class_310.method_1588() && world != null && mc.field_1724 != null ? (mc.field_1724.method_24515().method_10264() >= world.method_8615() ? world.method_8615() - 2 : world.method_31607()) : (world != null ? world.method_31607() : -64);
        return minY;
    }

    public static List<class_238> calculateBoxes(class_2338 posStart, class_2338 posEnd) {
        double minZ;
        double maxZ;
        double maxX;
        double minX;
        class_1297 entity = EntityUtils.getCameraEntity();
        int boxMinX = Math.min(posStart.method_10263(), posEnd.method_10263());
        int boxMinZ = Math.min(posStart.method_10260(), posEnd.method_10260());
        int boxMaxX = Math.max(posStart.method_10263(), posEnd.method_10263());
        int boxMaxZ = Math.max(posStart.method_10260(), posEnd.method_10260());
        int centerX = (int)Math.floor(entity.method_23317());
        int centerZ = (int)Math.floor(entity.method_23321());
        int maxDist = (Integer)class_310.method_1551().field_1690.method_42503().method_41753() * 32;
        int rangeMinX = centerX - maxDist;
        int rangeMinZ = centerZ - maxDist;
        int rangeMaxX = centerX + maxDist;
        int rangeMaxZ = centerZ + maxDist;
        double minY = Math.min(posStart.method_10264(), posEnd.method_10264());
        double maxY = Math.max(posStart.method_10264(), posEnd.method_10264()) + 1;
        ArrayList<class_238> boxes = new ArrayList<class_238>();
        if (rangeMinX <= boxMaxX && rangeMaxX >= boxMinX) {
            minX = Math.max(boxMinX, rangeMinX);
            maxX = Math.min(boxMaxX, rangeMaxX) + 1;
            if (rangeMinZ <= boxMinZ && rangeMaxZ >= boxMinZ) {
                minZ = maxZ = (double)boxMinZ;
                boxes.add(new class_238(minX, minY, minZ, maxX, maxY, maxZ));
            }
            if (rangeMinZ <= boxMaxZ && rangeMaxZ >= boxMaxZ) {
                minZ = maxZ = (double)(boxMaxZ + 1);
                boxes.add(new class_238(minX, minY, minZ, maxX, maxY, maxZ));
            }
        }
        if (rangeMinZ <= boxMaxZ && rangeMaxZ >= boxMinZ) {
            minZ = Math.max(boxMinZ, rangeMinZ);
            maxZ = Math.min(boxMaxZ, rangeMaxZ) + 1;
            if (rangeMinX <= boxMinX && rangeMaxX >= boxMinX) {
                minX = maxX = (double)boxMinX;
                boxes.add(new class_238(minX, minY, minZ, maxX, maxY, maxZ));
            }
            if (rangeMinX <= boxMaxX && rangeMaxX >= boxMaxX) {
                minX = maxX = (double)(boxMaxX + 1);
                boxes.add(new class_238(minX, minY, minZ, maxX, maxY, maxZ));
            }
        }
        return boxes;
    }

    public static void renderWallQuads(class_238 box, class_243 cameraPos, Color4f color, class_287 bufferQuads) {
        double cx = cameraPos.field_1352;
        double cy = cameraPos.field_1351;
        double cz = cameraPos.field_1350;
        bufferQuads.method_22912((float)(box.field_1323 - cx), (float)(box.field_1325 - cy), (float)(box.field_1321 - cz)).method_22915(color.r, color.g, color.b, color.a);
        bufferQuads.method_22912((float)(box.field_1323 - cx), (float)(box.field_1322 - cy), (float)(box.field_1321 - cz)).method_22915(color.r, color.g, color.b, color.a);
        bufferQuads.method_22912((float)(box.field_1320 - cx), (float)(box.field_1322 - cy), (float)(box.field_1324 - cz)).method_22915(color.r, color.g, color.b, color.a);
        bufferQuads.method_22912((float)(box.field_1320 - cx), (float)(box.field_1325 - cy), (float)(box.field_1324 - cz)).method_22915(color.r, color.g, color.b, color.a);
    }

    public static void renderWallOutlines(class_238 box, double lineIntervalH, double lineIntervalV, boolean alignLinesToModulo, class_243 cameraPos, Color4f color, float lineWidth, class_287 bufferLines) {
        block4: {
            double lineX;
            double cz;
            double cy;
            double cx;
            block5: {
                double lineZ;
                cx = cameraPos.field_1352;
                cy = cameraPos.field_1351;
                cz = cameraPos.field_1350;
                if (lineIntervalV > 0.0) {
                    double lineY;
                    double d = lineY = alignLinesToModulo ? TestRenderUtils.roundUp(box.field_1322, lineIntervalV) : box.field_1322;
                    while (lineY <= box.field_1325) {
                        bufferLines.method_22912((float)(box.field_1323 - cx), (float)(lineY - cy), (float)(box.field_1321 - cz)).method_22915(color.r, color.g, color.b, 1.0f).method_75298(lineWidth);
                        bufferLines.method_22912((float)(box.field_1320 - cx), (float)(lineY - cy), (float)(box.field_1324 - cz)).method_22915(color.r, color.g, color.b, 1.0f).method_75298(lineWidth);
                        lineY += lineIntervalV;
                    }
                }
                if (!(lineIntervalH > 0.0)) break block4;
                if (box.field_1323 != box.field_1320) break block5;
                double d = lineZ = alignLinesToModulo ? TestRenderUtils.roundUp(box.field_1321, lineIntervalH) : box.field_1321;
                while (lineZ <= box.field_1324) {
                    bufferLines.method_22912((float)(box.field_1323 - cx), (float)(box.field_1322 - cy), (float)(lineZ - cz)).method_22915(color.r, color.g, color.b, 1.0f).method_75298(lineWidth);
                    bufferLines.method_22912((float)(box.field_1323 - cx), (float)(box.field_1325 - cy), (float)(lineZ - cz)).method_22915(color.r, color.g, color.b, 1.0f).method_75298(lineWidth);
                    lineZ += lineIntervalH;
                }
                break block4;
            }
            if (box.field_1321 != box.field_1324) break block4;
            double d = lineX = alignLinesToModulo ? TestRenderUtils.roundUp(box.field_1323, lineIntervalH) : box.field_1323;
            while (lineX <= box.field_1320) {
                bufferLines.method_22912((float)(lineX - cx), (float)(box.field_1322 - cy), (float)(box.field_1321 - cz)).method_22915(color.r, color.g, color.b, 1.0f).method_75298(lineWidth);
                bufferLines.method_22912((float)(lineX - cx), (float)(box.field_1325 - cy), (float)(box.field_1321 - cz)).method_22915(color.r, color.g, color.b, 1.0f).method_75298(lineWidth);
                lineX += lineIntervalH;
            }
        }
    }

    public static double roundUp(double value, double interval) {
        double remainder;
        if (interval == 0.0) {
            return 0.0;
        }
        if (value == 0.0) {
            return interval;
        }
        if (value < 0.0) {
            interval *= -1.0;
        }
        return (remainder = value % interval) == 0.0 ? value : value + interval - remainder;
    }
}

