/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.test.input;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.MaLiLibConfigs;
import fi.dy.masa.malilib.MaLiLibReference;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IHotkeyCallback;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.IKeybindManager;
import fi.dy.masa.malilib.hotkeys.IKeybindProvider;
import fi.dy.masa.malilib.hotkeys.KeyAction;
import fi.dy.masa.malilib.render.InventoryOverlayScreen;
import fi.dy.masa.malilib.test.config.ConfigTestEnum;
import fi.dy.masa.malilib.test.config.TestHotkeys;
import fi.dy.masa.malilib.test.gui.GuiTestFileBrowser;
import fi.dy.masa.malilib.test.gui.GuiTestPosEditor;
import fi.dy.masa.malilib.test.gui.GuiTestTextFields;
import fi.dy.masa.malilib.test.render.TestInventoryOverlayHandler;
import fi.dy.masa.malilib.util.time.TimeTestExample;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class TestInputHandler
implements IKeybindProvider {
    private static final TestInputHandler INSTANCE = new TestInputHandler();
    private final Callbacks callback = new Callbacks();

    private TestInputHandler() {
        this.init();
    }

    public static TestInputHandler getInstance() {
        return INSTANCE;
    }

    public Callbacks getCallback() {
        return this.callback;
    }

    public void init() {
        if (!MaLiLibReference.DEBUG_MODE) {
            return;
        }
        MaLiLibConfigs.Test.TEST_INVENTORY_OVERLAY.getKeybind().setCallback(this.callback);
        TestHotkeys.TEST_INVENTORY_OVERLAY_TOGGLE.getKeybind().setCallback(this.callback);
        TestHotkeys.TEST_GUI_KEYBIND.getKeybind().setCallback(this.callback);
        TestHotkeys.TEST_GUI_EDITOR_KEYBIND.getKeybind().setCallback(this.callback);
        TestHotkeys.TEST_GUI_FILE_BROWSER_KEYBIND.getKeybind().setCallback(this.callback);
        TestHotkeys.TEST_RUN_DATETIME_TEST.getKeybind().setCallback(this.callback);
    }

    @Override
    public void addKeysToMap(IKeybindManager manager) {
        if (!MaLiLibReference.DEBUG_MODE) {
            return;
        }
        for (IHotkey iHotkey : MaLiLibConfigs.Test.HOTKEY_LIST) {
            manager.addKeybindToMap(iHotkey.getKeybind());
        }
        for (IHotkey iHotkey : TestHotkeys.HOTKEY_LIST) {
            manager.addKeybindToMap(iHotkey.getKeybind());
        }
        for (ConfigTestEnum toggle : ConfigTestEnum.values()) {
            manager.addKeybindToMap(toggle.getKeybind());
        }
    }

    @Override
    public void addHotkeys(IKeybindManager manager) {
        if (!MaLiLibReference.DEBUG_MODE) {
            return;
        }
        manager.addHotkeysForCategory("MaLiLib", "malilib.hotkeys.category.test_option_hotkeys", MaLiLibConfigs.Test.HOTKEY_LIST);
        manager.addHotkeysForCategory("MaLiLib", "malilib.hotkeys.category.test_hotkeys", MaLiLibConfigs.Test.HOTKEY_LIST);
        manager.addHotkeysForCategory("MaLiLib", "malilib.hotkeys.category.test_enum_hotkeys", (List<? extends IHotkey>)ImmutableList.copyOf((Object[])ConfigTestEnum.values()));
    }

    public static class Callbacks
    implements IHotkeyCallback {
        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onKeyAction(KeyAction action, IKeybind key) {
            class_310 mc = class_310.method_1551();
            if (mc.field_1724 == null) return false;
            if (!MaLiLibReference.DEBUG_MODE) {
                return false;
            }
            if (key == MaLiLibConfigs.Test.TEST_INVENTORY_OVERLAY.getKeybind()) {
                return true;
            }
            if (key == TestHotkeys.TEST_INVENTORY_OVERLAY_TOGGLE.getKeybind()) {
                if (mc.field_1755 instanceof InventoryOverlayScreen) {
                    mc.method_1507(null);
                    return false;
                }
                if (!MaLiLibConfigs.Test.TEST_INVENTORY_OVERLAY.getBooleanValue()) return false;
                if (!MaLiLibConfigs.Test.TEST_INVENTORY_OVERLAY.getKeybind().isKeybindHeld()) return false;
                TestInventoryOverlayHandler.getInstance().refreshInventoryOverlay(mc, true, true);
                return true;
            }
            if (key == TestHotkeys.TEST_GUI_KEYBIND.getKeybind()) {
                System.out.printf("testGuiKeybind Callback Action: [%s] (Cancel = false)\n", action.getStringValue());
                GuiBase.openGui(new GuiTestTextFields());
                return false;
            }
            if (key == TestHotkeys.TEST_GUI_EDITOR_KEYBIND.getKeybind()) {
                System.out.printf("testGuiEditorKeybind Callback Action: [%s] (Cancel = false)\n", action.getStringValue());
                GuiBase.openGui(new GuiTestPosEditor());
                return false;
            }
            if (key == TestHotkeys.TEST_GUI_FILE_BROWSER_KEYBIND.getKeybind()) {
                System.out.printf("testGuiFileBrowserKeybind Callback Action: [%s] (Cancel = false)\n", action.getStringValue());
                GuiBase.openGui(new GuiTestFileBrowser());
                return false;
            }
            if (key != TestHotkeys.TEST_RUN_DATETIME_TEST.getKeybind()) return false;
            mc.field_1705.method_1743().method_1812(class_2561.method_30163((String)TimeTestExample.runTimeDateTest()));
            mc.field_1705.method_1743().method_1812(class_2561.method_30163((String)TimeTestExample.runDurationTest()));
            return true;
        }
    }
}

