/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.test.gui;

import fi.dy.masa.malilib.MaLiLibReference;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiConfirmAction;
import fi.dy.masa.malilib.gui.GuiListBase;
import fi.dy.masa.malilib.gui.GuiTextDualInputFeedback;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.GuiTextInputFeedback;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.IDirectoryNavigator;
import fi.dy.masa.malilib.gui.interfaces.ISelectionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetDirectoryEntry;
import fi.dy.masa.malilib.gui.widgets.WidgetFileBrowserBase;
import fi.dy.masa.malilib.test.gui.widgets.WidgetTestBrowser;
import fi.dy.masa.malilib.util.FileCopier;
import fi.dy.masa.malilib.util.FileDeleter;
import fi.dy.masa.malilib.util.FileNameUtils;
import fi.dy.masa.malilib.util.FileRenamerDualInput;
import fi.dy.masa.malilib.util.StringUtils;
import java.nio.file.Path;
import javax.annotation.Nullable;

public class GuiTestFileBrowser
extends GuiListBase<WidgetFileBrowserBase.DirectoryEntry, WidgetDirectoryEntry, WidgetTestBrowser>
implements ISelectionListener<WidgetFileBrowserBase.DirectoryEntry> {
    protected GuiTextFieldGeneric textField;
    protected String lastText;

    public GuiTestFileBrowser() {
        super(12, 24);
        this.title = StringUtils.translate("malilib.gui.title.test_file_browser", new Object[0]);
        this.textField = new GuiTextFieldGeneric(10, 32, 160, 20, this.font);
        this.textField.setMaxLengthWrapper(256);
        this.textField.setFocusedWrapper(true);
        this.lastText = "";
    }

    @Override
    protected WidgetTestBrowser createListWidget(int listX, int listY) {
        return new WidgetTestBrowser(listX, listY, 100, 100, this, this.getSelectionListener());
    }

    public String getBrowserContext() {
        return "test_file_browser";
    }

    public Path getDefaultDirectory() {
        return MaLiLibReference.GAME_DIR.resolve("logs");
    }

    @Override
    @Nullable
    protected ISelectionListener<WidgetFileBrowserBase.DirectoryEntry> getSelectionListener() {
        return this;
    }

    @Override
    protected int getBrowserWidth() {
        return this.getScreenWidth() - 20;
    }

    @Override
    protected int getBrowserHeight() {
        return this.getScreenHeight() - 70;
    }

    @Override
    public void initGui() {
        super.initGui();
        int x = 10;
        int y = this.getScreenHeight() - 26;
        x += this.createButton(x, y, ButtonType.COPY);
        x += this.createButton(x, y, ButtonType.RENAME);
        x += this.createButton(x, y, ButtonType.DELETE);
    }

    protected int createButton(int x, int y, ButtonType type) {
        ButtonGeneric button = new ButtonGeneric(x, y, -1, 20, type.getDisplayName(), new String[0]);
        this.addButton(button, this.createActionListener(type));
        return button.getWidth() + 2;
    }

    protected ButtonListener createActionListener(ButtonType type) {
        return new ButtonListener(type, this);
    }

    protected void setTextFieldText(String text) {
        this.lastText = text;
        this.textField.method_1852(text);
    }

    protected String getTextFieldText() {
        return this.textField.method_1882();
    }

    @Override
    public void onSelectionChange(@Nullable WidgetFileBrowserBase.DirectoryEntry entry) {
        if (entry != null && entry.type() != WidgetFileBrowserBase.DirectoryEntryType.DIRECTORY && entry.type() != WidgetFileBrowserBase.DirectoryEntryType.INVALID) {
            this.setTextFieldText(FileNameUtils.getFileNameWithoutExtension(entry.name()));
        }
    }

    protected static enum ButtonType {
        COPY("malilib.gui.button.copy"),
        RENAME("malilib.gui.button.rename"),
        DELETE("malilib.gui.button.delete");

        private final String labelKey;

        private ButtonType(String labelKey) {
            this.labelKey = labelKey;
        }

        public String getDisplayName() {
            return StringUtils.translate(this.labelKey, new Object[0]);
        }
    }

    protected record ButtonListener(ButtonType type, GuiTestFileBrowser gui) implements IButtonActionListener
    {
        @Override
        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            WidgetFileBrowserBase.DirectoryEntry entry = (WidgetFileBrowserBase.DirectoryEntry)((WidgetTestBrowser)this.gui.getListWidget()).getLastSelectedEntry();
            if (entry == null) {
                if (((WidgetTestBrowser)this.gui.getListWidget()).getCurrentDirectory() != null) {
                    Path target = ((WidgetTestBrowser)this.gui.getListWidget()).getCurrentDirectory();
                    FileDeleter deleter = new FileDeleter(target, (IDirectoryNavigator)((Object)this.gui.getListWidget()), true);
                    GuiBase.openGui(new GuiConfirmAction(180, "malilib.gui.title.delete_confirm", deleter, this.gui, "malilib.message.delete_confirm", target.getFileName().toString()));
                }
            } else {
                if (entry.type() == WidgetFileBrowserBase.DirectoryEntryType.INVALID) {
                    return;
                }
                Path target = entry.getFullPath();
                if (this.type == ButtonType.COPY) {
                    FileCopier copier = new FileCopier(target, (IDirectoryNavigator)((Object)this.gui.getListWidget()), true);
                    GuiBase.openGui(new GuiTextInputFeedback(256, "malilib.gui.title.copy_file", entry.name(), this.gui, copier));
                } else if (this.type == ButtonType.RENAME) {
                    FileRenamerDualInput renamer = new FileRenamerDualInput(target.getParent(), (IDirectoryNavigator)((Object)this.gui.getListWidget()), true);
                    GuiBase.openGui(new GuiTextDualInputFeedback(256, "malilib.gui.title.rename_file_or_directory", target.getFileName().toString(), entry.name(), this.gui, renamer));
                } else if (this.type == ButtonType.DELETE) {
                    FileDeleter deleter = new FileDeleter(target, (IDirectoryNavigator)((Object)this.gui.getListWidget()), true);
                    GuiBase.openGui(new GuiConfirmAction(180, "malilib.gui.title.delete_confirm", deleter, this.gui, "malilib.message.delete_confirm", target.getFileName().toString()));
                }
            }
        }
    }
}

