/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.render;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.MaLiLibReference;
import fi.dy.masa.malilib.mixin.entity.IMixinMerchantEntity;
import fi.dy.masa.malilib.render.GuiContext;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.render.InventoryOverlayContext;
import fi.dy.masa.malilib.render.InventoryOverlayType;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.data.DataBlockUtils;
import fi.dy.masa.malilib.util.data.DataEntityUtils;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.game.BlockUtils;
import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.class_11187;
import net.minecraft.class_11573;
import net.minecraft.class_12116;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1304;
import net.minecraft.class_1493;
import net.minecraft.class_1496;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1730;
import net.minecraft.class_1799;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2480;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3988;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_8887;
import org.jetbrains.annotations.NotNull;

public class InventoryOverlayScreen
extends class_437
implements class_4068 {
    String modId;
    private InventoryOverlayContext previewData;
    private final boolean shulkerBGColors;
    private final boolean villagerBGColors;
    private int ticks;

    public InventoryOverlayScreen(String modId, @Nullable InventoryOverlayContext previewData) {
        this(modId, previewData, true, false);
    }

    public InventoryOverlayScreen(String modId, @Nullable InventoryOverlayContext previewData, boolean shulkerBGColors) {
        this(modId, previewData, shulkerBGColors, false);
    }

    public InventoryOverlayScreen(String modId, @Nullable InventoryOverlayContext previewData, boolean shulkerBGColors, boolean villagerBGColors) {
        super(StringUtils.translateAsText("malilib.gui.title.inventory_overlay", modId));
        this.modId = modId;
        this.previewData = previewData;
        this.shulkerBGColors = shulkerBGColors;
        this.villagerBGColors = villagerBGColors;
    }

    public void method_25420(@NotNull class_332 context, int mouseX, int mouseY, float deltaTicks) {
    }

    public void method_25394(@NotNull class_332 drawContext, int mouseX, int mouseY, float delta) {
        if (this.previewData != null) {
            this.renderData(GuiContext.fromGuiGraphics(drawContext), mouseX, mouseY, delta);
        }
    }

    private void renderData(GuiContext ctx, int mouseX, int mouseY, float delta) {
        ++this.ticks;
        class_310 mc = class_310.method_1551();
        class_1937 world = WorldUtils.getBestWorld(mc);
        if (this.previewData != null && world != null) {
            class_2248 class_22482;
            class_2586 class_25862;
            int xCenter = GuiUtils.getScaledWindowWidth() / 2;
            int yCenter = GuiUtils.getScaledWindowHeight() / 2;
            int x = xCenter - 26;
            int y = yCenter - 92;
            int startSlot = 0;
            int totalSlots = this.previewData.inv() == null ? 0 : this.previewData.inv().method_5439();
            ArrayList<class_1799> armourItems = new ArrayList<class_1799>();
            if (this.previewData.entity() instanceof class_1496) {
                if (this.previewData.inv() == null) {
                    MaLiLib.LOGGER.warn("renderData(): Horse inv() = null");
                    return;
                }
                armourItems.add(this.previewData.entity().method_6118(class_1304.field_48824));
                armourItems.add(this.previewData.inv().method_5438(0));
                startSlot = 1;
                totalSlots = this.previewData.inv().method_5439() - 1;
            } else if (this.previewData.entity() instanceof class_12116) {
                armourItems.add(this.previewData.entity().method_6118(class_1304.field_48824));
                armourItems.add(this.previewData.entity().method_6118(class_1304.field_55946));
            } else if (this.previewData.entity() instanceof class_1493 || this.previewData.entity() instanceof class_11187) {
                armourItems.add(this.previewData.entity().method_6118(class_1304.field_48824));
            } else if (this.previewData.entity() instanceof class_11573) {
                armourItems.add(this.previewData.entity().method_6118(class_1304.field_55946));
            }
            InventoryOverlayType type = this.previewData.entity() instanceof class_1646 ? InventoryOverlayType.VILLAGER : InventoryOverlay.getBestInventoryType(this.previewData, this.previewData.inv(), this.previewData.data() != null ? this.previewData.data() : new CompoundData());
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp(type, totalSlots);
            int rows = (int)Math.ceil((double)totalSlots / (double)props.slotsPerRow);
            HashSet<Integer> lockedSlots = new HashSet();
            int xInv = xCenter - props.width / 2;
            int yInv = yCenter - props.height - 6;
            if (rows > 6) {
                yInv -= (rows - 6) * 18;
                y -= (rows - 6) * 18;
            }
            if (MaLiLibReference.DEBUG_MODE) {
                MaLiLib.LOGGER.warn("renderData():0: type [{}], previewData.type [{}], previewData.inv [{}], previewData.be [{}], previewData.ent [{}], previewData.data [{}]", (Object)type.toString(), (Object)this.previewData.type().toString(), (Object)(this.previewData.inv() != null ? 1 : 0), (Object)(this.previewData.be() != null ? 1 : 0), (Object)(this.previewData.entity() != null ? 1 : 0), this.previewData.data() != null ? this.previewData.data().getString("id") : null);
                MaLiLib.LOGGER.error("0: -> inv.type [{}] // data.type [{}]", (Object)(this.previewData.inv() != null ? InventoryOverlay.getInventoryType(this.previewData.inv()) : null), this.previewData.data() != null ? InventoryOverlay.getInventoryType(this.previewData.data()) : null);
                MaLiLib.LOGGER.error("1: -> inv.size [{}] // inv.isEmpty [{}]", (Object)(this.previewData.inv() != null ? this.previewData.inv().method_5439() : -1), (Object)(this.previewData.inv() != null ? (Comparable<Boolean>)Boolean.valueOf(this.previewData.inv().method_5442()) : (Comparable<Boolean>)Integer.valueOf(-1)));
                MaLiLib.LOGGER.error("2: -> total slots [{}] // rows [{}] // startSlot [{}]", (Object)totalSlots, (Object)rows, (Object)startSlot);
            }
            if (this.previewData.entity() != null) {
                x = xCenter - 55;
                xInv = xCenter + 2;
                yInv = Math.min(yInv, yCenter - 92);
            }
            if ((class_25862 = this.previewData.be()) instanceof class_8887) {
                class_8887 cbe = (class_8887)class_25862;
                lockedSlots = BlockUtils.getDisabledSlots(cbe);
            } else if (this.previewData.data() != null && this.previewData.data().contains("disabled_slots", 11)) {
                lockedSlots = DataBlockUtils.getDisabledSlots(this.previewData.data());
            }
            if (!armourItems.isEmpty()) {
                class_1277 horseInv = new class_1277(armourItems.toArray(new class_1799[0]));
                InventoryOverlay.renderInventoryBackground(ctx, type, xInv, yInv, 1, horseInv.method_5439());
                InventoryOverlay.renderInventoryBackgroundSlots(ctx, type, (class_1263)horseInv, xInv + props.slotOffsetX, yInv + props.slotOffsetY);
                InventoryOverlay.renderInventoryStacks(ctx, type, (class_1263)horseInv, xInv + props.slotOffsetX, yInv + props.slotOffsetY, 1, 0, horseInv.method_5439(), mouseX, mouseY);
                xInv += 36;
            }
            int color = -1;
            if (this.previewData.be() != null && (class_22482 = this.previewData.be().method_11010().method_26204()) instanceof class_2480) {
                class_2480 sbb = (class_2480)class_22482;
                color = RenderUtils.setShulkerboxBackgroundTintColor(sbb, this.shulkerBGColors);
            }
            if (totalSlots > 0 && this.previewData.inv() != null) {
                InventoryOverlay.renderInventoryBackground(ctx, type, xInv, yInv, props.slotsPerRow, totalSlots, color);
                if (type == InventoryOverlayType.BREWING_STAND) {
                    InventoryOverlay.renderBrewerBackgroundSlots(ctx, this.previewData.inv(), xInv, yInv);
                }
                InventoryOverlay.renderInventoryStacks(ctx, type, this.previewData.inv(), xInv + props.slotOffsetX, yInv + props.slotOffsetY, props.slotsPerRow, startSlot, totalSlots, lockedSlots, mouseX, mouseY);
            }
            if ((this.previewData.type() == InventoryOverlayType.PLAYER || type == InventoryOverlayType.ENDER_CHEST) && this.previewData.data() != null && this.previewData.data().contains("EnderItems", 9)) {
                enderItems = InventoryUtils.getPlayerEnderItemsFromData(this.previewData.data(), world.method_30349());
                if (enderItems == null) {
                    enderItems = new class_1730();
                }
                if (MaLiLibReference.DEBUG_MODE) {
                    MaLiLib.LOGGER.error("renderData(): enderItems [{}]", (Object)enderItems.method_5439());
                }
                yInv = yCenter + 6;
                InventoryOverlay.renderInventoryBackground(ctx, InventoryOverlayType.GENERIC, xInv, yInv, 9, 27, color);
                InventoryOverlay.renderInventoryStacks(ctx, InventoryOverlayType.GENERIC, (class_1263)enderItems, xInv + props.slotOffsetX, yInv + props.slotOffsetY, 9, 0, 27, mouseX, mouseY);
            } else {
                enderItems = this.previewData.entity();
                if (enderItems instanceof class_1657) {
                    class_1657 player = (class_1657)enderItems;
                    yInv = yCenter + 6;
                    InventoryOverlay.renderInventoryBackground(ctx, InventoryOverlayType.GENERIC, xInv, yInv, 9, 27, color);
                    InventoryOverlay.renderInventoryStacks(ctx, InventoryOverlayType.GENERIC, (class_1263)player.method_7274(), xInv + props.slotOffsetX, yInv + props.slotOffsetY, 9, 0, 27, mouseX, mouseY);
                }
            }
            if (type == InventoryOverlayType.VILLAGER && this.previewData.data() != null && this.previewData.data().contains("Offers", 10)) {
                offers = InventoryUtils.getSellingItemsFromData(this.previewData.data(), world.method_30349());
                class_1263 tradeOffers = InventoryUtils.getAsInventory(offers);
                if (tradeOffers != null && !tradeOffers.method_5442()) {
                    int xInvOffset = xCenter - 55 - props.width / 2;
                    int offerSlotCount = 9;
                    yInv = yCenter + 6;
                    if (offers.size() > 9) {
                        offerSlotCount = 18;
                    }
                    color = RenderUtils.setVillagerBackgroundTintColor(DataEntityUtils.getVillagerData(this.previewData.data()), this.villagerBGColors);
                    InventoryOverlay.renderInventoryBackground(ctx, InventoryOverlayType.GENERIC, xInvOffset - props.slotOffsetX, yInv, 9, offerSlotCount, color);
                    InventoryOverlay.renderInventoryStacks(ctx, InventoryOverlayType.GENERIC, tradeOffers, xInvOffset, yInv + props.slotOffsetY, 9, 0, offerSlotCount, mouseX, mouseY);
                }
            } else {
                class_3988 merchant;
                class_1916 trades;
                class_2371<class_1799> offers;
                class_1263 tradeOffers;
                offers = this.previewData.entity();
                if (offers instanceof class_3988 && (tradeOffers = InventoryUtils.getAsInventory(offers = (trades = ((IMixinMerchantEntity)(merchant = (class_3988)offers)).malilib_offers()) != null ? InventoryUtils.getSellingItems(trades) : class_2371.method_10211())) != null && !tradeOffers.method_5442()) {
                    int xInvOffset = xCenter - 55 - props.width / 2;
                    int offerSlotCount = 9;
                    yInv = yCenter + 6;
                    if (offers.size() > 9) {
                        offerSlotCount = 18;
                    }
                    if (merchant instanceof class_1646) {
                        class_1646 villager = (class_1646)merchant;
                        color = RenderUtils.setVillagerBackgroundTintColor(villager.method_7231(), this.villagerBGColors);
                    }
                    InventoryOverlay.renderInventoryBackground(ctx, InventoryOverlayType.GENERIC, xInvOffset - props.slotOffsetX, yInv, 9, offerSlotCount, color);
                    InventoryOverlay.renderInventoryStacks(ctx, InventoryOverlayType.GENERIC, tradeOffers, xInvOffset, yInv + props.slotOffsetY, 9, 0, offerSlotCount, mouseX, mouseY);
                }
            }
            if (this.previewData.entity() != null) {
                InventoryOverlay.renderEquipmentOverlayBackground(ctx, x, y, this.previewData.entity());
                InventoryOverlay.renderEquipmentStacks(ctx, this.previewData.entity(), x, y, mouseX, mouseY);
            }
            if (this.ticks % 4 == 0) {
                this.previewData = this.previewData.refresher().onContextRefresh(this.previewData, world);
            }
        }
    }

    public boolean method_25421() {
        return false;
    }
}

