/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.network;

import fi.dy.masa.malilib.network.IPluginClientPlayHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_634;
import net.minecraft.class_8710;

public class PacketSplitter {
    public static final int MAX_TOTAL_PER_PACKET_S2C = 0x100000;
    public static final int MAX_PAYLOAD_PER_PACKET_S2C = 1048571;
    public static final int MAX_TOTAL_PER_PACKET_C2S = Short.MAX_VALUE;
    public static final int MAX_PAYLOAD_PER_PACKET_C2S = 32762;
    public static final int DEFAULT_MAX_RECEIVE_SIZE_C2S = 0x1000000;
    public static final int DEFAULT_MAX_RECEIVE_SIZE_S2C = 0x4000000;
    private static final Map<Long, ReadingSession> READING_SESSIONS = new HashMap<Long, ReadingSession>();

    public static <T extends class_8710> boolean send(IPluginClientPlayHandler<T> handler, class_2540 packet, class_634 networkHandler) {
        return PacketSplitter.send(handler, packet, 32762, networkHandler);
    }

    private static <T extends class_8710> boolean send(IPluginClientPlayHandler<T> handler, class_2540 packet, int payloadLimit, class_634 networkHandler) {
        int len = packet.writerIndex();
        packet.method_52933();
        for (int offset = 0; offset < len; offset += payloadLimit) {
            int thisLen = Math.min(len - offset, payloadLimit);
            class_2540 buf = new class_2540(Unpooled.buffer((int)thisLen));
            buf.method_52935();
            if (offset == 0) {
                buf.method_10804(len);
            }
            buf.method_52976((ByteBuf)packet, thisLen);
            handler.encodeWithSplitter(buf, networkHandler);
        }
        packet.release();
        return true;
    }

    public static <T extends class_8710> class_2540 receive(IPluginClientPlayHandler<T> handler, long key, class_2540 buf) {
        return PacketSplitter.receive(handler.getPayloadChannel(), key, buf, 0x4000000);
    }

    @Nullable
    private static class_2540 receive(class_2960 channel, long key, class_2540 buf, int maxLength) {
        return READING_SESSIONS.computeIfAbsent(key, ReadingSession::new).receive(buf, maxLength);
    }

    private static class ReadingSession {
        private final long key;
        private int expectedSize = -1;
        private class_2540 received;

        private ReadingSession(long key) {
            this.key = key;
        }

        @Nullable
        private class_2540 receive(class_2540 data, int maxLength) {
            data.method_52988(0);
            if (this.expectedSize < 0) {
                this.expectedSize = data.method_10816();
                if (this.expectedSize > maxLength) {
                    throw new IllegalArgumentException("Payload too large");
                }
                this.received = new class_2540(Unpooled.buffer((int)this.expectedSize));
            }
            if (this.received == null) {
                throw new RuntimeException("Receive Buffer is empty");
            }
            this.received.method_52975(data.copy());
            if (this.received.writerIndex() >= this.expectedSize) {
                READING_SESSIONS.remove(this.key);
                return this.received;
            }
            return null;
        }
    }
}

