/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.wrappers;

import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.interfaces.ITextFieldListener;
import fi.dy.masa.malilib.gui.wrappers.TextFieldType;
import fi.dy.masa.malilib.render.GuiContext;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import org.jspecify.annotations.NonNull;

public class TextFieldWrapper<T extends GuiTextFieldGeneric> {
    private final T textField;
    private final ITextFieldListener<T> listener;
    private final TextFieldType type;

    public TextFieldWrapper(T textField, ITextFieldListener<T> listener) {
        this(textField, listener, TextFieldType.STRING);
    }

    public TextFieldWrapper(T textField, ITextFieldListener<T> listener, TextFieldType type) {
        this.textField = textField;
        this.listener = listener;
        this.type = type;
        if (type.getMaxLength() > 0 && type.getMaxLength() < textField.method_1861()) {
            textField.method_1880(type.getMaxLength());
        } else if (textField.method_1861() > 0 && textField.method_1861() < type.getMaxLength()) {
            this.type.setMaxLength(textField.method_1861());
        }
    }

    public T textField() {
        return this.textField;
    }

    public ITextFieldListener<T> listener() {
        return this.listener;
    }

    public TextFieldType type() {
        return this.type;
    }

    public boolean isFocused() {
        return this.textField.method_25370();
    }

    public void setFocused(boolean isFocused) {
        this.textField.method_25365(isFocused);
    }

    public void onGuiClosed() {
        if (this.listener != null) {
            this.listener.onGuiClosed(this.textField);
        }
    }

    public void draw(GuiContext ctx, int mouseX, int mouseY) {
        this.textField.method_25394(ctx.getGuiGraphics(), mouseX, mouseY, 0.0f);
    }

    public boolean mouseClicked(class_11909 click, boolean doubleClick) {
        if (((GuiTextFieldGeneric)((Object)this.textField)).method_25402(click, doubleClick)) {
            return true;
        }
        if (!this.textField.method_25405(click.comp_4798(), click.comp_4799())) {
            this.textField.method_25365(false);
        }
        return false;
    }

    public boolean onKeyTyped(class_11908 input) {
        String textPre = this.textField.method_1882();
        if (this.textField.method_25370() && this.textField.method_25404(input)) {
            if (((GuiTextFieldGeneric)((Object)this.textField())).hasTooltip() && input.comp_4795() == 259 || !((GuiTextFieldGeneric)((Object)this.textField)).getValueWrapper().equals(textPre)) {
                this.validateType();
            }
            if (!(this.listener == null || input.comp_4795() != 257 && input.comp_4795() != 258 && this.textField.method_1882().equals(textPre))) {
                this.listener.onTextChange(this.textField);
            }
            return true;
        }
        return false;
    }

    public boolean onCharTyped(class_11905 input) {
        String textPre = this.textField.method_1882();
        if (this.textField.method_25370() && this.textField.method_25400(input)) {
            if (!this.textField.method_1882().equals(textPre)) {
                this.validateType();
            }
            if (this.listener != null && !this.textField.method_1882().equals(textPre)) {
                this.listener.onTextChange(this.textField);
            }
            return true;
        }
        return false;
    }

    public boolean onMouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.textField.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        if (!this.textField.method_25405(mouseX, mouseY)) {
            this.textField.method_25365(false);
        }
        return false;
    }

    public boolean onMouseDragged(@NonNull class_11909 click, double dragXAmount, double dragYAmount) {
        if (this.textField.method_25403(click, dragXAmount, dragYAmount)) {
            return true;
        }
        if (!this.textField.method_25405(click.comp_4798(), click.comp_4799())) {
            this.textField.method_25365(false);
        }
        return false;
    }

    public void validateType() {
        switch (this.type) {
            case DOUBLE: {
                try {
                    Double.parseDouble(this.textField.method_1882());
                    ((GuiTextFieldGeneric)((Object)this.textField)).clearHoverTooltip();
                }
                catch (Exception e) {
                    ((GuiTextFieldGeneric)((Object)this.textField)).setHoverTooltip("malilib.gui.text_field.invalid_double", new Object[0]);
                }
                break;
            }
            case FLOAT: {
                try {
                    Float.parseFloat(this.textField.method_1882());
                    ((GuiTextFieldGeneric)((Object)this.textField)).clearHoverTooltip();
                }
                catch (Exception e) {
                    ((GuiTextFieldGeneric)((Object)this.textField)).setHoverTooltip("malilib.gui.text_field.invalid_float", new Object[0]);
                }
                break;
            }
            case INTEGER: {
                try {
                    Integer.parseInt(this.textField.method_1882());
                    ((GuiTextFieldGeneric)((Object)this.textField)).clearHoverTooltip();
                }
                catch (Exception e) {
                    ((GuiTextFieldGeneric)((Object)this.textField)).setHoverTooltip("malilib.gui.text_field.invalid_integer", new Object[0]);
                }
                break;
            }
            default: {
                if (this.textField.method_1882().length() > this.type.getMaxLength()) {
                    ((GuiTextFieldGeneric)((Object)this.textField)).setHoverTooltip("malilib.gui.text_field.invalid_length", this.type.getMaxLength());
                    break;
                }
                ((GuiTextFieldGeneric)((Object)this.textField)).clearHoverTooltip();
            }
        }
    }
}

