/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiDialogBase;
import fi.dy.masa.malilib.gui.GuiTextFieldMultiLine;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.render.GuiContext;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.MathUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import javax.annotation.Nullable;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_437;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NonNull;

@ApiStatus.Experimental
public abstract class GuiTextInputMultiLineBase
extends GuiDialogBase {
    protected final GuiTextFieldMultiLine textField;
    protected final String originalText;
    protected final int displayLines;
    protected final int buttonHeight;
    protected final int totalLines;
    protected final int totalHeight;
    protected final int totalWidth;

    public GuiTextInputMultiLineBase(int maxTextLength, int displayLines, int maxLines, String titleKey, String defaultText, @Nullable class_437 parent) {
        this(maxTextLength, displayLines, maxLines, titleKey, defaultText, parent, Color4f.WHITE, Color4f.WHITE, true, true, true);
    }

    public GuiTextInputMultiLineBase(int maxTextLength, int displayLines, int maxLines, String titleKey, String defaultText, @Nullable class_437 parent, Color4f textColor, boolean withShadow) {
        this(maxTextLength, displayLines, maxLines, titleKey, defaultText, parent, textColor, Color4f.WHITE, withShadow, true, true);
    }

    public GuiTextInputMultiLineBase(int maxTextLength, int displayLines, int maxLines, String titleKey, String defaultText, @Nullable class_437 parent, Color4f textColor, Color4f cursorColor, boolean withShadow, boolean withBackground, boolean withDecorations) {
        this.setParent(parent);
        this.title = StringUtils.translate(titleKey, new Object[0]);
        this.useTitleHierarchy = false;
        this.originalText = defaultText;
        this.displayLines = MathUtils.clamp(displayLines, 1, this.dialogHeight);
        this.totalLines = MathUtils.clamp(maxLines, 1, Integer.MAX_VALUE);
        this.buttonHeight = 20;
        this.totalHeight = displayLines * 20;
        this.totalWidth = MathUtils.min(maxTextLength * 10, 240);
        boolean hasScrollbar = displayLines < maxLines;
        this.setWidthAndHeight(this.totalWidth + 20, this.totalHeight + this.buttonHeight + 40);
        this.centerOnScreen();
        GuiTextFieldMultiLine.Builder builder = new GuiTextFieldMultiLine.Builder();
        this.textField = builder.setX(this.dialogLeft + 12).setY(this.dialogTop + this.buttonHeight).setWidth(this.totalWidth).setHeight(this.totalHeight).setTextColor(textColor).setCursorColor(cursorColor).setBackground(withBackground).setShadow(withShadow).setDecorations(withDecorations).setScrollbar(hasScrollbar).build(this.font, defaultText);
        this.textField.method_25365(true);
        this.textField.method_71506(maxLines);
        this.textField.method_44400(this.originalText);
    }

    @Override
    public void initGui() {
        int x = this.dialogLeft + 10;
        int y = this.dialogTop + this.totalHeight + this.buttonHeight + 10;
        x += this.createButton(x, y, ButtonType.OK) + 2;
        x += this.createButton(x, y, ButtonType.RESET) + 2;
        this.createButton(x, y, ButtonType.CANCEL);
    }

    protected int createButton(int x, int y, ButtonType type) {
        ButtonGeneric button = new ButtonGeneric(x, y, -1, this.buttonHeight, type.getDisplayName(), new String[0]);
        button.setWidth(MathUtils.max(40, button.getWidth()));
        return this.addButton(button, this.createActionListener(type)).getWidth();
    }

    @Override
    public boolean method_25421() {
        return this.getParent() != null && this.getParent().method_25421();
    }

    @Override
    public void drawContents(GuiContext ctx, int mouseX, int mouseY, float partialTicks) {
        if (this.getParent() != null) {
            this.getParent().method_25394(ctx.getGuiGraphics(), mouseX, mouseY, partialTicks);
        }
        ctx.method_51448().pushMatrix();
        ctx.method_51448().translate(0.0f, 0.0f);
        RenderUtils.drawOutlinedBox(ctx, this.dialogLeft, this.dialogTop, this.dialogWidth, this.dialogHeight, -536870912, -6710887);
        this.drawStringWithShadow(ctx, this.getTitleString(), this.dialogLeft + 10, this.dialogTop + 4, -1);
        this.textField.method_25394(ctx.getGuiGraphics(), mouseX, mouseY, partialTicks);
        this.drawButtons(ctx, mouseX, mouseY, partialTicks);
        ctx.method_51448().popMatrix();
    }

    @Override
    public boolean onKeyTyped(class_11908 input) {
        if (input.comp_4795() == 256) {
            GuiBase.openGui(this.getParent());
            return true;
        }
        if (this.textField.method_25370()) {
            return this.textField.method_25404(input);
        }
        return super.onKeyTyped(input);
    }

    @Override
    public boolean onCharTyped(class_11905 input) {
        if (this.textField.method_25370()) {
            return this.textField.method_25400(input);
        }
        return super.onCharTyped(input);
    }

    @Override
    public boolean onMouseClicked(class_11909 click, boolean doubleClick) {
        if (this.textField.method_25402(click, doubleClick)) {
            return true;
        }
        return super.onMouseClicked(click, doubleClick);
    }

    @Override
    public boolean onMouseDragged(@NonNull class_11909 click, double dragXAmount, double dragYAmount) {
        if (this.textField.method_25403(click, dragXAmount, dragYAmount)) {
            return true;
        }
        return super.onMouseDragged(click, dragXAmount, dragYAmount);
    }

    @Override
    public boolean onMouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.textField.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        return super.onMouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    protected ButtonListener createActionListener(ButtonType type) {
        return new ButtonListener(type, this);
    }

    protected abstract boolean applyValue(String var1);

    protected static enum ButtonType {
        OK("malilib.gui.button.ok"),
        CANCEL("malilib.gui.button.cancel"),
        RESET("malilib.gui.button.reset");

        private final String labelKey;

        private ButtonType(String labelKey) {
            this.labelKey = labelKey;
        }

        public String getDisplayName() {
            return StringUtils.translate(this.labelKey, new Object[0]);
        }
    }

    protected static class ButtonListener
    implements IButtonActionListener {
        private final GuiTextInputMultiLineBase gui;
        private final ButtonType type;

        public ButtonListener(ButtonType type, GuiTextInputMultiLineBase gui) {
            this.type = type;
            this.gui = gui;
        }

        @Override
        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            if (this.type == ButtonType.OK) {
                if (this.gui.applyValue(this.gui.textField.method_44405())) {
                    GuiBase.openGui(this.gui.getParent());
                }
            } else if (this.type == ButtonType.CANCEL) {
                GuiBase.openGui(this.gui.getParent());
            } else if (this.type == ButtonType.RESET) {
                this.gui.textField.method_44400(this.gui.originalText);
                this.gui.textField.method_25365(true);
            }
        }
    }
}

