/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiDialogBase;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.render.GuiContext;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.MathUtils;
import fi.dy.masa.malilib.util.StringUtils;
import javax.annotation.Nullable;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_437;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NonNull;

@ApiStatus.Experimental
public abstract class GuiTextDualInputBase
extends GuiDialogBase {
    protected final GuiTextFieldGeneric textField1;
    protected final GuiTextFieldGeneric textField2;
    protected final String originalText1;
    protected final String originalText2;
    protected int selectedBox;
    protected final int text1Height;
    protected final int text2Height;
    protected final int buttonHeight;
    protected final int totalHeight;
    protected final int totalWidth;

    public GuiTextDualInputBase(int maxTextLength, String titleKey, String defaultText1, String defaultText2, @Nullable class_437 parent) {
        this.setParent(parent);
        this.title = StringUtils.translate(titleKey, new Object[0]);
        this.useTitleHierarchy = false;
        this.originalText1 = defaultText1;
        this.originalText2 = defaultText2;
        this.text1Height = 20;
        this.text2Height = 20;
        this.buttonHeight = 20;
        this.totalHeight = this.text1Height + this.text2Height + 2;
        this.totalWidth = MathUtils.min(maxTextLength * 10, 240);
        this.setWidthAndHeight(this.totalWidth + 20, this.totalHeight + this.buttonHeight + 40);
        this.centerOnScreen();
        this.textField1 = new GuiTextFieldGeneric(this.dialogLeft + 12, this.dialogTop + this.buttonHeight, this.totalWidth, this.text1Height, this.font);
        this.textField1.method_1880(maxTextLength);
        this.textField1.method_1852(this.originalText1);
        this.textField2 = new GuiTextFieldGeneric(this.dialogLeft + 12, this.dialogTop + this.text1Height + this.buttonHeight + 2, this.totalWidth, this.text2Height, this.font);
        this.textField2.method_1880(maxTextLength);
        this.textField2.method_1852(this.originalText2);
        this.textField1.method_25365(true);
        this.selectedBox = 1;
    }

    @Override
    public void initGui() {
        int x = this.dialogLeft + 10;
        int y = this.dialogTop + this.totalHeight + this.buttonHeight + 10;
        x += this.createButton(x, y, ButtonType.OK) + 2;
        x += this.createButton(x, y, ButtonType.RESET) + 2;
        this.createButton(x, y, ButtonType.CANCEL);
    }

    protected int createButton(int x, int y, ButtonType type) {
        ButtonGeneric button = new ButtonGeneric(x, y, -1, this.buttonHeight, type.getDisplayName(), new String[0]);
        button.setWidth(Math.max(40, button.getWidth()));
        return this.addButton(button, this.createActionListener(type)).getWidth();
    }

    protected int getSelectedBox() {
        return this.selectedBox;
    }

    @Nullable
    protected GuiTextFieldGeneric getSelectedTextField() {
        if (this.getSelectedBox() == 1) {
            return this.textField1;
        }
        if (this.getSelectedBox() == 2) {
            return this.textField2;
        }
        return null;
    }

    @Override
    public boolean method_25421() {
        return this.getParent() != null && this.getParent().method_25421();
    }

    @Override
    public void drawContents(GuiContext ctx, int mouseX, int mouseY, float partialTicks) {
        if (this.getParent() != null) {
            this.getParent().method_25394(ctx.getGuiGraphics(), mouseX, mouseY, partialTicks);
        }
        ctx.method_51448().pushMatrix();
        ctx.method_51448().translate(0.0f, 0.0f);
        RenderUtils.drawOutlinedBox(ctx, this.dialogLeft, this.dialogTop, this.dialogWidth, this.dialogHeight, -536870912, -6710887);
        this.drawStringWithShadow(ctx, this.getTitleString(), this.dialogLeft + 10, this.dialogTop + 4, -1);
        this.textField1.method_25394(ctx.getGuiGraphics(), mouseX, mouseY, partialTicks);
        this.textField2.method_25394(ctx.getGuiGraphics(), mouseX, mouseY, partialTicks);
        this.drawButtons(ctx, mouseX, mouseY, partialTicks);
        ctx.method_51448().popMatrix();
    }

    @Override
    public boolean onKeyTyped(class_11908 input) {
        if (input.comp_4795() == 257) {
            if (this.applyValues(this.textField1.method_1882(), this.textField2.method_1882())) {
                GuiBase.openGui(this.getParent());
            }
            return true;
        }
        if (input.comp_4795() == 256) {
            GuiBase.openGui(this.getParent());
            return true;
        }
        if (this.textField1.method_25370()) {
            this.selectedBox = 1;
            return this.textField1.method_25404(input);
        }
        if (this.textField2.method_25370()) {
            this.selectedBox = 2;
            return this.textField2.method_25404(input);
        }
        return super.onKeyTyped(input);
    }

    @Override
    public boolean onCharTyped(class_11905 input) {
        if (this.textField1.method_25370()) {
            this.selectedBox = 1;
            return this.textField1.method_25400(input);
        }
        if (this.textField2.method_25370()) {
            this.selectedBox = 2;
            return this.textField2.method_25400(input);
        }
        return super.onCharTyped(input);
    }

    @Override
    public boolean onMouseClicked(class_11909 click, boolean doubleClick) {
        if (this.textField1.method_25402(click, doubleClick)) {
            this.selectedBox = 1;
            return true;
        }
        if (this.textField2.method_25402(click, doubleClick)) {
            this.selectedBox = 2;
            return true;
        }
        return super.onMouseClicked(click, doubleClick);
    }

    @Override
    public boolean onMouseDragged(@NonNull class_11909 click, double dragXAmount, double dragYAmount) {
        if (this.textField1.method_25403(click, dragXAmount, dragYAmount)) {
            this.selectedBox = 1;
            return true;
        }
        if (this.textField2.method_25403(click, dragXAmount, dragYAmount)) {
            this.selectedBox = 2;
            return true;
        }
        return super.onMouseDragged(click, dragXAmount, dragYAmount);
    }

    @Override
    public boolean onMouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.textField1.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            this.selectedBox = 1;
            return true;
        }
        if (this.textField2.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            this.selectedBox = 2;
            return true;
        }
        return super.onMouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    protected ButtonListener createActionListener(ButtonType type) {
        return new ButtonListener(type, this);
    }

    protected abstract boolean applyValues(String var1, String var2);

    protected static enum ButtonType {
        OK("malilib.gui.button.ok"),
        CANCEL("malilib.gui.button.cancel"),
        RESET("malilib.gui.button.reset");

        private final String labelKey;

        private ButtonType(String labelKey) {
            this.labelKey = labelKey;
        }

        public String getDisplayName() {
            return StringUtils.translate(this.labelKey, new Object[0]);
        }
    }

    protected static class ButtonListener
    implements IButtonActionListener {
        private final GuiTextDualInputBase gui;
        private final ButtonType type;

        public ButtonListener(ButtonType type, GuiTextDualInputBase gui) {
            this.type = type;
            this.gui = gui;
        }

        @Override
        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            if (this.type == ButtonType.OK) {
                if (this.gui.applyValues(this.gui.textField1.method_1882(), this.gui.textField2.method_1882())) {
                    GuiBase.openGui(this.gui.getParent());
                }
            } else if (this.type == ButtonType.CANCEL) {
                GuiBase.openGui(this.gui.getParent());
            } else if (this.type == ButtonType.RESET) {
                this.gui.textField1.method_1852(this.gui.originalText1);
                this.gui.textField2.method_1852(this.gui.originalText2);
                this.gui.textField1.method_25365(true);
                this.gui.selectedBox = 1;
            }
        }
    }
}

