/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui;

import com.mojang.blaze3d.textures.GpuTextureView;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.config.IConfigColor;
import fi.dy.masa.malilib.gui.GuiDialogBase;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.GuiTextFieldInteger;
import fi.dy.masa.malilib.gui.interfaces.IDialogHandler;
import fi.dy.masa.malilib.gui.interfaces.ITextFieldListener;
import fi.dy.masa.malilib.gui.wrappers.TextFieldType;
import fi.dy.masa.malilib.render.GuiContext;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.render.element.MaLiLibHSV1ColorIndicatorGuiElement;
import fi.dy.masa.malilib.render.element.MaLiLibHSV2ColorGradientGuiElement;
import fi.dy.masa.malilib.render.element.MaLiLibHSV2ColorSegmentedHueGuiElement;
import fi.dy.masa.malilib.render.element.MaLiLibHSVColorHorizontalBarMarkerGuiElement;
import fi.dy.masa.malilib.render.element.MaLiLibHSVColorSelectorGuiElement;
import fi.dy.masa.malilib.render.element.MaLiLibHSVColorVerticalBarMarkerGuiElement;
import fi.dy.masa.malilib.render.element.MaLiLibTexturedGuiElement;
import fi.dy.masa.malilib.util.StringUtils;
import java.awt.Color;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_12137;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import org.apache.commons.lang3.math.Fraction;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

public class GuiColorEditorHSV
extends GuiDialogBase {
    protected final IConfigColor config;
    @Nullable
    protected final IDialogHandler dialogHandler;
    @Nullable
    protected Element clickedElement;
    @Nullable
    protected Element currentTextInputElement;
    protected GuiTextFieldGeneric textFieldFullColor;
    protected GuiTextFieldGeneric textFieldH;
    protected GuiTextFieldGeneric textFieldS;
    protected GuiTextFieldGeneric textFieldV;
    protected GuiTextFieldGeneric textFieldR;
    protected GuiTextFieldGeneric textFieldG;
    protected GuiTextFieldGeneric textFieldB;
    protected GuiTextFieldGeneric textFieldA;
    protected boolean mouseDown;
    protected int color;
    protected int xHS;
    protected int yHS;
    protected int xHFullSV;
    protected int xH;
    protected int yH;
    protected int sizeHS;
    protected int widthHFullSV;
    protected int widthSlider;
    protected int heightSlider;
    protected int gapSlider;
    protected float relH;
    protected float relS;
    protected float relV;
    protected float relR;
    protected float relG;
    protected float relB;
    protected float relA;
    private Pair<class_2960, class_1043> dynamicTexture = null;

    public GuiColorEditorHSV(IConfigColor config, @Nullable IDialogHandler dialogHandler, class_437 parent) {
        this.config = config;
        this.dialogHandler = dialogHandler;
        if (this.dialogHandler == null) {
            this.setParent(parent);
        }
        this.title = StringUtils.translate("malilib.gui.title.color_editor", new Object[0]);
        this.setWidthAndHeight(300, 180);
        this.centerOnScreen();
        this.method_25423(this.dialogWidth, this.dialogHeight);
    }

    @Override
    public void setPosition(int left, int top) {
        super.setPosition(left, top);
        this.xHS = this.dialogLeft + 6;
        this.yHS = this.dialogTop + 24;
        this.xH = this.dialogLeft + 160;
        this.yH = this.dialogTop + 24;
        this.xHFullSV = this.xHS + 110;
        this.sizeHS = 102;
        this.widthHFullSV = 16;
        this.widthSlider = 90;
        this.heightSlider = 12;
        this.gapSlider = 6;
    }

    @Override
    public void initGui() {
        this.clearElements();
        int xLabel = this.dialogLeft + 148;
        int xTextField = xLabel + 110;
        int y = this.dialogTop + 24;
        y += this.createComponentElements(xTextField, y, xLabel, Element.H);
        y += this.createComponentElements(xTextField, y, xLabel, Element.S);
        y += this.createComponentElements(xTextField, y, xLabel, Element.V);
        y += this.createComponentElements(xTextField, y, xLabel, Element.R);
        y += this.createComponentElements(xTextField, y, xLabel, Element.G);
        y += this.createComponentElements(xTextField, y, xLabel, Element.B);
        y += this.createComponentElements(xTextField, y, xLabel, Element.A);
        this.addLabel(this.xH - 26, y + 3, 12, 12, -1, "HEX:");
        this.textFieldFullColor = new GuiTextFieldGeneric(this.xH, y + 1, 68, 14, this.font);
        this.textFieldFullColor.method_1880(12);
        this.addTextField(this.textFieldFullColor, new TextFieldListener(null, this), TextFieldType.STRING.setMaxLength(12));
        this.setColor(this.config.getIntegerValue());
    }

    protected int createComponentElements(int x, int y, int xLabel, Element element) {
        TextFieldListener listener = new TextFieldListener(element, this);
        GuiTextFieldInteger textField = new GuiTextFieldInteger(x, y, 32, 12, this.font);
        switch (element.ordinal()) {
            case 0: {
                this.textFieldH = textField;
                break;
            }
            case 1: {
                this.textFieldS = textField;
                break;
            }
            case 2: {
                this.textFieldV = textField;
                break;
            }
            case 3: {
                this.textFieldR = textField;
                break;
            }
            case 4: {
                this.textFieldG = textField;
                break;
            }
            case 5: {
                this.textFieldB = textField;
                break;
            }
            case 6: {
                this.textFieldA = textField;
                break;
            }
        }
        this.addLabel(xLabel, y, 12, 12, -1, element.name() + ":");
        this.addTextField(textField, listener, TextFieldType.INTEGER);
        return this.heightSlider + this.gapSlider;
    }

    public void method_25432() {
        this.config.setIntegerValue(this.color);
        this.clearDynamicTexture();
        super.method_25432();
    }

    @Override
    public void method_25394(@NotNull class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
        if (this.getParent() != null) {
            this.getParent().method_25394(drawContext, mouseX, mouseY, partialTicks);
        }
        super.method_25394(drawContext, mouseX, mouseY, partialTicks);
        if (this.mouseDown && this.clickedElement != null) {
            this.updateColorFromMouseInput(this.clickedElement, mouseX, mouseY);
        }
        this.drawColorSelector(GuiContext.fromGuiGraphics(drawContext), mouseX, mouseY);
    }

    @Override
    protected void drawScreenBackground(GuiContext ctx, int mouseX, int mouseY) {
        RenderUtils.drawOutlinedBox(ctx, this.dialogLeft, this.dialogTop, this.dialogWidth, this.dialogHeight, -16777216, -6710887);
    }

    @Override
    protected void drawTitle(GuiContext ctx, int mouseX, int mouseY, float partialTicks) {
        this.drawStringWithShadow(ctx, this.title, this.dialogLeft + 10, this.dialogTop + 6, -1);
    }

    @Override
    public boolean method_25404(@NotNull class_11908 input) {
        return this.onKeyTyped(input);
    }

    @Override
    public boolean onKeyTyped(class_11908 input) {
        if (input.comp_4795() == 256 && this.dialogHandler != null) {
            this.dialogHandler.closeDialog();
            return true;
        }
        return super.onKeyTyped(input);
    }

    @Override
    public boolean onMouseClicked(class_11909 click, boolean doubleClick) {
        this.clickedElement = this.getHoveredElement((int)click.comp_4798(), (int)click.comp_4799());
        if (this.clickedElement != null) {
            this.mouseDown = true;
            this.updateColorFromMouseInput(this.clickedElement, (int)click.comp_4798(), (int)click.comp_4799());
        }
        return super.onMouseClicked(click, doubleClick);
    }

    @Override
    public boolean onMouseReleased(class_11909 click) {
        this.mouseDown = false;
        this.clickedElement = null;
        return super.onMouseReleased(click);
    }

    protected float[] getCurrentColorHSV() {
        return this.getColorHSV(this.color);
    }

    protected float[] getColorHSV(int color) {
        int r = color >>> 16 & 0xFF;
        int g = color >>> 8 & 0xFF;
        int b = color & 0xFF;
        float[] hsv = new float[3];
        Color.RGBtoHSB(r, g, b, hsv);
        return hsv;
    }

    protected void setColor(int color) {
        this.color = color;
        this.relA = (float)((color & 0xFF000000) >>> 24) / 255.0f;
        this.setHSVFromRGB(color);
        this.setRGBFromHSV();
        this.currentTextInputElement = null;
    }

    protected void setHSVFromRGB() {
        this.setHSVFromRGB(this.relR, this.relG, this.relB);
    }

    protected void setHSVFromRGB(float r, float g, float b) {
        float[] hsv = new float[3];
        int ri = (int)(r * 255.0f);
        int gi = (int)(g * 255.0f);
        int bi = (int)(b * 255.0f);
        int ai = (int)(this.relA * 255.0f);
        Color.RGBtoHSB(ri, gi, bi, hsv);
        this.relH = hsv[0];
        this.relS = hsv[1];
        this.relV = hsv[2];
        this.color = ai << 24 | ri << 16 | gi << 8 | bi;
        this.updateTextFieldsHSV(this.relH, this.relS, this.relV);
    }

    protected void setHSVFromRGB(int rgb) {
        float[] hsv = this.getColorHSV(rgb);
        this.relH = hsv[0];
        this.relS = hsv[1];
        this.relV = hsv[2];
        this.updateTextFieldsHSV(this.relH, this.relS, this.relV);
    }

    protected void setRGBFromHSV() {
        this.setRGBFromHSV(this.relH, this.relS, this.relV);
    }

    protected void setRGBFromHSV(float h, float s, float v) {
        int rgb = Color.HSBtoRGB(h, s, v);
        int ai = (int)(this.relA * 255.0f);
        this.color = ai << 24 | rgb & 0xFFFFFF;
        this.relR = (float)(rgb >>> 16 & 0xFF) / 255.0f;
        this.relG = (float)(rgb >>> 8 & 0xFF) / 255.0f;
        this.relB = (float)(rgb & 0xFF) / 255.0f;
        this.updateTextFieldsRGB();
    }

    protected void updateColorFromMouseInput(Element element, int mouseX, int mouseY) {
        if (element == Element.SV) {
            mouseX = class_3532.method_15340((int)mouseX, (int)this.xHS, (int)(this.xHS + this.sizeHS));
            mouseY = class_3532.method_15340((int)mouseY, (int)this.yHS, (int)(this.yHS + this.sizeHS));
            int relX = mouseX - this.xHS;
            int relY = mouseY - this.yHS;
            float saturation = 1.0f - (float)relY / (float)this.sizeHS;
            float value = (float)relX / (float)this.sizeHS;
            this.relS = saturation;
            this.relV = value;
            this.setRGBFromHSV();
            this.updateTextField(Element.S);
            this.updateTextField(Element.V);
        } else if (element == Element.H_FULL_SV) {
            float hue;
            mouseY = class_3532.method_15340((int)mouseY, (int)this.yHS, (int)(this.yHS + this.sizeHS));
            int relY = mouseY - this.yHS;
            this.relH = hue = 1.0f - (float)relY / (float)this.sizeHS;
            this.setRGBFromHSV();
            this.updateTextField(Element.H);
        } else {
            mouseX = class_3532.method_15340((int)mouseX, (int)this.xH, (int)(this.xH + this.widthSlider));
            int relX = mouseX - this.xH;
            float relVal = (float)relX / (float)this.widthSlider;
            switch (element.ordinal()) {
                case 0: {
                    this.relH = relVal;
                    this.setRGBFromHSV();
                    this.updateTextField(Element.H);
                    break;
                }
                case 1: {
                    this.relS = relVal;
                    this.setRGBFromHSV();
                    this.updateTextField(Element.S);
                    break;
                }
                case 2: {
                    this.relV = relVal;
                    this.setRGBFromHSV();
                    this.updateTextField(Element.V);
                    break;
                }
                case 3: {
                    this.relR = relVal;
                    this.setHSVFromRGB();
                    this.updateTextField(Element.R);
                    break;
                }
                case 4: {
                    this.relG = relVal;
                    this.setHSVFromRGB();
                    this.updateTextField(Element.G);
                    break;
                }
                case 5: {
                    this.relB = relVal;
                    this.setHSVFromRGB();
                    this.updateTextField(Element.B);
                    break;
                }
                case 6: {
                    this.relA = relVal;
                    this.setHSVFromRGB();
                    this.updateTextField(Element.A);
                    break;
                }
            }
        }
    }

    protected void updateTextFieldsHSV(float h, float s, float v) {
        this.updateTextField(Element.HEX);
        this.updateTextField(Element.H);
        this.updateTextField(Element.S);
        this.updateTextField(Element.V);
    }

    protected void updateTextFieldsRGB() {
        this.updateTextField(Element.HEX);
        this.updateTextField(Element.R);
        this.updateTextField(Element.G);
        this.updateTextField(Element.B);
        this.updateTextField(Element.A);
    }

    protected void updateTextField(Element type) {
        if (this.currentTextInputElement != type) {
            switch (type.ordinal()) {
                case 9: {
                    this.textFieldFullColor.method_1852(String.format("#%08X", this.color));
                    break;
                }
                case 0: {
                    this.textFieldH.method_1852(String.valueOf((int)(this.relH * 360.0f)));
                    break;
                }
                case 1: {
                    this.textFieldS.method_1852(String.valueOf((int)(this.relS * 100.0f)));
                    break;
                }
                case 2: {
                    this.textFieldV.method_1852(String.valueOf((int)(this.relV * 100.0f)));
                    break;
                }
                case 3: {
                    this.textFieldR.method_1852(String.valueOf((int)(this.relR * 255.0f)));
                    break;
                }
                case 4: {
                    this.textFieldG.method_1852(String.valueOf((int)(this.relG * 255.0f)));
                    break;
                }
                case 5: {
                    this.textFieldB.method_1852(String.valueOf((int)(this.relB * 255.0f)));
                    break;
                }
                case 6: {
                    this.textFieldA.method_1852(String.valueOf((int)(this.relA * 255.0f)));
                    break;
                }
            }
        }
    }

    protected void drawColorSelector(GuiContext ctx, int mouseX, int mouseY) {
        if (this.field_22787 == null) {
            return;
        }
        int x = this.xH - 1;
        int y = this.yH - 1;
        int w = this.widthSlider + 2;
        int h = this.heightSlider + 2;
        boolean z = false;
        int yd = this.heightSlider + this.gapSlider;
        int cx = this.xHS;
        int cy = this.yHS + this.sizeHS + 8;
        int cw = 32;
        int ch = 32;
        RenderUtils.drawOutline(ctx, x, y, w, h, -1056964609);
        RenderUtils.drawOutline(ctx, x, y += yd, w, h, -1056964609);
        RenderUtils.drawOutline(ctx, x, y += yd, w, h, -1056964609);
        RenderUtils.drawOutline(ctx, x, y += yd, w, h, -1056964609);
        RenderUtils.drawOutline(ctx, x, y += yd, w, h, -1056964609);
        RenderUtils.drawOutline(ctx, x, y += yd, w, h, -1056964609);
        RenderUtils.drawOutline(ctx, x, y += yd, w, h, -1056964609);
        x = this.xHS;
        y = this.yHS;
        w = this.sizeHS;
        h = this.sizeHS;
        RenderUtils.drawOutline(ctx, x - 1, y - 1, w + 2, h + 2, -1056964609);
        RenderUtils.drawOutline(ctx, cx - 1, cy - 1, cw + 2, ch + 2, -1056964609);
        RenderUtils.drawOutline(ctx, this.xHFullSV, y - 1, this.widthHFullSV, this.sizeHS + 2, -1056964609);
        int r = (int)(this.relR * 255.0f);
        int g = (int)(this.relG * 255.0f);
        int b = (int)(this.relB * 255.0f);
        int a = 255;
        int c = 255;
        this.generateDynamicTextureForHSVSelector();
        ctx.addSimpleElement(new MaLiLibTexturedGuiElement(class_10799.field_56883, class_11231.method_70900((GpuTextureView)((class_1043)this.dynamicTexture.getRight()).method_71659(), (class_12137)((class_1043)this.dynamicTexture.getRight()).method_75484()), new Matrix3x2f((Matrix3x2fc)ctx.method_51448()), x, y, x + w, y + h, 0.0f, 1.0f, 0.0f, 1.0f, -1, ctx.peekLastScissor()));
        ctx.addSimpleElement(new MaLiLibHSV1ColorIndicatorGuiElement(class_10799.field_56879, class_11231.method_70899(), new Matrix3x2f((Matrix3x2fc)ctx.method_51448()), cx, cx + cw, cy, cy + ch, r, g, b, a, ctx.peekLastScissor()));
        int yt = y + (int)((1.0f - this.relS) * (float)h);
        ctx.addSimpleElement(new MaLiLibHSV1ColorIndicatorGuiElement(class_10799.field_56879, class_11231.method_70899(), new Matrix3x2f((Matrix3x2fc)ctx.method_51448()), x - 1, x + w + 1, yt, yt + 1, c, c, c, a, ctx.peekLastScissor()));
        int xt = x + (int)(this.relV * (float)w);
        ctx.addSimpleElement(new MaLiLibHSV1ColorIndicatorGuiElement(class_10799.field_56879, class_11231.method_70899(), new Matrix3x2f((Matrix3x2fc)ctx.method_51448()), xt, xt + 1, y - 1, y + h + 1, c, c, c, a, ctx.peekLastScissor()));
        x = this.xH;
        w = this.widthSlider;
        h = this.heightSlider;
        yd = this.heightSlider + this.gapSlider;
        GuiColorEditorHSV.renderHueBarVertical(ctx, this.xHFullSV + 1, this.yHS, (float)z, this.widthHFullSV - 2, this.sizeHS, 1.0f, 1.0f);
        GuiColorEditorHSV.renderBarMarkerVerticalBar(ctx, this.xHFullSV, this.yHS, (float)z, this.widthHFullSV, this.sizeHS, this.relH);
        GuiColorEditorHSV.renderHueBarHorizontal(ctx, x, y, (float)z, w, h, this.relS, this.relV);
        GuiColorEditorHSV.renderBarMarkerHorizontalBar(ctx, x, y, (float)z, w, h, this.relH);
        int color1 = Color.HSBtoRGB(this.relH, 0.0f, this.relV);
        int color2 = Color.HSBtoRGB(this.relH, 1.0f, this.relV);
        GuiColorEditorHSV.renderGradientColorBar(ctx, x, y += yd, (float)z, w, h, color1, color2);
        GuiColorEditorHSV.renderBarMarkerHorizontalBar(ctx, x, y, (float)z, w, h, this.relS);
        color1 = Color.HSBtoRGB(this.relH, this.relS, 0.0f);
        color2 = Color.HSBtoRGB(this.relH, this.relS, 1.0f);
        GuiColorEditorHSV.renderGradientColorBar(ctx, x, y += yd, (float)z, w, h, color1, color2);
        GuiColorEditorHSV.renderBarMarkerHorizontalBar(ctx, x, y, (float)z, w, h, this.relV);
        color1 = this.color & 0xFF00FFFF | 0xFF000000;
        color2 = this.color | 0xFFFF0000;
        GuiColorEditorHSV.renderGradientColorBar(ctx, x, y += yd, (float)z, w, h, color1, color2);
        GuiColorEditorHSV.renderBarMarkerHorizontalBar(ctx, x, y, (float)z, w, h, (float)r / 255.0f);
        color1 = this.color & 0xFFFF00FF | 0xFF000000;
        color2 = this.color | 0xFF00FF00;
        GuiColorEditorHSV.renderGradientColorBar(ctx, x, y += yd, (float)z, w, h, color1, color2);
        GuiColorEditorHSV.renderBarMarkerHorizontalBar(ctx, x, y, (float)z, w, h, (float)g / 255.0f);
        color1 = this.color & 0xFFFFFF00 | 0xFF000000;
        color2 = this.color | 0xFF0000FF;
        GuiColorEditorHSV.renderGradientColorBar(ctx, x, y += yd, (float)z, w, h, color1, color2);
        GuiColorEditorHSV.renderBarMarkerHorizontalBar(ctx, x, y, (float)z, w, h, (float)b / 255.0f);
        a = (int)(this.relA * 255.0f);
        color1 = this.color & 0xFFFFFF;
        color2 = this.color | 0xFF000000;
        GuiColorEditorHSV.renderGradientColorBar(ctx, x, y += yd, (float)z, w, h, color1, color2);
        GuiColorEditorHSV.renderBarMarkerHorizontalBar(ctx, x, y, (float)z, w, h, (float)a / 255.0f);
        y += yd;
    }

    @Deprecated
    private int[] getColorPairForSelector() {
        int color1 = Color.HSBtoRGB(this.relH, 0.0f, 0.0f);
        int color2 = Color.HSBtoRGB(this.relH, 1.0f, 0.0f);
        int color3 = Color.HSBtoRGB(this.relH, 0.0f, 1.0f);
        int color4 = Color.HSBtoRGB(this.relH, 1.0f, 1.0f);
        return new int[]{color1, color2, color3, color4};
    }

    private void generateDynamicTextureForHSVSelector() {
        int sizeW = 256;
        int sizeH = 256;
        if (this.dynamicTexture != null) {
            this.clearDynamicTexture();
        }
        try (class_1011 image = new class_1011(256, 256, false);){
            class_2960 id = class_2960.method_60655((String)"malilib", (String)UUID.randomUUID().toString());
            this.dynamicTexture = Pair.of((Object)id, (Object)new class_1043(() -> ((class_2960)id).toString(), image));
            this.mc.method_1531().method_4616(id, (class_1044)this.dynamicTexture.getRight());
            for (int x = 0; x < 256; ++x) {
                float brightness = Fraction.getFraction((int)x, (int)256).floatValue();
                for (int y = 0; y < 256; ++y) {
                    float saturation = Fraction.getFraction((int)y, (int)256).floatValue();
                    image.method_61941(x, 255 - y, Color.HSBtoRGB(this.relH, saturation, brightness));
                }
            }
            ((class_1043)this.dynamicTexture.getRight()).method_4524();
        }
        catch (Throwable err) {
            MaLiLib.LOGGER.error("GuiColorEditorHSV: generate native image failed; {}", (Object)err.getLocalizedMessage());
        }
    }

    private void clearDynamicTexture() {
        if (this.dynamicTexture != null) {
            this.mc.method_1531().method_4615((class_2960)this.dynamicTexture.getLeft());
            ((class_1043)this.dynamicTexture.getRight()).close();
            this.dynamicTexture = null;
        }
    }

    public static void renderGradientColorBar(GuiContext ctx, int x, int y, float z, int width, int height, int colorStart, int colorEnd) {
        ctx.addSimpleElement(new MaLiLibHSV2ColorGradientGuiElement(class_10799.field_56879, class_11231.method_70899(), new Matrix3x2f((Matrix3x2fc)ctx.method_51448()), x, x + width, y, y + height, colorStart, colorEnd, ctx.peekLastScissor()));
    }

    public static void renderHueBarHorizontal(GuiContext ctx, int x, int y, float z, int width, int height, float saturation, float value) {
        GuiColorEditorHSV.renderHueBar(ctx, x, y, z, 0, height, width / 6, 0, saturation, value);
    }

    public static void renderHueBarVertical(GuiContext ctx, int x, int y, float z, int width, int height, float saturation, float value) {
        y = y + height - height / 6;
        GuiColorEditorHSV.renderHueBar(ctx, x, y, z, width, 0, 0, height / 6, saturation, value);
    }

    public static void renderHueBar(GuiContext ctx, int x, int y, float z, int width, int height, int segmentWidth, int segmentHeight, float saturation, float value) {
        int color1 = Color.HSBtoRGB(0.0f, saturation, value);
        int color2 = Color.HSBtoRGB(0.16666667f, saturation, value);
        GuiColorEditorHSV.renderHueBarSegment(ctx, x, y, z, width, height, segmentWidth, segmentHeight, color1, color2);
        color1 = Color.HSBtoRGB(0.16666667f, saturation, value);
        color2 = Color.HSBtoRGB(0.33333334f, saturation, value);
        GuiColorEditorHSV.renderHueBarSegment(ctx, x += segmentWidth, y -= segmentHeight, z, width, height, segmentWidth, segmentHeight, color1, color2);
        color1 = Color.HSBtoRGB(0.33333334f, saturation, value);
        color2 = Color.HSBtoRGB(0.5f, saturation, value);
        GuiColorEditorHSV.renderHueBarSegment(ctx, x += segmentWidth, y -= segmentHeight, z, width, height, segmentWidth, segmentHeight, color1, color2);
        color1 = Color.HSBtoRGB(0.5f, saturation, value);
        color2 = Color.HSBtoRGB(0.6666667f, saturation, value);
        GuiColorEditorHSV.renderHueBarSegment(ctx, x += segmentWidth, y -= segmentHeight, z, width, height, segmentWidth, segmentHeight, color1, color2);
        color1 = Color.HSBtoRGB(0.6666667f, saturation, value);
        color2 = Color.HSBtoRGB(0.8333333f, saturation, value);
        GuiColorEditorHSV.renderHueBarSegment(ctx, x += segmentWidth, y -= segmentHeight, z, width, height, segmentWidth, segmentHeight, color1, color2);
        color1 = Color.HSBtoRGB(0.8333333f, saturation, value);
        color2 = Color.HSBtoRGB(1.0f, saturation, value);
        GuiColorEditorHSV.renderHueBarSegment(ctx, x += segmentWidth, y -= segmentHeight, z, width, height, segmentWidth, segmentHeight, color1, color2);
    }

    public static void renderHueBarSegment(GuiContext ctx, int x, int y, float z, int width, int height, int segmentWidth, int segmentHeight, int color1, int color2) {
        ctx.addSimpleElement(new MaLiLibHSV2ColorSegmentedHueGuiElement(class_10799.field_56879, class_11231.method_70899(), new Matrix3x2f((Matrix3x2fc)ctx.method_51448()), x, y, width, height, segmentWidth, segmentHeight, color1, color2, ctx.peekLastScissor()));
    }

    public static void renderHSSelector(GuiContext ctx, int xStart, int yStart, float z, int width, int height, float hue) {
        ctx.addSimpleElement(new MaLiLibHSVColorSelectorGuiElement(class_10799.field_56879, class_11231.method_70899(), new Matrix3x2f((Matrix3x2fc)ctx.method_51448()), xStart, yStart, width, height, hue, ctx.peekLastScissor()));
    }

    public static void renderBarMarkerHorizontalBar(GuiContext ctx, int x, int y, float z, int barWidth, int barHeight, float value) {
        ctx.addSimpleElement(new MaLiLibHSVColorHorizontalBarMarkerGuiElement(class_10799.field_56879, class_11231.method_70899(), new Matrix3x2f((Matrix3x2fc)ctx.method_51448()), x, y, barWidth, barHeight, value, ctx.peekLastScissor()));
    }

    public static void renderBarMarkerVerticalBar(GuiContext ctx, int x, int y, float z, int barWidth, int barHeight, float value) {
        ctx.addSimpleElement(new MaLiLibHSVColorVerticalBarMarkerGuiElement(class_10799.field_56879, class_11231.method_70899(), new Matrix3x2f((Matrix3x2fc)ctx.method_51448()), x, y, barWidth, barHeight, value, ctx.peekLastScissor()));
    }

    @Nullable
    protected Element getHoveredElement(int mouseX, int mouseY) {
        if (mouseX >= this.xHS && mouseX <= this.xHS + this.sizeHS && mouseY >= this.yHS && mouseY <= this.yHS + this.sizeHS) {
            return Element.SV;
        }
        if (mouseX >= this.xHFullSV && mouseX <= this.xHFullSV + this.widthHFullSV && mouseY >= this.yHS && mouseY <= this.yHS + this.sizeHS) {
            return Element.H_FULL_SV;
        }
        if (mouseX >= this.xH && mouseX <= this.xH + this.widthSlider) {
            int relY;
            int index;
            int h = this.heightSlider + this.gapSlider;
            if (mouseY >= this.yH && mouseY <= this.yH + h * 7 - this.gapSlider && (index = (relY = mouseY - this.yH) / h) < 7 && relY % h < this.heightSlider) {
                return Element.values()[index];
            }
        }
        return null;
    }

    protected static enum Element {
        H,
        S,
        V,
        R,
        G,
        B,
        A,
        SV,
        H_FULL_SV,
        HEX;

    }

    protected record TextFieldListener(@Nullable Element type, GuiColorEditorHSV gui) implements ITextFieldListener<GuiTextFieldGeneric>
    {
        @Override
        public boolean onTextChange(GuiTextFieldGeneric textField) {
            int colorOld = this.gui.color;
            if (this.type == null) {
                this.gui.currentTextInputElement = Element.HEX;
                this.gui.setColor(StringUtils.getColor(textField.method_1882(), colorOld));
            } else {
                try {
                    int val = Integer.parseInt(textField.method_1882());
                    float[] hsv = this.gui.getCurrentColorHSV();
                    int colorNew = colorOld;
                    switch (this.type.ordinal()) {
                        case 0: {
                            val = class_3532.method_15340((int)val, (int)0, (int)360);
                            float h = (float)val / 360.0f;
                            colorNew = Color.HSBtoRGB(h, hsv[1], hsv[2]);
                            break;
                        }
                        case 1: {
                            val = class_3532.method_15340((int)val, (int)0, (int)100);
                            float s = (float)val / 100.0f;
                            colorNew = Color.HSBtoRGB(hsv[0], s, hsv[2]);
                            break;
                        }
                        case 2: {
                            val = class_3532.method_15340((int)val, (int)0, (int)100);
                            float v = (float)val / 100.0f;
                            colorNew = Color.HSBtoRGB(hsv[0], hsv[1], v);
                            break;
                        }
                        case 3: {
                            val = class_3532.method_15340((int)val, (int)0, (int)255);
                            colorNew = colorOld & 0xFFFF | val << 16;
                            break;
                        }
                        case 4: {
                            val = class_3532.method_15340((int)val, (int)0, (int)255);
                            colorNew = colorOld & 0xFF00FF | val << 8;
                            break;
                        }
                        case 5: {
                            val = class_3532.method_15340((int)val, (int)0, (int)255);
                            colorNew = colorOld & 0xFFFF00 | val;
                            break;
                        }
                        case 6: {
                            val = class_3532.method_15340((int)val, (int)0, (int)255);
                            colorNew = colorOld & 0xFFFFFF | val << 24;
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                    if (colorNew != colorOld) {
                        this.gui.currentTextInputElement = this.type;
                        this.gui.setColor(colorNew);
                    }
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

