/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui;

import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.GuiTextFieldMultiLine;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.IMessageConsumer;
import fi.dy.masa.malilib.gui.interfaces.ITextFieldListener;
import fi.dy.masa.malilib.gui.interfaces.ITextFieldMultiLineListener;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetLabel;
import fi.dy.masa.malilib.gui.wrappers.TextFieldMultiLineWrapper;
import fi.dy.masa.malilib.gui.wrappers.TextFieldType;
import fi.dy.masa.malilib.gui.wrappers.TextFieldWrapper;
import fi.dy.masa.malilib.interfaces.IStringConsumer;
import fi.dy.masa.malilib.render.GuiContext;
import fi.dy.masa.malilib.render.MessageRenderer;
import fi.dy.masa.malilib.render.RenderUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1041;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.NonNull;

public abstract class GuiBase
extends class_437
implements IMessageConsumer,
IStringConsumer {
    public static final String TXT_AQUA = class_124.field_1075.toString();
    public static final String TXT_BLACK = class_124.field_1074.toString();
    public static final String TXT_BLUE = class_124.field_1078.toString();
    public static final String TXT_GOLD = class_124.field_1065.toString();
    public static final String TXT_GRAY = class_124.field_1080.toString();
    public static final String TXT_GREEN = class_124.field_1060.toString();
    public static final String TXT_RED = class_124.field_1061.toString();
    public static final String TXT_WHITE = class_124.field_1068.toString();
    public static final String TXT_YELLOW = class_124.field_1054.toString();
    public static final String TXT_BOLD = class_124.field_1067.toString();
    public static final String TXT_ITALIC = class_124.field_1056.toString();
    public static final String TXT_RST = class_124.field_1070.toString();
    public static final String TXT_STRIKETHROUGH = class_124.field_1055.toString();
    public static final String TXT_UNDERLINE = class_124.field_1073.toString();
    public static final String TXT_DARK_AQUA = class_124.field_1062.toString();
    public static final String TXT_DARK_BLUE = class_124.field_1058.toString();
    public static final String TXT_DARK_GRAY = class_124.field_1063.toString();
    public static final String TXT_DARK_GREEN = class_124.field_1077.toString();
    public static final String TXT_DARK_PURPLE = class_124.field_1064.toString();
    public static final String TXT_DARK_RED = class_124.field_1079.toString();
    public static final String TXT_LIGHT_PURPLE = class_124.field_1076.toString();
    protected static final String BUTTON_LABEL_ADD = TXT_DARK_GREEN + "+" + TXT_RST;
    protected static final String BUTTON_LABEL_REMOVE = TXT_DARK_RED + "-" + TXT_RST;
    public static final class_2960 BG_TEXTURE = class_2960.method_60656((String)"textures/gui/inworld_menu_list_background.png");
    public static final int COLOR_WHITE = -1;
    public static final int TOOLTIP_BACKGROUND = -1342177280;
    public static final int COLOR_HORIZONTAL_BAR = -6710887;
    protected static final int LEFT = 20;
    protected static final int TOP = 10;
    public final class_310 mc = class_310.method_1551();
    public final class_327 font;
    public final int fontHeight;
    private final List<ButtonBase> buttons;
    private final List<WidgetBase> widgets;
    private final List<TextFieldWrapper<? extends GuiTextFieldGeneric>> textFields;
    private final List<TextFieldMultiLineWrapper<? extends GuiTextFieldMultiLine>> textFieldsMultiLine;
    private final MessageRenderer messageRenderer;
    private long openTime;
    protected WidgetBase hoveredWidget;
    protected String title;
    protected boolean useTitleHierarchy;
    private int keyInputCount;
    private double mouseWheelHorizontalDeltaSum;
    private double mouseWheelVerticalDeltaSum;
    @Nullable
    private class_437 parent;

    protected GuiBase() {
        super(class_5244.field_39003);
        this.font = this.mc.field_1772;
        Objects.requireNonNull(this.font);
        this.fontHeight = 9;
        this.buttons = new ArrayList<ButtonBase>();
        this.widgets = new ArrayList<WidgetBase>();
        this.textFields = new ArrayList<TextFieldWrapper<? extends GuiTextFieldGeneric>>();
        this.textFieldsMultiLine = new ArrayList<TextFieldMultiLineWrapper<? extends GuiTextFieldMultiLine>>();
        this.messageRenderer = new MessageRenderer(-587202560, -6710887);
        this.hoveredWidget = null;
        this.title = "";
        this.useTitleHierarchy = true;
    }

    public GuiBase setParent(@Nullable class_437 parent) {
        if (parent == null || parent.getClass() != this.getClass()) {
            this.parent = parent;
        }
        return this;
    }

    @Nullable
    public class_437 getParent() {
        return this.parent;
    }

    public String getTitleString() {
        return this.useTitleHierarchy && this.parent instanceof GuiBase ? ((GuiBase)this.parent).getTitleString() + " => " + this.title : this.title;
    }

    @NotNull
    public class_2561 method_25440() {
        return class_2561.method_30163((String)this.getTitleString());
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25410(int width, int height) {
        if (this.getParent() != null) {
            this.getParent().method_25410(width, height);
        }
        super.method_25410(width, height);
    }

    public void method_25426() {
        super.method_25426();
        this.initGui();
        this.openTime = System.nanoTime();
    }

    public void initGui() {
        this.clearElements();
    }

    protected void closeGui(boolean showParent) {
        if (showParent) {
            this.mc.method_1507(this.parent);
        } else {
            this.method_25419();
        }
    }

    public int getScreenHeight() {
        return this.field_22790;
    }

    public int getScreenWidth() {
        return this.field_22789;
    }

    public void method_25394(@NotNull class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
        GuiContext ctx = GuiContext.fromGuiGraphics(drawContext);
        ctx.method_71048();
        this.drawScreenBackground(ctx, mouseX, mouseY);
        this.drawTitle(ctx, mouseX, mouseY, partialTicks);
        this.drawWidgets(ctx, mouseX, mouseY);
        this.drawButtons(ctx, mouseX, mouseY, partialTicks);
        this.drawContents(ctx, mouseX, mouseY, partialTicks);
        this.drawTextFields(ctx, mouseX, mouseY);
        this.drawTextFieldsMultiLine(ctx, mouseX, mouseY);
        this.drawHoveredWidget(ctx, mouseX, mouseY);
        this.drawButtonHoverTexts(ctx, mouseX, mouseY, partialTicks);
        this.drawGuiMessages(ctx);
    }

    public void method_25420(@NotNull class_332 context, int mouseX, int mouseY, float deltaTicks) {
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.mouseWheelHorizontalDeltaSum != 0.0 && Math.signum(horizontalAmount) != Math.signum(this.mouseWheelHorizontalDeltaSum)) {
            this.mouseWheelHorizontalDeltaSum = 0.0;
        }
        if (this.mouseWheelVerticalDeltaSum != 0.0 && Math.signum(verticalAmount) != Math.signum(this.mouseWheelVerticalDeltaSum)) {
            this.mouseWheelVerticalDeltaSum = 0.0;
        }
        this.mouseWheelHorizontalDeltaSum += horizontalAmount;
        this.mouseWheelVerticalDeltaSum += verticalAmount;
        horizontalAmount = (int)this.mouseWheelHorizontalDeltaSum;
        verticalAmount = (int)this.mouseWheelVerticalDeltaSum;
        if (horizontalAmount != 0.0 || verticalAmount != 0.0) {
            this.mouseWheelHorizontalDeltaSum -= horizontalAmount;
            this.mouseWheelVerticalDeltaSum -= verticalAmount;
            if (this.onMouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount)) {
                return true;
            }
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25402(@NotNull class_11909 click, boolean doubleClick) {
        if (!this.onMouseClicked(click, doubleClick)) {
            return super.method_25402(click, doubleClick);
        }
        return false;
    }

    public boolean method_25406(@NotNull class_11909 click) {
        if (!this.onMouseReleased(click)) {
            return super.method_25406(click);
        }
        return false;
    }

    public boolean method_25403(@NonNull class_11909 click, double dragX, double dragY) {
        if (!this.onMouseDragged(click, dragX, dragY)) {
            return super.method_25403(click, dragX, dragY);
        }
        return false;
    }

    public boolean method_25404(@NotNull class_11908 input) {
        ++this.keyInputCount;
        if (this.onKeyTyped(input)) {
            return true;
        }
        return super.method_25404(input);
    }

    public boolean method_25400(@NotNull class_11905 input) {
        if (this.keyInputCount <= 0 && System.nanoTime() - this.openTime <= 100000000L) {
            ++this.keyInputCount;
            return true;
        }
        if (this.onCharTyped(input)) {
            return true;
        }
        return super.method_25400(input);
    }

    public boolean onMouseClicked(class_11909 click, boolean doubleClick) {
        for (ButtonBase button : this.buttons) {
            if (!button.onMouseClicked(click, doubleClick)) continue;
            return true;
        }
        boolean handled = false;
        for (TextFieldWrapper<? extends GuiTextFieldGeneric> textFieldWrapper : this.textFields) {
            if (!textFieldWrapper.mouseClicked(click, doubleClick)) continue;
            handled = true;
        }
        if (!handled) {
            for (TextFieldMultiLineWrapper textFieldMultiLineWrapper : this.textFieldsMultiLine) {
                if (!textFieldMultiLineWrapper.mouseClicked(click, doubleClick)) continue;
                handled = true;
            }
        }
        if (!handled) {
            for (WidgetBase widgetBase : this.widgets) {
                if (!widgetBase.isMouseOver((int)click.comp_4798(), (int)click.comp_4799()) || !widgetBase.onMouseClicked(click, doubleClick)) continue;
                handled = true;
                break;
            }
        }
        return handled;
    }

    public boolean onMouseReleased(class_11909 click) {
        for (WidgetBase widget : this.widgets) {
            widget.onMouseReleased(click);
        }
        return false;
    }

    public boolean onMouseDragged(@NonNull class_11909 click, double dragXAmount, double dragYAmount) {
        for (ButtonBase buttonBase : this.buttons) {
            if (!buttonBase.onMouseDragged(click, dragXAmount, dragYAmount)) continue;
            return true;
        }
        for (TextFieldWrapper textFieldWrapper : this.textFields) {
            if (!textFieldWrapper.onMouseDragged(click, dragXAmount, dragYAmount)) continue;
            return true;
        }
        for (TextFieldMultiLineWrapper textFieldMultiLineWrapper : this.textFieldsMultiLine) {
            if (!textFieldMultiLineWrapper.onMouseDragged(click, dragXAmount, dragYAmount)) continue;
            return true;
        }
        for (WidgetBase widgetBase : this.widgets) {
            if (!widgetBase.onMouseDragged(click, dragXAmount, dragYAmount)) continue;
            return true;
        }
        return false;
    }

    public boolean onMouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        for (ButtonBase buttonBase : this.buttons) {
            if (!buttonBase.onMouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount)) continue;
            return true;
        }
        for (TextFieldWrapper textFieldWrapper : this.textFields) {
            if (!textFieldWrapper.onMouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount)) continue;
            return true;
        }
        for (TextFieldMultiLineWrapper textFieldMultiLineWrapper : this.textFieldsMultiLine) {
            if (!textFieldMultiLineWrapper.onMouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount)) continue;
            return true;
        }
        for (WidgetBase widgetBase : this.widgets) {
            if (!widgetBase.onMouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount)) continue;
            return true;
        }
        return false;
    }

    public boolean onKeyTyped(class_11908 input) {
        Object entry;
        int i;
        boolean handled = false;
        int selected = -1;
        int selectedMultiLine = -1;
        for (i = 0; i < this.textFields.size(); ++i) {
            entry = this.textFields.get(i);
            if (!((TextFieldWrapper)entry).isFocused()) continue;
            if (input.comp_4795() == 258) {
                ((TextFieldWrapper)entry).setFocused(false);
                selected = i;
            } else {
                ((TextFieldWrapper)entry).onKeyTyped(input);
            }
            handled = input.comp_4795() != 256;
            break;
        }
        if (!handled) {
            for (i = 0; i < this.textFieldsMultiLine.size(); ++i) {
                entry = this.textFieldsMultiLine.get(i);
                if (!((TextFieldMultiLineWrapper)entry).isFocused()) continue;
                if (input.comp_4795() == 258) {
                    ((TextFieldMultiLineWrapper)entry).setFocused(false);
                    selectedMultiLine = i;
                } else {
                    ((TextFieldMultiLineWrapper)entry).onKeyTyped(input);
                }
                handled = input.comp_4795() != 256;
                break;
            }
        }
        if (!handled) {
            for (WidgetBase widget : this.widgets) {
                if (!widget.onKeyTyped(input)) continue;
                handled = true;
                break;
            }
        }
        if (!handled && input.comp_4795() == 256) {
            this.closeGui(!input.method_74239());
            return true;
        }
        if (selected >= 0) {
            selected = input.method_74239() ? (selected > 0 ? selected - 1 : this.textFields.size() - 1) : (selected + 1) % this.textFields.size();
            this.textFields.get(selected).setFocused(true);
        }
        if (selectedMultiLine >= 0) {
            selectedMultiLine = input.method_74239() ? (selectedMultiLine > 0 ? selectedMultiLine - 1 : this.textFieldsMultiLine.size() - 1) : (selectedMultiLine + 1) % this.textFieldsMultiLine.size();
            this.textFieldsMultiLine.get(selectedMultiLine).setFocused(true);
        }
        return handled;
    }

    public boolean onCharTyped(class_11905 input) {
        boolean handled = false;
        for (TextFieldWrapper<? extends GuiTextFieldGeneric> textFieldWrapper : this.textFields) {
            if (!textFieldWrapper.onCharTyped(input)) continue;
            handled = true;
            break;
        }
        if (!handled) {
            for (TextFieldMultiLineWrapper textFieldMultiLineWrapper : this.textFieldsMultiLine) {
                if (!textFieldMultiLineWrapper.onCharTyped(input)) continue;
                handled = true;
                break;
            }
        }
        if (!handled) {
            for (WidgetBase widgetBase : this.widgets) {
                if (!widgetBase.onCharTyped(input)) continue;
                handled = true;
                break;
            }
        }
        return handled;
    }

    @Override
    public void setString(String string) {
        this.messageRenderer.addMessage(3000L, string, new Object[0]);
    }

    @Override
    public void addMessage(Message.MessageType type, String messageKey, Object ... args) {
        this.addGuiMessage(type, 5000, messageKey, args);
    }

    @Override
    public void addMessage(Message.MessageType type, int lifeTime, String messageKey, Object ... args) {
        this.addGuiMessage(type, lifeTime, messageKey, args);
    }

    public void addGuiMessage(Message.MessageType type, int displayTimeMs, String messageKey, Object ... args) {
        this.messageRenderer.addMessage(type, displayTimeMs, messageKey, args);
    }

    public void setNextMessageType(Message.MessageType type) {
        this.messageRenderer.setNextMessageType(type);
    }

    protected void drawGuiMessages(GuiContext ctx) {
        this.messageRenderer.drawMessages(ctx, this.field_22789 / 2, this.field_22790 / 2);
    }

    public <T extends ButtonBase> T addButton(T button, IButtonActionListener listener) {
        button.setActionListener(listener);
        this.buttons.add(button);
        return button;
    }

    public <T extends GuiTextFieldGeneric> TextFieldWrapper<T> addTextField(T textField, @Nullable ITextFieldListener<T> listener) {
        return this.addTextField(textField, listener, TextFieldType.STRING);
    }

    public <T extends GuiTextFieldGeneric> TextFieldWrapper<T> addTextField(T textField, @Nullable ITextFieldListener<T> listener, TextFieldType type) {
        TextFieldWrapper<T> wrapper = new TextFieldWrapper<T>(textField, listener, type);
        this.textFields.add(wrapper);
        return wrapper;
    }

    public <T extends GuiTextFieldMultiLine> TextFieldMultiLineWrapper<T> addTextFieldMultiLine(T textField, int lines, @Nullable ITextFieldMultiLineListener<T> listener) {
        TextFieldMultiLineWrapper<T> wrapper = new TextFieldMultiLineWrapper<T>(textField, lines, listener);
        this.textFieldsMultiLine.add(wrapper);
        return wrapper;
    }

    public <T extends WidgetBase> T addWidget(T widget) {
        this.widgets.add(widget);
        return widget;
    }

    public WidgetLabel addLabel(int x, int y, int width, int height, int textColor, String ... lines) {
        return this.addLabel(x, y, width, height, textColor, Arrays.asList(lines));
    }

    public WidgetLabel addLabel(int x, int y, int width, int height, int textColor, List<String> lines) {
        if (lines.size() > 0 && width == -1) {
            for (String line : lines) {
                width = Math.max(width, this.getStringWidth(line));
            }
        }
        return this.addWidget(new WidgetLabel(x, y, width, height, textColor, lines));
    }

    protected boolean removeWidget(WidgetBase widget) {
        if (widget != null && this.widgets.contains(widget)) {
            this.widgets.remove(widget);
            return true;
        }
        return false;
    }

    protected void clearElements() {
        this.method_37067();
        this.clearButtons();
        this.clearTextFields();
        this.clearTextFieldsMultiLine();
    }

    protected void method_37067() {
        this.widgets.clear();
    }

    protected void clearButtons() {
        this.buttons.clear();
    }

    protected void clearTextFields() {
        this.textFields.clear();
    }

    protected void clearTextFieldsMultiLine() {
        this.textFieldsMultiLine.clear();
    }

    protected void drawScreenBackground(GuiContext ctx, int mouseX, int mouseY) {
        RenderUtils.drawRect(ctx, 0, 0, this.field_22789, this.field_22790, -1342177280);
    }

    protected void drawTexturedBG(GuiContext ctx, int topX, int topY, int width, int height, boolean blur) {
        if (blur) {
            super.method_57734(ctx.getGuiGraphics());
        }
        super.method_57736(ctx.getGuiGraphics(), topX, topY, width, height);
    }

    protected void drawTitle(GuiContext ctx, int mouseX, int mouseY, float partialTicks) {
        this.drawString(ctx, this.getTitleString(), 20, 10, -1);
    }

    protected void drawContents(GuiContext ctx, int mouseX, int mouseY, float partialTicks) {
    }

    protected void drawButtons(GuiContext ctx, int mouseX, int mouseY, float partialTicks) {
        for (ButtonBase button : this.buttons) {
            button.render(ctx, mouseX, mouseY, button.isMouseOver());
        }
    }

    protected void drawTextFields(GuiContext ctx, int mouseX, int mouseY) {
        for (TextFieldWrapper<? extends GuiTextFieldGeneric> entry : this.textFields) {
            entry.draw(ctx, mouseX, mouseY);
        }
    }

    protected void drawTextFieldsMultiLine(GuiContext ctx, int mouseX, int mouseY) {
        for (TextFieldMultiLineWrapper<? extends GuiTextFieldMultiLine> entry : this.textFieldsMultiLine) {
            entry.draw(ctx, mouseX, mouseY);
        }
    }

    protected void drawWidgets(GuiContext ctx, int mouseX, int mouseY) {
        this.hoveredWidget = null;
        if (!this.widgets.isEmpty()) {
            for (WidgetBase widget : this.widgets) {
                widget.render(ctx, mouseX, mouseY, false);
                if (!widget.isMouseOver(mouseX, mouseY)) continue;
                this.hoveredWidget = widget;
            }
        }
    }

    protected void drawButtonHoverTexts(GuiContext ctx, int mouseX, int mouseY, float partialTicks) {
        if (!this.shouldRenderHoverStuff()) {
            return;
        }
        for (ButtonBase button : this.buttons) {
            if (!button.hasHoverText() || !button.isMouseOver()) continue;
            RenderUtils.drawHoverText(ctx, mouseX, mouseY, button.getHoverStrings());
        }
    }

    protected boolean shouldRenderHoverStuff() {
        return this.mc.field_1755 == this;
    }

    protected void drawHoveredWidget(GuiContext ctx, int mouseX, int mouseY) {
        if (!this.shouldRenderHoverStuff()) {
            return;
        }
        if (this.hoveredWidget != null) {
            this.hoveredWidget.postRenderHovered(ctx, mouseX, mouseY, false);
        }
    }

    public static boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public int getStringWidth(String text) {
        return this.font.method_1727(text);
    }

    public void drawString(GuiContext ctx, String text, int x, int y, int color) {
        ctx.method_51433(ctx.fontRenderer(), text, x, y, color, false);
    }

    public void drawStringWithShadow(GuiContext ctx, String text, int x, int y, int color) {
        ctx.method_25303(ctx.fontRenderer(), text, x, y, color);
    }

    public int getMaxPrettyNameLength(List<? extends IConfigBase> configs) {
        int width = 0;
        for (IConfigBase iConfigBase : configs) {
            width = Math.max(width, this.getStringWidth(iConfigBase.getConfigGuiDisplayName()));
        }
        return width;
    }

    public static void openGui(class_437 gui) {
        class_310.method_1551().method_1507(gui);
    }

    public static boolean isShiftDown() {
        return class_3675.method_15987((class_1041)class_310.method_1551().method_22683(), (int)340) || class_3675.method_15987((class_1041)class_310.method_1551().method_22683(), (int)344);
    }

    public static boolean isCtrlDown() {
        return class_156.method_668() == class_156.class_158.field_1137 ? class_3675.method_15987((class_1041)class_310.method_1551().method_22683(), (int)343) || class_3675.method_15987((class_1041)class_310.method_1551().method_22683(), (int)347) : class_3675.method_15987((class_1041)class_310.method_1551().method_22683(), (int)341) || class_3675.method_15987((class_1041)class_310.method_1551().method_22683(), (int)345);
    }

    public static boolean isAltDown() {
        return class_3675.method_15987((class_1041)class_310.method_1551().method_22683(), (int)342) || class_3675.method_15987((class_1041)class_310.method_1551().method_22683(), (int)346);
    }
}

