/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config.options;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.IConfigHotkey;
import fi.dy.masa.malilib.config.options.ConfigBase;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeybindMulti;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.Objects;

public class ConfigHotkey
extends ConfigBase<ConfigHotkey>
implements IHotkey,
IConfigHotkey {
    public static final Codec<ConfigHotkey> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PrimitiveCodec.STRING.fieldOf("name").forGetter(ConfigBase::getName), (App)PrimitiveCodec.STRING.fieldOf("defaultHotkey").forGetter(get -> get.keybind.getDefaultStringValue()), (App)KeybindSettings.CODEC.fieldOf("keybindSettings").forGetter(get -> get.keybind.getSettings()), (App)PrimitiveCodec.STRING.fieldOf("comment").forGetter(get -> get.comment), (App)PrimitiveCodec.STRING.fieldOf("prettyName").forGetter(get -> get.prettyName), (App)PrimitiveCodec.STRING.fieldOf("translatedName").forGetter(get -> get.translatedName)).apply((Applicative)instance, ConfigHotkey::new));
    private final IKeybind keybind;
    private String lastHotkey;

    public ConfigHotkey(String name, String defaultStorageString) {
        this(name, defaultStorageString, KeybindSettings.DEFAULT, name + " Comment?", StringUtils.splitCamelCase(name), name);
    }

    public ConfigHotkey(String name, String defaultStorageString, String comment) {
        this(name, defaultStorageString, KeybindSettings.DEFAULT, comment, StringUtils.splitCamelCase(name), name);
    }

    public ConfigHotkey(String name, String defaultStorageString, String comment, String prettyName) {
        this(name, defaultStorageString, KeybindSettings.DEFAULT, comment, prettyName, name);
    }

    public ConfigHotkey(String name, String defaultStorageString, String comment, String prettyName, String translatedName) {
        this(name, defaultStorageString, KeybindSettings.DEFAULT, comment, prettyName, translatedName);
    }

    public ConfigHotkey(String name, String defaultStorageString, KeybindSettings settings) {
        this(name, defaultStorageString, settings, name + " Comment?", StringUtils.splitCamelCase(name), name);
    }

    public ConfigHotkey(String name, String defaultStorageString, KeybindSettings settings, String comment) {
        this(name, defaultStorageString, settings, comment, StringUtils.splitCamelCase(name), name);
    }

    public ConfigHotkey(String name, String defaultStorageString, KeybindSettings settings, String comment, String prettyName) {
        this(name, defaultStorageString, settings, comment, prettyName, name);
    }

    public ConfigHotkey(String name, String defaultStorageString, KeybindSettings settings, String comment, String prettyName, String translatedName) {
        super(ConfigType.HOTKEY, name, comment, prettyName, translatedName);
        this.keybind = KeybindMulti.fromStorageString(defaultStorageString, settings);
        this.updateLastHotkeyStringValue();
    }

    @Override
    public IKeybind getKeybind() {
        return this.keybind;
    }

    @Override
    public String getStringValue() {
        return this.keybind.getStringValue();
    }

    @Override
    public String getDefaultStringValue() {
        return this.keybind.getDefaultStringValue();
    }

    @Override
    public void setValueFromString(String value) {
        this.updateLastHotkeyStringValue();
        String oldValue = this.keybind.getStringValue();
        this.keybind.setValueFromString(value);
        if (!oldValue.equals(this.keybind.getStringValue()) || this.isDirty()) {
            this.markClean();
            this.onValueChanged();
        }
    }

    @Override
    public String getHotkeyStringValue() {
        return this.getStringValue();
    }

    @Override
    public String getDefaultHotkeyStringValue() {
        return this.getDefaultStringValue();
    }

    @Override
    public void setHotkeyStringValue(String value) {
        this.setValueFromString(value);
    }

    @Override
    public String getLastHotkeyStringValue() {
        return this.lastHotkey;
    }

    @Override
    public boolean isModified() {
        return this.keybind.isModified();
    }

    @Override
    public boolean isModified(String newValue) {
        return this.keybind.isModified(newValue);
    }

    @Override
    public void resetToDefault() {
        this.updateLastHotkeyStringValue();
        this.keybind.resetToDefault();
        this.checkIfClean();
    }

    @Override
    public boolean isDirty() {
        return this.getKeybind().isDirty() || super.isDirty();
    }

    @Override
    public void markDirty() {
        super.markDirty();
        this.getKeybind().markDirty();
    }

    @Override
    public void markClean() {
        super.markClean();
        this.getKeybind().markClean();
    }

    @Override
    public void checkIfClean() {
        if (this.isDirty()) {
            this.markClean();
            this.onValueChanged();
        }
    }

    @Override
    public void updateLastHotkeyStringValue() {
        this.lastHotkey = this.keybind.getStringValue();
    }

    @Override
    public void setValueFromJsonElement(JsonElement element) {
        String oldValue = this.keybind.getStringValue();
        try {
            if (element.isJsonObject()) {
                this.keybind.setValueFromJsonElement(element);
            } else if (element.isJsonPrimitive()) {
                this.keybind.setValueFromString(element.getAsString());
            } else {
                MaLiLib.LOGGER.warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)this.getName(), (Object)element);
            }
            if (!Objects.equals(oldValue, this.keybind.getStringValue()) || this.isDirty()) {
                this.markClean();
                if (!Objects.equals(this.getLastHotkeyStringValue(), this.getHotkeyStringValue())) {
                    this.onValueChanged();
                    this.updateLastHotkeyStringValue();
                }
            }
        }
        catch (Exception e) {
            MaLiLib.LOGGER.warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)this.getName(), (Object)element, (Object)e);
        }
    }

    @Override
    public JsonElement getAsJsonElement() {
        return this.keybind.getAsJsonElement();
    }
}

