/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config.options;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.config.IHotkeyTogglable;
import fi.dy.masa.malilib.config.options.ConfigBase;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeyCallbackToggleBooleanConfigWithMessage;
import fi.dy.masa.malilib.hotkeys.KeybindMulti;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigBooleanHotkeyed
extends ConfigBoolean
implements IHotkeyTogglable {
    public static final Codec<ConfigBooleanHotkeyed> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PrimitiveCodec.STRING.fieldOf("name").forGetter(ConfigBase::getName), (App)PrimitiveCodec.BOOL.fieldOf("defaultValue").forGetter(ConfigBoolean::getDefaultBooleanValue), (App)PrimitiveCodec.BOOL.fieldOf("value").forGetter(ConfigBoolean::getBooleanValue), (App)PrimitiveCodec.STRING.fieldOf("defaultHotkey").forGetter(get -> get.keybind.getDefaultStringValue()), (App)KeybindSettings.CODEC.fieldOf("keybindSettings").forGetter(get -> get.keybind.getSettings()), (App)PrimitiveCodec.STRING.fieldOf("comment").forGetter(get -> get.comment), (App)PrimitiveCodec.STRING.fieldOf("prettyName").forGetter(get -> get.prettyName), (App)PrimitiveCodec.STRING.fieldOf("translatedName").forGetter(get -> get.translatedName)).apply((Applicative)instance, ConfigBooleanHotkeyed::new));
    protected final IKeybind keybind;
    private Pair<Boolean, String> lastBooleanHotkey;

    public ConfigBooleanHotkeyed(String name, boolean defaultValue, String defaultHotkey) {
        this(name, defaultValue, defaultHotkey, KeybindSettings.DEFAULT, name + " Comment?", StringUtils.splitCamelCase(name), name);
    }

    public ConfigBooleanHotkeyed(String name, boolean defaultValue, String defaultHotkey, String comment) {
        this(name, defaultValue, defaultHotkey, KeybindSettings.DEFAULT, comment, StringUtils.splitCamelCase(name), name);
    }

    public ConfigBooleanHotkeyed(String name, boolean defaultValue, String defaultHotkey, String comment, String prettyName) {
        this(name, defaultValue, defaultHotkey, KeybindSettings.DEFAULT, comment, prettyName, name);
    }

    public ConfigBooleanHotkeyed(String name, boolean defaultValue, String defaultHotkey, String comment, String prettyName, String translatedName) {
        this(name, defaultValue, defaultHotkey, KeybindSettings.DEFAULT, comment, prettyName, translatedName);
    }

    public ConfigBooleanHotkeyed(String name, boolean defaultValue, String defaultHotkey, KeybindSettings settings) {
        this(name, defaultValue, defaultHotkey, settings, name + " Comment?", StringUtils.splitCamelCase(name), name);
    }

    public ConfigBooleanHotkeyed(String name, boolean defaultValue, String defaultHotkey, KeybindSettings settings, String comment) {
        this(name, defaultValue, defaultHotkey, settings, comment, StringUtils.splitCamelCase(name), name);
    }

    public ConfigBooleanHotkeyed(String name, boolean defaultValue, String defaultHotkey, KeybindSettings settings, String comment, String prettyName) {
        this(name, defaultValue, defaultHotkey, settings, comment, prettyName, name);
    }

    public ConfigBooleanHotkeyed(String name, boolean defaultValue, String defaultHotkey, KeybindSettings settings, String comment, String prettyName, String translatedName) {
        super(name, defaultValue, comment, prettyName, translatedName);
        this.keybind = KeybindMulti.fromStorageString(defaultHotkey, settings);
        this.keybind.setCallback(new KeyCallbackToggleBooleanConfigWithMessage(this));
        this.updateLastBooleanHotkeyValue();
    }

    private ConfigBooleanHotkeyed(String name, boolean defaultValue, boolean value, String defaultHotkey, KeybindSettings settings, String comment, String prettyName, String translatedName) {
        this(name, defaultValue, defaultHotkey, settings, comment, prettyName, translatedName);
        this.setBooleanValue(value);
    }

    @Override
    public IKeybind getKeybind() {
        return this.keybind;
    }

    public String getDefaultHotkey() {
        return this.keybind.getDefaultStringValue();
    }

    @Override
    public ConfigBooleanHotkeyed translatedName(String translatedName) {
        return (ConfigBooleanHotkeyed)super.translatedName(translatedName);
    }

    @Override
    public ConfigBooleanHotkeyed apply(String translationPrefix) {
        return (ConfigBooleanHotkeyed)super.apply(translationPrefix);
    }

    @Override
    public boolean isModified() {
        return super.isModified() || this.getKeybind().isModified();
    }

    @Override
    public void toggleBooleanValue() {
        this.updateLastBooleanHotkeyValue();
        super.toggleBooleanValue();
    }

    @Override
    public void resetToDefault() {
        this.updateLastBooleanHotkeyValue();
        this.keybind.resetToDefault();
        super.resetToDefault();
    }

    @Override
    public Pair<Boolean, String> getBooleanHotkeyValue() {
        return Pair.of((Object)super.getBooleanValue(), (Object)this.getKeybind().getStringValue());
    }

    @Override
    public Pair<Boolean, String> getDefaultBooleanHotkeyValue() {
        return Pair.of((Object)this.getDefaultBooleanValue(), (Object)this.getKeybind().getDefaultStringValue());
    }

    @Override
    public void setBooleanHotkeyValue(Pair<Boolean, String> value) {
        this.updateLastBooleanHotkeyValue();
        this.setBooleanValue((Boolean)value.getLeft());
        this.getKeybind().setValueFromString((String)value.getRight());
    }

    @Override
    public Pair<Boolean, String> getLastBooleanHotkeyValue() {
        return this.lastBooleanHotkey;
    }

    @Override
    public void updateLastBooleanHotkeyValue() {
        this.lastBooleanHotkey = Pair.of((Object)this.getBooleanValue(), (Object)this.getKeybind().getStringValue());
    }

    @Override
    public boolean isDirty() {
        return this.getKeybind().isDirty() || super.isDirty();
    }

    @Override
    public void markDirty() {
        super.markDirty();
        this.getKeybind().markDirty();
    }

    @Override
    public void markClean() {
        super.markClean();
        this.getKeybind().markClean();
    }

    @Override
    public void checkIfClean() {
        if (this.isDirty()) {
            this.markClean();
            this.onValueChanged();
        }
    }

    @Override
    public void setValueFromJsonElement(JsonElement element) {
        boolean oldBool = this.getBooleanValue();
        String oldKeybind = this.getKeybind().getStringValue();
        try {
            if (element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                if (JsonUtils.hasBoolean(obj, "enabled")) {
                    super.setValueFromJsonElement(obj.get("enabled"));
                }
                if (JsonUtils.hasObject(obj, "hotkey")) {
                    JsonObject hotkeyObj = obj.getAsJsonObject("hotkey");
                    this.keybind.setValueFromJsonElement((JsonElement)hotkeyObj);
                }
            } else {
                super.setValueFromJsonElement(element);
            }
            Pair oldValue = Pair.of((Object)oldBool, (Object)oldKeybind);
            if (!oldValue.equals(this.getBooleanHotkeyValue()) || this.isDirty()) {
                this.markClean();
                if (!this.getLastBooleanHotkeyValue().equals(this.getBooleanHotkeyValue())) {
                    this.onValueChanged();
                }
            }
        }
        catch (Exception e) {
            MaLiLib.LOGGER.warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)this.getName(), (Object)element, (Object)e);
        }
    }

    @Override
    public JsonElement getAsJsonElement() {
        JsonObject obj = new JsonObject();
        obj.add("enabled", super.getAsJsonElement());
        obj.add("hotkey", this.getKeybind().getAsJsonElement());
        return obj;
    }
}

