/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config.options;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.config.IHotkeyTogglable;
import fi.dy.masa.malilib.config.options.ConfigBase;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeybindMulti;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;

public class BooleanHotkeyGuiWrapper
extends ConfigBoolean
implements IHotkeyTogglable {
    public static final Codec<BooleanHotkeyGuiWrapper> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PrimitiveCodec.STRING.fieldOf("name").forGetter(ConfigBase::getName), (App)PrimitiveCodec.BOOL.fieldOf("defaultValue").forGetter(get -> get.booleanConfig.getDefaultBooleanValue()), (App)PrimitiveCodec.BOOL.fieldOf("value").forGetter(get -> get.booleanConfig.getBooleanValue()), (App)PrimitiveCodec.STRING.fieldOf("defaultHotkey").forGetter(get -> get.keybind.getDefaultStringValue()), (App)KeybindSettings.CODEC.fieldOf("keybindSettings").forGetter(get -> get.keybind.getSettings()), (App)PrimitiveCodec.STRING.fieldOf("comment").forGetter(get -> get.comment), (App)PrimitiveCodec.STRING.fieldOf("prettyName").forGetter(get -> get.prettyName), (App)PrimitiveCodec.STRING.fieldOf("translatedName").forGetter(get -> get.translatedName)).apply((Applicative)instance, BooleanHotkeyGuiWrapper::new));
    protected final IConfigBoolean booleanConfig;
    protected final IKeybind keybind;
    private Pair<Boolean, String> lastBooleanHotkey;

    public BooleanHotkeyGuiWrapper(String name, IConfigBoolean booleanConfig, IKeybind keybind) {
        super(name, booleanConfig.getDefaultBooleanValue(), booleanConfig.getComment(), booleanConfig.getPrettyName(), booleanConfig.getTranslatedName());
        this.booleanConfig = booleanConfig;
        this.keybind = keybind;
        this.updateLastBooleanHotkeyValue();
    }

    private BooleanHotkeyGuiWrapper(String name, boolean defaultValue, boolean value, String defaultHotkey, KeybindSettings settings, String comment, String prettyName, String translatedName) {
        super(name, defaultValue, comment, prettyName, translatedName);
        this.booleanConfig = this;
        this.keybind = KeybindMulti.fromStorageString(defaultHotkey, settings);
        this.updateLastBooleanHotkeyValue();
    }

    @Override
    public boolean getBooleanValue() {
        return this.booleanConfig.getBooleanValue();
    }

    @Override
    public void setBooleanValue(boolean value) {
        this.updateLastBooleanHotkeyValue();
        boolean oldValue = this.booleanConfig.getBooleanValue();
        this.booleanConfig.setBooleanValue(value);
        if (oldValue != this.booleanConfig.getBooleanValue()) {
            this.markClean();
            this.onValueChanged();
        }
    }

    @Override
    public void toggleBooleanValue() {
        this.updateLastBooleanHotkeyValue();
        super.toggleBooleanValue();
    }

    @Override
    public BooleanHotkeyGuiWrapper translatedName(String translatedName) {
        return (BooleanHotkeyGuiWrapper)super.translatedName(translatedName);
    }

    @Override
    public BooleanHotkeyGuiWrapper apply(String translatePrefix) {
        return (BooleanHotkeyGuiWrapper)super.apply(translatePrefix);
    }

    @Override
    @Nullable
    public String getTranslatedName() {
        return this.booleanConfig.getTranslatedName();
    }

    @Override
    public boolean isModified() {
        return this.booleanConfig.isModified() || this.getKeybind().isModified();
    }

    @Override
    public void resetToDefault() {
        this.updateLastBooleanHotkeyValue();
        this.booleanConfig.resetToDefault();
        this.getKeybind().resetToDefault();
    }

    @Override
    public boolean isDirty() {
        return this.getKeybind().isDirty() || this.getBooleanConfig().isDirty() || super.isDirty();
    }

    @Override
    public void markDirty() {
        this.getBooleanConfig().markDirty();
        this.getKeybind().markDirty();
        super.markDirty();
    }

    @Override
    public void markClean() {
        this.getBooleanConfig().markClean();
        this.getKeybind().markClean();
        super.markClean();
    }

    @Override
    public void checkIfClean() {
        if (this.isDirty()) {
            this.markClean();
            this.onValueChanged();
        }
    }

    public IConfigBoolean getBooleanConfig() {
        return this.booleanConfig;
    }

    @Override
    public IKeybind getKeybind() {
        return this.keybind;
    }

    @Override
    public boolean getLastBooleanValue() {
        return (Boolean)this.getLastBooleanHotkeyValue().getLeft();
    }

    @Override
    public Pair<Boolean, String> getBooleanHotkeyValue() {
        return Pair.of((Object)this.booleanConfig.getBooleanValue(), (Object)this.keybind.getStringValue());
    }

    @Override
    public Pair<Boolean, String> getDefaultBooleanHotkeyValue() {
        return Pair.of((Object)this.booleanConfig.getDefaultBooleanValue(), (Object)this.keybind.getDefaultStringValue());
    }

    @Override
    public void setBooleanHotkeyValue(Pair<Boolean, String> value) {
        this.updateLastBooleanHotkeyValue();
        this.booleanConfig.setBooleanValue((Boolean)value.getLeft());
        this.keybind.setValueFromString((String)value.getRight());
    }

    @Override
    public Pair<Boolean, String> getLastBooleanHotkeyValue() {
        return this.lastBooleanHotkey;
    }

    @Override
    public void updateLastBooleanHotkeyValue() {
        this.lastBooleanHotkey = Pair.of((Object)this.booleanConfig.getBooleanValue(), (Object)this.keybind.getStringValue());
    }
}

