/*
 * Decompiled with CFR 0.152.
 */
package dzwdz.chat_heads;

import com.mojang.datafixers.util.Pair;
import dzwdz.chat_heads.Compat;
import dzwdz.chat_heads.ComponentProcessor;
import dzwdz.chat_heads.HeadData;
import dzwdz.chat_heads.config.ChatHeadsConfig;
import dzwdz.chat_heads.config.ChatHeadsConfigDefaults;
import dzwdz.chat_heads.config.ClothConfigCommonImpl;
import dzwdz.chat_heads.config.RenderPosition;
import dzwdz.chat_heads.config.SenderDetection;
import dzwdz.chat_heads.mixininterface.HeadRenderable;
import dzwdz.chat_heads.mixininterface.Ownable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import net.minecraft.class_1007;
import net.minecraft.class_1011;
import net.minecraft.class_10799;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_338;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_640;
import net.minecraft.class_7417;
import net.minecraft.class_7471;
import net.minecraft.class_9848;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

public class ChatHeads {
    public static final String MOD_ID = "chat_heads";
    public static final Pattern FORMAT_REGEX = Pattern.compile("\u00a7.");
    public static final Logger LOGGER = LogManager.getLogger((String)"chat_heads");
    public static final class_2960 DISABLE_RESOURCE = class_2960.method_60655((String)"chat_heads", (String)"disable");
    public static ChatHeadsConfig CONFIG = new ChatHeadsConfigDefaults();
    @NotNull
    public static HeadData lastSenderData = HeadData.EMPTY;
    public static boolean refreshing;
    @NotNull
    public static HeadData lineData;
    @NotNull
    public static HeadData refreshingLineData;
    public static volatile boolean serverSentUuid;
    public static volatile boolean serverDisabledChatHeads;
    public static final Set<class_2960> blendedHeadTextures;
    public static class_332 guiGraphics;
    public static class_338.class_12233 chatGraphicsAccess;
    public static boolean customHeadRendering;

    public static void init() {
        if (Compat.isClothConfigLoaded()) {
            ClothConfigCommonImpl.loadConfig();
        }
    }

    @NotNull
    public static HeadData getLineData() {
        return refreshing ? refreshingLineData : lineData;
    }

    public static void setLineData(@NotNull HeadData headData) {
        if (refreshing) {
            refreshingLineData = headData;
        } else {
            lineData = headData;
        }
    }

    public static void autoDetectAlias(class_2561 message) {
        String text = message.getString();
        int i = text.indexOf(" ");
        if (i == -1) {
            return;
        }
        String nickname = text.substring(0, i);
        if (!text.substring(i).startsWith(" is ")) {
            return;
        }
        String profileName = text.substring(i + " is ".length());
        if (profileName.contains(" ")) {
            return;
        }
        CONFIG.addNameAlias(nickname, profileName);
    }

    public static class_2561 handleAddedMessage(class_2561 originalMessage, @Nullable class_640 playerInfo) {
        HeadData headData;
        if (CONFIG.detectNameAliases()) {
            ChatHeads.autoDetectAlias(originalMessage);
        }
        lastSenderData = HeadData.EMPTY;
        if (serverDisabledChatHeads) {
            return originalMessage;
        }
        boolean forceHeuristic = ChatHeads.isShowcaseItemMessage(originalMessage);
        if (CONFIG.senderDetection() == SenderDetection.HEURISTIC_ONLY || forceHeuristic) {
            playerInfo = null;
        } else if (playerInfo != null) {
            serverSentUuid = true;
        } else if (CONFIG.senderDetection() == SenderDetection.UUID_ONLY || serverSentUuid && CONFIG.smartHeuristics()) {
            return originalMessage;
        }
        Pair<class_2561, HeadData> messageAndData = ChatHeads.detectPlayerAndAddChatHead(originalMessage, playerInfo);
        if (messageAndData == null) {
            return originalMessage;
        }
        class_2561 decoratedMessage = (class_2561)messageAndData.getFirst();
        lastSenderData = headData = (HeadData)messageAndData.getSecond();
        if (CONFIG.renderPosition() == RenderPosition.BEFORE_LINE) {
            return originalMessage;
        }
        return decoratedMessage;
    }

    @Nullable
    public static Pair<class_2561, HeadData> detectPlayerAndAddChatHead(class_2561 message, @Nullable class_640 givenPlayerInfo) {
        class_634 connection = class_310.method_1551().method_1562();
        if (connection == null) {
            return null;
        }
        PlayerInfoCache playerInfoCache = new PlayerInfoCache(connection);
        if (givenPlayerInfo != null) {
            playerInfoCache.addProfileName(givenPlayerInfo);
        } else {
            playerInfoCache.collectProfileNames();
        }
        ArrayList<class_2561> split = ComponentProcessor.split(message);
        if (ComponentProcessor.containsPlayerSprite(split)) {
            return null;
        }
        class_640 foundPlayerInfo = ComponentProcessor.addChatHeadForClickTellCommand(split, playerInfoCache);
        if (foundPlayerInfo != null) {
            return new Pair((Object)ComponentProcessor.join(split), (Object)HeadData.of(foundPlayerInfo));
        }
        if (givenPlayerInfo != null) {
            playerInfoCache.add(givenPlayerInfo);
        } else {
            playerInfoCache.collectAllNames();
        }
        foundPlayerInfo = ComponentProcessor.addChatHeadForPlayerName(split, playerInfoCache);
        if (foundPlayerInfo != null) {
            return new Pair((Object)ComponentProcessor.join(split), (Object)HeadData.of(foundPlayerInfo));
        }
        if (givenPlayerInfo != null) {
            class_5250 chatHead = ComponentProcessor.createChatHeadComponent(givenPlayerInfo, message);
            class_5250 decorated = class_2561.method_43473().method_10852((class_2561)chatHead).method_10852(message);
            return new Pair((Object)decorated, (Object)HeadData.of(givenPlayerInfo));
        }
        return null;
    }

    private static boolean isShowcaseItemMessage(class_2561 message) {
        class_2588 contents;
        class_7417 class_74172 = message.method_10851();
        return class_74172 instanceof class_2588 && Objects.equals((contents = (class_2588)class_74172).method_11022(), "showcaseitem.misc.shared_item");
    }

    @NotNull
    public static HeadData getHeadData(@NotNull class_303.class_7590 guiMessage) {
        return ((HeadRenderable)guiMessage).chatheads$getHeadData();
    }

    @NotNull
    public static HeadData getHeadData(@NotNull class_303 guiMessage) {
        return ((HeadRenderable)guiMessage).chatheads$getHeadData();
    }

    @Nullable
    public static class_640 getOwner(@NotNull class_7471 message) {
        return ((Ownable)message).chatheads$getOwner();
    }

    public static void setHeadData(@NotNull class_303 guiMessage, @NotNull HeadData data) {
        ((HeadRenderable)guiMessage).chatheads$setHeadData(data);
    }

    public static void setOwner(@NotNull class_7471 message, class_640 owner) {
        ((Ownable)message).chatheads$setOwner(owner);
    }

    public static boolean offsetChat(@NotNull HeadData headData) {
        if (CONFIG.renderPosition() != RenderPosition.BEFORE_LINE) {
            return false;
        }
        return headData != HeadData.EMPTY || CONFIG.offsetNonPlayerText() && !serverDisabledChatHeads;
    }

    public static int getChatOffset(@NotNull HeadData headData) {
        return ChatHeads.offsetChat(headData) ? ChatHeads.headWidth() : 0;
    }

    public static int getTextWidthDifference(@NotNull class_303.class_7590 guiMessage) {
        return ChatHeads.getTextWidthDifference(ChatHeads.getHeadData(guiMessage));
    }

    public static int getTextWidthDifference(@NotNull HeadData headData) {
        if (CONFIG.renderPosition() != RenderPosition.BEFORE_LINE) {
            return 0;
        }
        return headData != HeadData.EMPTY || ChatHeads.offsetChat(headData) ? ChatHeads.headWidth() : 0;
    }

    public static int headWidth() {
        return ChatHeads.headWidth(CONFIG.drawShadow());
    }

    public static int headWidth(boolean drawShadow) {
        return 10 + (drawShadow ? 1 : 0);
    }

    @NotNull
    public static HeadData scanForPlayerName(@NotNull String message, PlayerInfoCache playerInfoCache) {
        Map<Integer, List<String>> namesByFirstCharacter = playerInfoCache.createNamesByFirstCharacterMap();
        boolean insideWord = false;
        int[] messageSeq = message.codePoints().toArray();
        for (int i = 0; i < messageSeq.length; ++i) {
            int c = messageSeq[i];
            if (insideWord && ChatHeads.isWordCharacter(c)) continue;
            for (String name : namesByFirstCharacter.getOrDefault(c, List.of())) {
                boolean nameIsFollowedByWord;
                int[] nameSeq = name.codePoints().toArray();
                if (i + nameSeq.length - 1 >= messageSeq.length) continue;
                boolean nameEndsAsWord = ChatHeads.isWordCharacter(nameSeq[nameSeq.length - 1]);
                boolean bl = nameIsFollowedByWord = i + nameSeq.length < messageSeq.length && ChatHeads.isWordCharacter(messageSeq[i + nameSeq.length]);
                if (nameEndsAsWord && nameIsFollowedByWord || !ChatHeads.containsSubsequenceAt(messageSeq, i, nameSeq)) continue;
                return new HeadData(playerInfoCache.get(name), i);
            }
            insideWord = ChatHeads.isWordCharacter(c);
        }
        return HeadData.EMPTY;
    }

    private static boolean isWordCharacter(int codePoint) {
        return Character.isLetterOrDigit(codePoint) || codePoint == 95 || Character.getNumericValue(codePoint) != -1;
    }

    private static boolean containsSubsequenceAt(int[] sequence, int startIndex, int[] subsequence) {
        for (int j = 0; j < subsequence.length; ++j) {
            if (sequence[startIndex + j] == subsequence[j]) continue;
            return false;
        }
        return true;
    }

    public static class_1011 extractBlendedHead(class_1011 skin) {
        boolean isLegacy = skin.method_4307() / 2 == skin.method_4323();
        int xScale = skin.method_4307() / 64;
        int yScale = skin.method_4323() / (isLegacy ? 32 : 64);
        class_1011 head = new class_1011(8 * xScale, 8 * yScale, false);
        for (int y = 0; y < head.method_4323(); ++y) {
            for (int x = 0; x < head.method_4307(); ++x) {
                int headColor = skin.method_61940(8 * xScale + x, 8 * yScale + y);
                int hatColor = skin.method_61940(40 * xScale + x, 8 * yScale + y);
                head.method_61941(x, y, ChatHeads.blendColors(headColor, hatColor));
            }
        }
        return head;
    }

    public static int blendColors(int color1, int color2) {
        float a1 = (float)class_9848.method_61320((int)color1) / 255.0f;
        float r1 = (float)class_9848.method_61327((int)color1) / 255.0f;
        float g1 = (float)class_9848.method_61329((int)color1) / 255.0f;
        float b1 = (float)class_9848.method_61331((int)color1) / 255.0f;
        float a2 = (float)class_9848.method_61320((int)color2) / 255.0f;
        float r2 = (float)class_9848.method_61327((int)color2) / 255.0f;
        float g2 = (float)class_9848.method_61329((int)color2) / 255.0f;
        float b2 = (float)class_9848.method_61331((int)color2) / 255.0f;
        float a3 = a2 * a2 + (1.0f - a2) * a1;
        float r3 = a2 * r2 + (1.0f - a2) * r1;
        float g3 = a2 * g2 + (1.0f - a2) * g1;
        float b3 = a2 * b2 + (1.0f - a2) * b1;
        return class_9848.method_61324((int)((int)Math.clamp(a3 * 255.0f, 0.0f, 255.0f)), (int)((int)Math.clamp(r3 * 255.0f, 0.0f, 255.0f)), (int)((int)Math.clamp(g3 * 255.0f, 0.0f, 255.0f)), (int)((int)Math.clamp(b3 * 255.0f, 0.0f, 255.0f)));
    }

    public static class_2960 getBlendedHeadLocation(class_2960 skinLocation) {
        return class_2960.method_60655((String)MOD_ID, (String)skinLocation.method_12832());
    }

    public static void renderChatHead(class_332 guiGraphics, int x, int y, class_640 owner, float opacity) {
        ChatHeads.renderChatHead(guiGraphics, x, y, owner, opacity, CONFIG.drawShadow());
    }

    public static void renderChatHead(class_332 guiGraphics, int x, int y, class_640 owner, float opacity, boolean drawShadow) {
        boolean threeDee;
        class_2960 skinLocation = owner.method_52810().comp_1626().comp_3627();
        int color = class_9848.method_61317((float)opacity);
        int shadowColor = class_9848.method_61321((int)color, (float)0.25f);
        int shadowOffset = drawShadow ? -1 : 0;
        class_638 level = class_310.method_1551().field_1687;
        class_1657 player = level != null ? level.method_18470(owner.method_2966().id()) : null;
        boolean upsideDown = player != null && class_1007.method_74936((class_1657)player);
        boolean showHat = owner.method_65195();
        int yOffset = upsideDown ? 8 : 0;
        int yDirection = upsideDown ? -1 : 1;
        boolean bl = threeDee = CONFIG.threeDeeNess() != 0.0f;
        if (showHat && !threeDee && blendedHeadTextures.contains(skinLocation)) {
            if (drawShadow) {
                guiGraphics.method_25293(class_10799.field_56883, ChatHeads.getBlendedHeadLocation(skinLocation), x + 1, y, 0.0f, (float)yOffset, 8, 8, 8, yDirection * 8, 8, 8, shadowColor);
            }
            guiGraphics.method_25293(class_10799.field_56883, ChatHeads.getBlendedHeadLocation(skinLocation), x, y + shadowOffset, 0.0f, (float)yOffset, 8, 8, 8, yDirection * 8, 8, 8, color);
        } else {
            Matrix3x2fStack pose = guiGraphics.method_51448();
            BiConsumer<Integer, Integer> pushAndScale = (x0, y0) -> pose.pushMatrix().scaleAround(1.0f + CONFIG.threeDeeNess() * 0.25f, (float)x0.intValue() + 4.0f, (float)y0.intValue() + 4.0f);
            if (drawShadow) {
                guiGraphics.method_25293(class_10799.field_56883, skinLocation, x + 1, y, 8.0f, (float)(8 + yOffset), 8, 8, 8, yDirection * 8, 64, 64, shadowColor);
                if (showHat) {
                    if (threeDee) {
                        pushAndScale.accept(x + 1, y);
                    }
                    guiGraphics.method_25293(class_10799.field_56883, skinLocation, x + 1, y, 40.0f, (float)(8 + yOffset), 8, 8, 8, yDirection * 8, 64, 64, shadowColor);
                    if (threeDee) {
                        pose.popMatrix();
                    }
                }
            }
            guiGraphics.method_25293(class_10799.field_56883, skinLocation, x, y + shadowOffset, 8.0f, (float)(8 + yOffset), 8, 8, 8, yDirection * 8, 64, 64, color);
            if (showHat) {
                if (threeDee) {
                    pushAndScale.accept(x, y + shadowOffset);
                }
                guiGraphics.method_25293(class_10799.field_56883, skinLocation, x, y + shadowOffset, 40.0f, (float)(8 + yOffset), 8, 8, 8, yDirection * 8, 64, 64, color);
                if (threeDee) {
                    pose.popMatrix();
                }
            }
        }
    }

    static {
        lineData = HeadData.EMPTY;
        refreshingLineData = HeadData.EMPTY;
        serverSentUuid = false;
        serverDisabledChatHeads = false;
        blendedHeadTextures = new HashSet<class_2960>();
        guiGraphics = null;
        chatGraphicsAccess = null;
    }

    public static class PlayerInfoCache {
        private final class_634 connection;
        private final Map<String, class_640> playerInfos = new HashMap<String, class_640>();
        private boolean collectedProfileNames = false;
        private boolean collectedEverything = false;

        public PlayerInfoCache(@NotNull class_634 connection) {
            this.connection = connection;
        }

        public void collectProfileNames() {
            if (this.collectedProfileNames) {
                return;
            }
            this.collectedProfileNames = true;
            for (class_640 playerInfo : this.connection.method_2880()) {
                this.addProfileName(playerInfo);
            }
        }

        private void addProfileName(class_640 playerInfo) {
            String profileName = FORMAT_REGEX.matcher(playerInfo.method_2966().name()).replaceAll("");
            if (profileName.isEmpty()) {
                return;
            }
            this.playerInfos.put(profileName, playerInfo);
        }

        public void collectAllNames() {
            if (this.collectedEverything) {
                return;
            }
            this.collectedEverything = true;
            this.collectProfileNames();
            for (class_640 playerInfo : this.connection.method_2880()) {
                this.addDisplayName(playerInfo);
            }
            this.addNameAliases();
        }

        private void addNameAliases() {
            for (Map.Entry<String, String> entry : CONFIG.getNameAliases().entrySet()) {
                class_640 playerInfo = this.playerInfos.get(entry.getValue());
                if (playerInfo == null) continue;
                this.playerInfos.putIfAbsent(entry.getKey(), playerInfo);
            }
        }

        private void addDisplayName(class_640 playerInfo) {
            if (playerInfo.method_2971() != null) {
                String displayName = FORMAT_REGEX.matcher(playerInfo.method_2971().getString()).replaceAll("");
                if (displayName.isEmpty()) {
                    return;
                }
                this.playerInfos.putIfAbsent(displayName, playerInfo);
            }
        }

        public void add(class_640 playerInfo) {
            this.addProfileName(playerInfo);
            this.addDisplayName(playerInfo);
            this.addNameAliases();
        }

        public Map<Integer, List<String>> createNamesByFirstCharacterMap() {
            HashMap<Integer, List<String>> namesByFirstCharacter = new HashMap<Integer, List<String>>();
            for (String name : this.playerInfos.keySet()) {
                namesByFirstCharacter.compute(name.codePointAt(0), (key, value) -> {
                    if (value == null) {
                        value = new ArrayList<String>();
                    }
                    value.add(name);
                    return value;
                });
            }
            return namesByFirstCharacter;
        }

        @Nullable
        public class_640 get(@NotNull String name) {
            return this.playerInfos.get(name);
        }

        public Set<String> getNames() {
            return this.playerInfos.keySet();
        }
    }
}

