/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.viewport.frustum;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import net.caffeinemc.mods.sodium.client.render.viewport.frustum.Frustum;
import org.joml.FrustumIntersection;
import org.joml.Vector4f;

public final class SimpleFrustum
implements Frustum {
    private float nxX;
    private float nxY;
    private float nxZ;
    private float negNxW;
    private float pxX;
    private float pxY;
    private float pxZ;
    private float negPxW;
    private float nyX;
    private float nyY;
    private float nyZ;
    private float negNyW;
    private float pyX;
    private float pyY;
    private float pyZ;
    private float negPyW;
    private float nzX;
    private float nzY;
    private float nzZ;
    private float negNzW;
    private float pzX;
    private float pzY;
    private float pzZ;
    private float negPzW;
    private final FrustumIntersection frustum;
    private static final MethodHandle PLANES_GETTER;

    public SimpleFrustum(FrustumIntersection frustumIntersection) {
        Vector4f[] planes;
        this.frustum = frustumIntersection;
        try {
            planes = PLANES_GETTER.invokeExact(frustumIntersection);
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to access planes field in FrustumIntersection", e);
        }
        this.nxX = planes[0].x;
        this.nxY = planes[0].y;
        this.nxZ = planes[0].z;
        this.pxX = planes[1].x;
        this.pxY = planes[1].y;
        this.pxZ = planes[1].z;
        this.nyX = planes[2].x;
        this.nyY = planes[2].y;
        this.nyZ = planes[2].z;
        this.pyX = planes[3].x;
        this.pyY = planes[3].y;
        this.pyZ = planes[3].z;
        this.nzX = planes[4].x;
        this.nzY = planes[4].y;
        this.nzZ = planes[4].z;
        this.pzX = planes[5].x;
        this.pzY = planes[5].y;
        this.pzZ = planes[5].z;
        float size = 9.125f;
        this.negNxW = -(planes[0].w + this.nxX * (this.nxX < 0.0f ? -9.125f : 9.125f) + this.nxY * (this.nxY < 0.0f ? -9.125f : 9.125f) + this.nxZ * (this.nxZ < 0.0f ? -9.125f : 9.125f));
        this.negPxW = -(planes[1].w + this.pxX * (this.pxX < 0.0f ? -9.125f : 9.125f) + this.pxY * (this.pxY < 0.0f ? -9.125f : 9.125f) + this.pxZ * (this.pxZ < 0.0f ? -9.125f : 9.125f));
        this.negNyW = -(planes[2].w + this.nyX * (this.nyX < 0.0f ? -9.125f : 9.125f) + this.nyY * (this.nyY < 0.0f ? -9.125f : 9.125f) + this.nyZ * (this.nyZ < 0.0f ? -9.125f : 9.125f));
        this.negPyW = -(planes[3].w + this.pyX * (this.pyX < 0.0f ? -9.125f : 9.125f) + this.pyY * (this.pyY < 0.0f ? -9.125f : 9.125f) + this.pyZ * (this.pyZ < 0.0f ? -9.125f : 9.125f));
        this.negNzW = -(planes[4].w + this.nzX * (this.nzX < 0.0f ? -9.125f : 9.125f) + this.nzY * (this.nzY < 0.0f ? -9.125f : 9.125f) + this.nzZ * (this.nzZ < 0.0f ? -9.125f : 9.125f));
        this.negPzW = -(planes[5].w + this.pzX * (this.pzX < 0.0f ? -9.125f : 9.125f) + this.pzY * (this.pzY < 0.0f ? -9.125f : 9.125f) + this.pzZ * (this.pzZ < 0.0f ? -9.125f : 9.125f));
    }

    @Override
    public boolean testSection(float x, float y, float z) {
        return this.nxX * x + this.nxY * y + this.nxZ * z >= this.negNxW && this.pxX * x + this.pxY * y + this.pxZ * z >= this.negPxW && this.nyX * x + this.nyY * y + this.nyZ * z >= this.negNyW && this.pyX * x + this.pyY * y + this.pyZ * z >= this.negPyW && this.nzX * x + this.nzY * y + this.nzZ * z >= this.negNzW;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean testSectionExpanded(float floatOriginX, float floatOriginY, float floatOriginZ, float extend) {
        float minX = floatOriginX - extend;
        float maxX = floatOriginX + extend;
        float minY = floatOriginY - extend;
        float maxY = floatOriginY + extend;
        float minZ = floatOriginZ - extend;
        float maxZ = floatOriginZ + extend;
        float f = this.nxX * (this.nxX < 0.0f ? minX : maxX) + this.nxY * (this.nxY < 0.0f ? minY : maxY);
        float f2 = this.nxZ < 0.0f ? minZ : maxZ;
        if (!(f + this.nxZ * f2 >= this.negNxW)) return false;
        float f3 = this.pxX * (this.pxX < 0.0f ? minX : maxX) + this.pxY * (this.pxY < 0.0f ? minY : maxY);
        float f4 = this.pxZ < 0.0f ? minZ : maxZ;
        if (!(f3 + this.pxZ * f4 >= this.negPxW)) return false;
        float f5 = this.nyX * (this.nyX < 0.0f ? minX : maxX) + this.nyY * (this.nyY < 0.0f ? minY : maxY);
        float f6 = this.nyZ < 0.0f ? minZ : maxZ;
        if (!(f5 + this.nyZ * f6 >= this.negNyW)) return false;
        float f7 = this.pyX * (this.pyX < 0.0f ? minX : maxX) + this.pyY * (this.pyY < 0.0f ? minY : maxY);
        float f8 = this.pyZ < 0.0f ? minZ : maxZ;
        if (!(f7 + this.pyZ * f8 >= this.negPyW)) return false;
        float f9 = this.nzX * (this.nzX < 0.0f ? minX : maxX) + this.nzY * (this.nzY < 0.0f ? minY : maxY);
        float f10 = this.nzZ < 0.0f ? minZ : maxZ;
        if (!(f9 + this.nzZ * f10 >= this.negNzW)) return false;
        float f11 = this.pzX * (this.pzX < 0.0f ? minX : maxX) + this.pzY * (this.pzY < 0.0f ? minY : maxY);
        float f12 = this.pzZ < 0.0f ? minZ : maxZ;
        if (!(f11 + this.pzZ * f12 >= this.negPzW)) return false;
        return true;
    }

    @Override
    public boolean testAab(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        return this.frustum.testAab(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public int intersectAab(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        return this.frustum.intersectAab(minX, minY, minZ, maxX, maxY, maxZ);
    }

    static {
        try {
            Field field = FrustumIntersection.class.getDeclaredField("planes");
            field.setAccessible(true);
            PLANES_GETTER = MethodHandles.lookup().unreflectGetter(field);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Failed to find planes field in JOML", e);
        }
    }
}

